pro plot_rtres, data_file, num

; Plot xy residuals from orbital fit
;
; Format of datafile:
; O-C residuals (data - fit)
; date     dx       xO-C   xOC/dx dy      yO-C   yOC/dy


!P.font=0
!P.multi=0
!P.charsize=1.2
!P.charthick=2.0
!P.thick=2.0
!X.thick=2.0
!Y.thick=2.0
frac=1.0	;scale factor for adjusting size of plotting symbols

;read input from datafile

temp1 = 0d
temp2 = 0d
temp3 = 0d      ; temporary variables to read data from file
temp4 = 0d
temp5 = 0d
temp6 = 0d
temp7 = 0d

time = dblarr(num)
dpa = dblarr(num)
pares = dblarr(num)
pares_dpa = dblarr(num)
dsep = dblarr(num)
sepres = dblarr(num)
sepres_dsep = dblarr(num)

openr,lun,data_file,/get_lun

; read two header lines

temps = ' '
readf,lun,temps
readf,lun,temps

ans=' '
print,'Are residuals in arcsec or mas (a/m)?'
read,ans

if (ans eq 'a') then scale=1000.0 else scale=1.0

for i=0, num-1 do begin

        readf, lun, temp1, temp2, temp3, temp4, temp5, temp6, temp7

        time(i) = temp1
        dpa(i) = temp2
        pares(i) = temp3
        pares_dpa(i) = temp4
        dsep(i) = temp5
        sepres(i) = temp6
        sepres_dsep(i) = temp7

endfor

close,lun

;print, "Do you want to save plot as a postscript file?  (Type yes or no):"
pans = "yes"
;read,pans
; Set plotting device to ps if answer is yes
if (pans eq "yes") then begin
        set_plot, 'ps'
        device, /Color, Bits_per_pixel=8, filename='temp.eps',xsize=15,ysize=13.5,/encap
endif

!P.Multi=[0,1,2]

;plot, time, xres,psym=4,xtitle='Date',ytitle='x residuals (mas)',yrange=[-20,20]
;plot_err,time,xres,dx,num
;;oplot,[1996,2006],[0,0],linestyle=2
;oplot,[1994,2015],[0,0],linestyle=2
;
;plot, time, yres,psym=4,xtitle='Date',ytitle='y residuals (mas)',yrange=[-20,20]
;plot_err,time,yres,dy,num
;;oplot,[1996,2006],[0,0],linestyle=2
;oplot,[1994,2015],[0,0],linestyle=2

;dx=dx-dx +2
;dy=dy-dy +2

; Specify y-axis plotting range:
;yr = 10
;yr = 15
;yr = 20
;yr = 30
;yr = 40
;yr = 50

seprange = max(abs([sepres]))*scale
;seprange=1.5
;seprange=10.0
;seprange=12.0
;seprange = 60.0
;seprange = 40
;seprange = 80

parange = max(abs([pares]))
;parange = 0.1
;parange = 0.2
;parange = 2.0
;parange=2.0
;parange=80.0

trange = [min(time),max(time)]
;trange=[1996,2016]
;trange=[1994,2016]
;trange=[1995,2016]
;trange=[1995,2015]
;trange=[2000,2014]
;trange=[1997,2017]
;trange=[1930,1980]

if (ans eq 'a') then seplabel = 'Residuals in sep (arcsec)' $
else seplabel = 'Residuals in sep (mas)'
seplabel = 'Residuals in sep (mas)'

ploterror, time, pares, dpa,psym=4,xtitle='Date',ytitle='Residuals in PA (deg)',yrange=[-parange,parange],xrange=trange,xstyle=1,ystyle=1 
oplot,trange,[0,0],linestyle=2

ploterror, time, sepres*scale, dsep*scale,psym=4,xtitle='Date',ytitle=seplabel,yrange=[-seprange,seprange],xrange=trange,xstyle=1,ystyle=1
oplot,trange,[0,0],linestyle=2

; set plotting device back to terminal if previously saving to ps file
if (pans eq "yes") then begin 
        device, /close
        set_plot, 'x'
endif

;print,'value min max mean stddev'
;print,'RAres: ',min(abs(yres)),max(abs(yres)),mean(abs(yres)),stddev(abs(yres))
;print,'DECres:',min(abs(xres)),max(abs(xres)),mean(abs(xres)),stddev(abs(xres))


free_lun,lun
!P.Multi=0

; Flag measurements where res/sigma > 3

print,'Measurements where res/sigma > 3:'
print,"date        dpa     pa(O-C)  paOC/dpa    dsep  sep(O-C)   sepOC/dsep"
for i=0, num-1 do begin

   if ( (abs(pares_dpa(i)) gt 3.0) or (abs(sepres_dsep(i)) gt 3.0) ) then $
      print,format='(f8.3,f9.3,f10.3,f10.3,f8.3,f9.3,f9.3)', $
        time(i),dpa(i),pares(i),pares_dpa(i),dsep(i),sepres(i),sepres_dsep(i)
 
endfor

;stop,'Type .cont to continue'

end

;
;
;

pro plot_err, x, y, dy, N

; plot error bars associated with each data point
; Input
;       x: array of x values
;       y: array of y values
;       dy: erray of error in y values
;       N: number of data points


for i=0, N-1 do begin

        oplot, [x(i), x(i)], [y(i)-dy(i), y(i)+dy(i)]

endfor

end
