pro plot_xyres, data_file, num

; Plot xy residuals from orbital fit
;
; Format of datafile:
; O-C residuals (data - fit)
; date     dx       xO-C   xOC/dx dy      yO-C   yOC/dy

!P.font=0
!P.multi=0
!P.charsize=1.2
!P.charthick=2.0
!P.thick=2.0
!X.thick=2.0
!Y.thick=2.0
frac=1.0	;scale factor for adjusting size of plotting symbols

;read input from datafile

temp1 = 0d
temp2 = 0d
temp3 = 0d      ; temporary variables to read data from file
temp4 = 0d
temp5 = 0d
temp6 = 0d
temp7 = 0d

time = dblarr(num)
dx = dblarr(num)
xres = dblarr(num)
dy = dblarr(num)
yres = dblarr(num)

openr,lun,data_file,/get_lun

; read two header lines

temps = ' '
readf,lun,temps
readf,lun,temps

ans=' '
print,'Are residuals in arcsec or mas (a/m)?'
read,ans

if (ans eq 'a') then scale=1000.0 else scale=1.0

for i=0, num-1 do begin

        readf, lun, temp1, temp2, temp3, temp4, temp5, temp6, temp7

        time(i) = temp1
        dx(i) = temp2*scale
        xres(i) = temp3*scale
        dy(i) = temp5*scale
        yres(i) = temp6*scale

endfor

close,lun

;print, "Do you want to save plot as a postscript file?  (Type yes or no):"
pans = "yes"
;read,pans
; Set plotting device to ps if answer is yes
if (pans eq "yes") then begin
        set_plot, 'ps'
        device, /Color, Bits_per_pixel=8, filename='temp.eps',xsize=15,ysize=13.5,/encap
endif

!P.Multi=[0,1,2]

;plot, time, xres,psym=4,xtitle='Date',ytitle='x residuals (mas)',yrange=[-20,20]
;plot_err,time,xres,dx,num
;;oplot,[1996,2006],[0,0],linestyle=2
;oplot,[1994,2015],[0,0],linestyle=2
;
;plot, time, yres,psym=4,xtitle='Date',ytitle='y residuals (mas)',yrange=[-20,20]
;plot_err,time,yres,dy,num
;;oplot,[1996,2006],[0,0],linestyle=2
;oplot,[1994,2015],[0,0],linestyle=2

;dx=dx-dx +2
;dy=dy-dy +2

; Specify y-axis plotting range:
yr = max(abs([xres,yres]))
;yr = 10
;yr = 15
;yr = 20
;yr = 30
;yr = 40
;yr = 50
;yr = 80

trange = [min(time),max(time)]
;trange=[1995,2016]
;trange=[1995,2015]
;trange=[2000,2014]
;trange=[2000,2015]
;trange=[2002,2016]
;trange=[1997,2017]
;trange=[1930,1980]

plot, time, yres,psym=4,xtitle='Date',ytitle='Residuals in RA (mas)',yrange=[-yr,yr],xrange=trange,xstyle=1,ystyle=1 ;xrange=[1995,2014],xrange=[2000,2012]
plot_err,time,yres,dy,num
oplot,trange,[0,0],linestyle=2

plot, time, xres,psym=4,xtitle='Date',ytitle='Residuals in DEC (mas)',yrange=[-yr,yr],xrange=trange,xstyle=1,ystyle=1
plot_err,time,xres,dx,num
oplot,trange,[0,0],linestyle=2

; set plotting device back to terminal if previously saving to ps file
if (pans eq "yes") then begin 
        device, /close
        set_plot, 'x'
endif

print,'value min max mean stddev'
print,'RAres: ',min(abs(yres)),max(abs(yres)),mean(abs(yres)),stddev(abs(yres))
print,'DECres:',min(abs(xres)),max(abs(xres)),mean(abs(xres)),stddev(abs(xres))


free_lun,lun
!P.Multi=0

end

;
;
;

pro plot_err, x, y, dy, N

; plot error bars associated with each data point
; Input
;       x: array of x values
;       y: array of y values
;       dy: erray of error in y values
;       N: number of data points


for i=0, N-1 do begin

        oplot, [x(i), x(i)], [y(i)-dy(i), y(i)+dy(i)]

endfor

end
