pro propagate_PAerr, data_file, num

temp1 = 0d
temp2 = 0d
temp3 = 0d	; temporary variables to read data from file
temp4 = 0d

time = dblarr(num)
theta = dblarr(num)
dtheta = dblarr(num)
rho = dblarr(num)
drho = dblarr(num)

openr,lun,data_file,/get_lun


for i=0, num-1 do begin

	readf, lun, temp1, temp2, temp3, temp4, temp5

	time(i) = temp1
	theta(i) = temp2
        dtheta(i) = temp3
	rho(i) = temp4	
	drho(i) = temp5
	
endfor

close,lun

; convert theta and dtheta to radians

theta = theta*!dpi/180.0
dtheta = dtheta*!dpi/180.0

; convert data points to x and y coordinates

xarr = rho * cos(theta)	; x coordinate
yarr = rho * sin(theta)	; y coordinate

; propagate errors in sep and PA to x and y:
; under the assumption that dx = dy 

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; Show the work:
; dx/drho = cos(theta), dx/dtheta = -rho*sin(theta)
; dy/drho = sin(theta), dy/dtheta =  rho*cos(theta)
; (sigx)^2 = (dx/drho)^2 * (sigrho)^2 + (dx/dtheta)^2 * (sigtheta)^2
;          = cos(theta)^2 * sigrho^2 + rho^2 * sin(theta)^2 * sigtheta^2
; (sigy)^2 = (dy/drho)^2 * (sigrho)^2 + (dy/dtheta)^2 * (sigtheta)^2
;          = sin(theta)^2 *sigrho^2 + rho^2 * cos(theta)^2 * sigtheta^2
; Now set (sigx)^2 = (sigy)^2
; (cos(theta)^2 - sin(theta)^2)*sigrho^2
;   = (cos(theta)^2 - sin(theta)^2) * rho^2 * sigtheta^2
; sigtheta = sigrho/rho
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

; propagate errors to PA: 
;dtheta = cos(theta)^2*rho*drho/xarr^2
dtheta = drho/rho

dx = sqrt(cos(theta)^2*drho^2 + rho^2*sin(theta)^2*dtheta^2)
dy = sqrt(sin(theta)^2*drho^2 + rho^2*cos(theta)^2*dtheta^2)

print, 'Compare dx and dy (should be equal)'

print,'t x dx y dy'
for i=0,num-1 do print, time(i), xarr(i),dx(i),yarr(i),dy(i)

print,'t PA dPA sep dsep'
for i=0,num-1 do print,time(i),theta(i)*180.0/!dpi,dtheta(i)*180.0/!dpi,rho(i),drho(i)

openw,lun,data_file

;;;;;;;;;;;;;;;;;;;;;;;;;
;;;; Standard Format ;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;
for i=0,num-1 do printf,lun,format='(f9.4,f8.3,f7.3,f8.3,f6.3)',time(i),theta(i)*180.0/!dpi,dtheta(i)*180.0/!dpi,rho(i),drho(i)

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;; More decimal places ;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;for i=0,num-1 do printf,lun,format='(f9.4,f8.3,f7.3,f9.4,f7.4)',time(i),theta(i)*180.0/!dpi,dtheta(i)*180.0/!dpi,rho(i),drho(i)

;for i=0,num-1 do printf,lun,format='(f9.4,f9.3,f7.3,f8.3,f6.3)',time(i),theta(i)*180.0/!dpi,dtheta(i)*180.0/!dpi,rho(i),drho(i)

;for i=0,num-1 do printf,lun,format='(f9.4,f9.4,f7.4,f10.4,f7.4)',time(i),theta(i)*180.0/!dpi,dtheta(i)*180.0/!dpi,rho(i),drho(i)

; Significant figures for table
;for i=0,num-1 do printf,lun,format='(f9.4,f8.2,f6.2,f8.2,f6.2)',time(i),theta(i)*180.0/!dpi,dtheta(i)*180.0/!dpi,rho(i),drho(i)

;for i=0,num-1 do printf,lun,format='(f7.1,f6.1,f5.1,f6.3,f7.4)',time(i),theta(i)*180.0/!dpi,dtheta(i)*180.0/!dpi,rho(i),drho(i)

;for i=0,num-1 do printf,lun,format='(f9.4,f7.2,f6.2,f7.2,f6.2)',time(i),theta(i)*180.0/!dpi,dtheta(i)*180.0/!dpi,rho(i),drho(i)

;for i=0,num-1 do printf,lun,format='(f7.1,f8.2,f6.2,f7.3,f6.3)',time(i),theta(i)*180.0/!dpi,dtheta(i)*180.0/!dpi,rho(i),drho(i)

;for i=0,num-1 do printf,lun,format='(f9.4,f9.4,f6.3,f6.1,f4.1)',time(i),theta(i)*180.0/!dpi,dtheta(i)*180.0/!dpi,rho(i),drho(i)

;for i=0,num-1 do printf,lun,format='(f12.4,f10.5,f7.4,f10.7,f8.5)',time(i),theta(i)*180.0/!dpi,dtheta(i)*180.0/!dpi,rho(i),drho(i)

;stop

close,lun

free_lun,lun

end
