pro read_random_search_vbsb1_lunar_vshift, orbfile, fnum, orb_deg=orb_deg, parallax=parallax,ansyd=ansyd


; Read orbital parameters output from search_chi2_vbsb1_lunar_vshift.pro
; Make plots
;
; orbfile (result_chi_all):
; period,Tperi,ecc,major,inc,W_cap,w_low,K1,Vsys1,Vsys2,chi2
;
; orb_deg: set if angles (i, Omega, omega) are in degree
; parallax: in same units as separation
; ansyd: period in years (y) or days (d)

close,1

!P.font=0
!P.multi=0
!P.charsize=1.5
!P.charthick=2.0
!P.thick=2.0
!X.thick=2.0
!Y.thick=2.0
frac=1.0	;scale factor for adjusting size of plotting symbols

;loadct,0

; Set color table
;  red=1, green=2, blue=3

tvlct, [255,0,0], [0,255,0], [0,0,255], 1

; Set orb_deg keyword if i,Omega,omega in pte_file are already in degrees
; keyword_set returns True (1) if orb_deg is defined, False (0) if undefined

ans_deg = keyword_set(orb_deg)

;;;;;;;;;;;;;;;;;;;;;;;;;;
; Read in pte file names ;
;;;;;;;;;;;;;;;;;;;;;;;;;;

elLabel = ['P','T','e','a','i','Omega','omega']

openr,1,orbfile

period = 0d
Tperi = 0d
ecc = 0d
major = 0d
inc = 0d
W_cap = 0d
w_low = 0d
K1 = 0d
Vsys1 = 0d
Vsys2 = 0d
xchi = 0d

P_array = dblarr(fnum)
T_array = dblarr(fnum)
e_array = dblarr(fnum)
a_array = dblarr(fnum)
i_array = dblarr(fnum)
Wcap_array = dblarr(fnum)
wlow_array = dblarr(fnum)
K1_array = dblarr(fnum)
Vsys1_array = dblarr(fnum)
Vsys2_array = dblarr(fnum)
chi2_array = dblarr(fnum)
Mtot_array = dblarr(fnum)
Mratio_array = dblarr(fnum)
M1_array = dblarr(fnum)
M2_array = dblarr(fnum)

if (ansyd eq 'y') then yd = 1.0d
if (ansyd eq 'd') then yd = 1.0d/365.25

for j=0, fnum-1 do begin

   ; Read in P,T,e,a,i,W,w from pte_file

   readf, 1, period, Tperi, ecc, major, inc, W_cap, w_low, K1, Vsys1, Vsys2, xchi

   major = major;*1000.0

   EL = [period,Tperi,ecc,major,inc,W_cap,w_low]

   ; If i,Omega,omega are in degrees, then convert to radians:
   if (ans_deg) then begin
      inc = inc*!dpi/180.0
      W_cap = W_cap*!dpi/180.0
      w_low = w_low*!dpi/180.0
   endif

   P_array(j) = period
   T_array(j) = Tperi
   e_array(j) = ecc
   a_array(j) = major
   i_array(j) = 180.0*inc/!dpi
   Wcap_array(j) = 180.0*W_cap/!dpi
   wlow_array(j) = 180.0*w_low/!dpi
   K1_array(j) = K1
   Vsys1_array(j) = Vsys1
   Vsys2_array(j) = Vsys2
   chi2_array(j) = xchi         ; read chi2 in from data file

   ; calculate total mass of system
   Mtot_array(j) = major^3/parallax^3/(yd*period)^2

   Mratio_array(j) = 3.784229924d-5 * K1^3 * period * (1.0- ecc^2)^(1.5)
   
   M2_array(j) = 0.033573182d * major^2/ parallax^2*K1/(yd*period)/sin(inc)*sqrt(1.0 - ecc^2)

   M1_array(j) = major^3/parallax^3/(yd*period)^2 - M2_array(j)

endfor

close,1


print,"Error estimates: min max mean median stddev"
print,format='(%"P:    ",f10.4,f10.4,f10.4,f10.4,f10.4)', $
	min(P_array),max(P_array),mean(P_array),median(P_array),stddev(P_array)
print,format='(%"T:    ",f10.4,f10.4,f10.4,f10.4,f10.4)', $
	min(T_array),max(T_array),mean(T_array),median(T_array),stddev(T_array)
print,format='(%"e:    ",f10.6,f10.6,f10.6,f10.6,f10.6)', $
	min(e_array),max(e_array),mean(e_array),median(e_array),stddev(e_array)
print,format='(%"a:    ",f10.6,f10.6,f10.6,f10.6,f10.6)', $
	min(a_array),max(a_array),mean(a_array),median(a_array),stddev(a_array)
print,format='(%"i:    ",f10.4,f10.4,f10.4,f10.4,f10.4)', $
	min(i_array),max(i_array),mean(i_array),median(i_array),stddev(i_array)
print,format='(%"W:    ",f10.4,f10.4,f10.4,f10.4,f10.4)', $
	min(Wcap_array),max(Wcap_array),mean(Wcap_array), $
	median(Wcap_array),stddev(Wcap_array)
print,format='(%"w:    ",f10.4,f10.4,f10.4,f10.4,f10.4)', $
	min(wlow_array),max(wlow_array),mean(wlow_array), $
	median(wlow_array),stddev(wlow_array)
print,format='(%"K1:   ",f10.6,f10.6,f10.6,f10.6,f10.6)', $
	min(K1_array),max(K1_array),mean(K1_array),median(K1_array),stddev(K1_array)
print,format='(%"Vsys1:",f10.6,f10.6,f10.6,f10.6,f10.6)', $
	min(Vsys1_array),max(Vsys1_array),mean(Vsys1_array),median(Vsys1_array),stddev(Vsys1_array)
print,format='(%"Vsys2:",f10.6,f10.6,f10.6,f10.6,f10.6)', $
	min(Vsys2_array),max(Vsys2_array),mean(Vsys2_array),median(Vsys2_array),stddev(Vsys2_array)
print,format='(%"Mtot: ",f10.4,f10.4,f10.4,f10.4,f10.4)', $
	min(Mtot_array),max(Mtot_array),mean(Mtot_array),median(Mtot_array),stddev(Mtot_array)
print,format='(%"M1:   ",f10.4,f10.4,f10.4,f10.4,f10.4)', $
	min(M1_array),max(M1_array),mean(M1_array),median(M1_array),stddev(M1_array)
print,format='(%"M2:   ",f10.4,f10.4,f10.4,f10.4,f10.4)', $
	min(M2_array),max(M2_array),mean(M2_array),median(M2_array),stddev(M2_array)
print,format='(%"Mratio:",f10.4,f10.4,f10.4,f10.4,f10.4)', $
	min(Mratio_array),max(Mratio_array),mean(Mratio_array),median(Mratio_array),stddev(Mratio_array)


; Determine plotting ranges

Prange = max(P_array) - min(P_array)
Pmin = min(P_array)- 0.05*Prange   ;round(min(P_array) - 0.05*Prange)
Pmax = max(P_array)+ 0.05*Prange   ;round(max(P_array) + 0.05*Prange)
;Pmin=0.92
;Pmax=1.12

erange = max(e_array) - min(e_array)
emin = min(e_array) - 0.05*erange   ;round(100.0*(min(e_array) - 0.05*erange))/100.0
emax = max(e_array) + 0.05*erange   ;round(100.0*(max(e_array) + 0.05*erange))/100.0
if (emin lt 0.0) then emin = 0.0
if (emax gt 1.0) then emax = 1.0

arange = max(a_array) - min(a_array)
amin = min(a_array) - 0.05*arange   ;round(min(a_array) - 0.05*arange)
amax = max(a_array) + 0.05*arange   ;round(max(a_array) + 0.05*arange)
;amin=1.0
;amax=8.0

irange = max(i_array) - min(i_array)
imin = min(i_array) - 0.05*irange   ;round(min(i_array) - 0.05*irange)
imax = max(i_array) + 0.05*irange   ;round(max(i_array) + 0.05*irange)
;imin=0.0
;imax=180

Wcrange = max(Wcap_array) - min(Wcap_array)
Wcmin = min(Wcap_array) - 0.05*Wcrange   ;round(min(i_array) - 0.05*irange)
Wcmax = max(Wcap_array) + 0.05*Wcrange   ;round(max(i_array) + 0.05*irange)


; Remove solutions?
ans_rem = 0;0;1  ; yes = 1, no = 0

if (ans_rem) then begin

   P_full = P_array 
   T_full = T_array 
   e_full = e_array 
   a_full = a_array 
   i_full = i_array 
   Wcap_full = Wcap_array 
   wlow_full = wlow_array 
   chi2_full = chi2_array 

   ; Put in selection criteria here
   ind = where(e_array le 0.7)
   ;ind = where(P_array le 0.99)
   ;ind = where(P_array ge 1.02)

   P_array = P_array(ind)
   T_array = T_array(ind)
   e_array = e_array(ind)
   a_array = a_array(ind)
   i_array = i_array(ind)
   Wcap_array = Wcap_array(ind)
   wlow_array = wlow_array(ind)
   chi2_array = chi2_array(ind)


endif


; Color scheme: red   = 1-sigma (Deltachi2 = 1)
;		blue  = 2-sigma (Deltachi2 = 4)
;		green = 3-sigma (Deltachi2 = 9)
;


; Separate solutions into 1-, 2-, and 3- sigma intervals

chimin = min(chi2_array)

print,'Minimum chi2:',chimin

sig1 = where(chi2_array le (chimin+1.0), count1)
sig2 = where(chi2_array gt (chimin+1.0) and chi2_array le (chimin+4.0), count2)
sig3 = where(chi2_array gt (chimin+4.0) and chi2_array le (chimin+9.0), count3)

; Define user symbol to be closed circle
; Make a vector of 16 points, Z[i] = 2pi/16:
Z = findgen(17) * (!pi*2/16.)

fracsmall = 0.25

; Plot orbits as small filled circles
usersym, fracsmall*cos(Z), fracsmall*sin(Z), /fill



!P.font=0
!P.thick=2
!P.charthick=2.0
!P.charsize=1.2

set_plot, 'ps'
device, /Color, filename='temp_aP.eps',xsize=15,ysize=15,/encap

;amin=1.0
;amax=8.0
;Pmin=0.92
;Pmax=1.12

;amin=1.0
;amax=10.0
;Pmin=0.90
;Pmax=1.20

fractiny = 0.10
fracsmall = 0.25
fracmed=0.4
; Plot orbits as small filled circles
usersym, fracmed*cos(Z), fracmed*sin(Z), /fill

;asec = 1000.0 ; convert arsec to mas
 asec = 1.0 ; already in mas

plot, P_array, asec*a_array, psym=3, xtitle="P (yrs)",ytitle="a (mas)", /nodata, $
  xstyle=1, ystyle=1, xrange=[Pmin,Pmax],yrange=[amin,amax], $
  position=[0.12,0.1,0.98,0.98]
if (ans_rem) then begin
   usersym, fracsmall*cos(Z), fracsmall*sin(Z), /fill
   oplot, P_full, asec*a_full, psym=8
   usersym, fracmed*cos(Z), fracmed*sin(Z), /fill
endif
if (count3 gt 0) then oplot, P_array(sig3), asec*a_array(sig3), psym=8, color=2
if (count2 gt 0) then oplot, P_array(sig2), asec*a_array(sig2), psym=8, color=3
if (count1 gt 0) then oplot, P_array(sig1), asec*a_array(sig1), psym=8, color=1

device, /close
set_plot,'x'





!P.font=0
!P.thick=2
!P.charthick=2.0
!P.charsize=1.2

set_plot, 'ps'
device, /Color, filename='temp_aP_bw.eps',xsize=15,ysize=15,/encap

;amin=1.0
;amax=10.0
;Pmin=0.90
;Pmax=1.20


plot, P_array, asec*a_array, psym=3, xtitle="P (yrs)",ytitle="a (mas)", /nodata, $
  xstyle=1, ystyle=1, xrange=[Pmin,Pmax],yrange=[amin,amax], $
  position=[0.12,0.1,0.98,0.98]
if (count3 gt 0) then oplot, P_array(sig3), asec*a_array(sig3), psym=8;, color=2
if (count2 gt 0) then oplot, P_array(sig2), asec*a_array(sig2), psym=8;, color=3
if (count1 gt 0) then oplot, P_array(sig1), asec*a_array(sig1), psym=8;, color=1

device, /close
set_plot,'x'


nbin = 20

histo_P = histogram(P_array, locations=P_bin, nbins=nbin)
histo_T = histogram(T_array, locations=T_bin, nbins=nbin)
histo_e = histogram(e_array, locations=e_bin, nbins=nbin)
histo_a = histogram(a_array, locations=a_bin, nbins=nbin)
histo_i = histogram(i_array, locations=i_bin, nbins=nbin)
histo_Wcap = histogram(Wcap_array, locations=Wcap_bin, nbins=nbin)
histo_wlow = histogram(wlow_array, locations=wlow_bin, nbins=nbin)

set_plot, 'ps'
device, /Color, Bits_per_pixel=8, /encap, filename='temp_histo.eps',xsize=30,ysize=15
;device, /Color, Bits_per_pixel=8, filename='temp_histo.ps',xsize=15,ysize=15

!P.multi=[0,4,2]

plot,P_bin,histo_P,psym=10,xtitle=ellabel(0),ytitle='Number of Solutions'
plot,T_bin,histo_T,psym=10,xtitle=ellabel(1),ytitle='Number of Solutions'
plot,e_bin,histo_e,psym=10,xtitle=ellabel(2),ytitle='Number of Solutions'
plot,a_bin,histo_a,psym=10,xtitle=ellabel(3),ytitle='Number of Solutions'
plot,i_bin,histo_i,psym=10,xtitle=ellabel(4),ytitle='Number of Solutions'
plot,Wcap_bin,histo_Wcap,psym=10,xtitle=ellabel(5),ytitle='Number of Solutions'
plot,wlow_bin,histo_wlow,psym=10,xtitle=ellabel(6),ytitle='Number of Solutions'

device,/close
set_plot, 'x'



!P.charsize=1.5
!P.MULTI = [0,3,1]

!P.font=0
!P.thick=2
!P.charthick=2.0
!P.charsize=1.6

set_plot, 'ps'
device, /Color, filename='temp_orb.eps',xsize=30,ysize=10,/encap


plot, P_array, e_array, psym=3, xtitle="P (yrs)", ytitle="e", /nodata, $
  xstyle=1, ystyle=1, xrange=[Pmin,Pmax],yrange=[emin,emax], $
  position=[0.05,0.12,0.33,0.98]
if (count3 gt 0) then oplot, P_array(sig3), e_array(sig3), psym=8, color=2
if (count2 gt 0) then oplot, P_array(sig2), e_array(sig2), psym=8, color=3
if (count1 gt 0) then oplot, P_array(sig1), e_array(sig1), psym=8, color=1

plot, P_array, a_array, psym=3, xtitle="P (yrs)",ytitle="a (mas)", /nodata, $
  xstyle=1, ystyle=1, xrange=[Pmin,Pmax],yrange=[amin,amax], $
  position=[0.38,0.12,0.66,0.98]
if (count3 gt 0) then oplot, P_array(sig3), asec*a_array(sig3), psym=8, color=2
if (count2 gt 0) then oplot, P_array(sig2), asec*a_array(sig2), psym=8, color=3
if (count1 gt 0) then oplot, P_array(sig1), asec*a_array(sig1), psym=8, color=1

plot, a_array, i_array, psym=3, xtitle="a (mas)",ytitle="i (deg)", /nodata, $
  xstyle=1, ystyle=1, yrange=[imin,imax],xrange=[amin,amax], $
  position=[0.71,0.12,0.99,0.98]
if (count3 gt 0) then oplot, asec*a_array(sig3), i_array(sig3), psym=8, color=2
if (count2 gt 0) then oplot, asec*a_array(sig2), i_array(sig2), psym=8, color=3
if (count1 gt 0) then oplot, asec*a_array(sig1), i_array(sig1), psym=8, color=1

device, /close
set_plot,'x'


!P.Multi = 0

!P.font=0
!P.thick=2
!P.charthick=2.0
!P.charsize=1.2

set_plot, 'ps'
device, /Color, filename='temp_orb4.eps',xsize=20,ysize=20,/encap

plot, P_array, a_array, psym=3, xtitle="P (yrs)",ytitle="a (mas)", /nodata, $
  xstyle=1, ystyle=1, xrange=[Pmin,Pmax],yrange=[amin,amax], $
  position=[0.08,0.58,0.49,0.99], /noerase
if (count3 gt 0) then oplot, P_array(sig3), asec*a_array(sig3), psym=8, color=2
if (count2 gt 0) then oplot, P_array(sig2), asec*a_array(sig2), psym=8, color=3
if (count1 gt 0) then oplot, P_array(sig1), asec*a_array(sig1), psym=8, color=1

plot, i_array, a_array, psym=3, xtitle="i (deg)",ytitle="a (mas)", /nodata, $
  xstyle=1, ystyle=1, xrange=[imin,imax],yrange=[amin,amax], $
  position=[0.58,0.58,0.99,0.99], /noerase
if (count3 gt 0) then oplot, i_array(sig3), asec*a_array(sig3), psym=8, color=2
if (count2 gt 0) then oplot, i_array(sig2), asec*a_array(sig2), psym=8, color=3
if (count1 gt 0) then oplot, i_array(sig1), asec*a_array(sig1), psym=8, color=1

plot, e_array, P_array, psym=3, xtitle="P (yrs)", ytitle="e", /nodata, $
  xstyle=1, ystyle=1, xrange=[Pmin,Pmax],yrange=[emin,emax], $
  position=[0.08,0.08,0.49,0.49], /noerase
if (count3 gt 0) then oplot, P_array(sig3), e_array(sig3), psym=8, color=2
if (count2 gt 0) then oplot, P_array(sig2), e_array(sig2), psym=8, color=3
if (count1 gt 0) then oplot, P_array(sig1), e_array(sig1), psym=8, color=1

plot, i_array, e_array, psym=3, xtitle="i (deg)", ytitle="e", /nodata, $
  xstyle=1, ystyle=1, xrange=[imin,imax],yrange=[emin,emax], $
  position=[0.58,0.08,0.99,0.49], /noerase
if (count3 gt 0) then oplot, i_array(sig3), e_array(sig3), psym=8, color=2
if (count2 gt 0) then oplot, i_array(sig2), e_array(sig2), psym=8, color=3
if (count1 gt 0) then oplot, i_array(sig1), e_array(sig1), psym=8, color=1

device, /close
set_plot,'x'


!P.Multi = 0

!P.font=0
!P.thick=2
!P.charthick=2.0
!P.charsize=1.2

set_plot, 'ps'
device, /Color, filename='temp_orb5.eps',xsize=30,ysize=20,/encap

plot, P_array, a_array, psym=3, xtitle="P (yrs)",ytitle="a (mas)", /nodata, $
  xstyle=1, ystyle=1, xrange=[Pmin,Pmax],yrange=[amin,amax], $
  position=[0.06,0.58,0.33,0.99], /noerase
if (ans_rem) then begin
   usersym, fractiny*cos(Z), fractiny*sin(Z), /fill
   oplot, P_full, asec*a_full, psym=8
   usersym, fracsmall*cos(Z), fracsmall*sin(Z), /fill
endif
if (count3 gt 0) then oplot, P_array(sig3), asec*a_array(sig3), psym=8, color=2
if (count2 gt 0) then oplot, P_array(sig2), asec*a_array(sig2), psym=8, color=3
if (count1 gt 0) then oplot, P_array(sig1), asec*a_array(sig1), psym=8, color=1

plot, i_array, a_array, psym=3, xtitle="i (deg)",ytitle="a (mas)", /nodata, $
  xstyle=1, ystyle=1, xrange=[imin,imax],yrange=[amin,amax], $
  position=[0.39,0.58,0.66,0.99], /noerase
if (ans_rem) then begin
   usersym, fractiny*cos(Z), fractiny*sin(Z), /fill
   oplot, i_full, asec*a_full, psym=8
   usersym, fracsmall*cos(Z), fracsmall*sin(Z), /fill
endif
if (count3 gt 0) then oplot, i_array(sig3), asec*a_array(sig3), psym=8, color=2
if (count2 gt 0) then oplot, i_array(sig2), asec*a_array(sig2), psym=8, color=3
if (count1 gt 0) then oplot, i_array(sig1), asec*a_array(sig1), psym=8, color=1

plot, e_array, P_array, psym=3, xtitle="P (yrs)", ytitle="e", /nodata, $
  xstyle=1, ystyle=1, xrange=[Pmin,Pmax],yrange=[emin,emax], $
  position=[0.06,0.08,0.33,0.49], /noerase
if (ans_rem) then begin
   usersym, fractiny*cos(Z), fractiny*sin(Z), /fill
   oplot, P_full, e_full, psym=8
   usersym, fracsmall*cos(Z), fracsmall*sin(Z), /fill
endif
if (count3 gt 0) then oplot, P_array(sig3), e_array(sig3), psym=8, color=2
if (count2 gt 0) then oplot, P_array(sig2), e_array(sig2), psym=8, color=3
if (count1 gt 0) then oplot, P_array(sig1), e_array(sig1), psym=8, color=1

plot, i_array, e_array, psym=3, xtitle="i (deg)", ytitle="e", /nodata, $
  xstyle=1, ystyle=1, xrange=[imin,imax],yrange=[emin,emax], $
  position=[0.39,0.08,0.66,0.49], /noerase
if (ans_rem) then begin
   usersym, fractiny*cos(Z), fractiny*sin(Z), /fill
   oplot, i_full, e_full, psym=8
   usersym, fracsmall*cos(Z), fracsmall*sin(Z), /fill
endif
if (count3 gt 0) then oplot, i_array(sig3), e_array(sig3), psym=8, color=2
if (count2 gt 0) then oplot, i_array(sig2), e_array(sig2), psym=8, color=3
if (count1 gt 0) then oplot, i_array(sig1), e_array(sig1), psym=8, color=1

plot, a_array, e_array, psym=3, xtitle="a (mas)",ytitle="e", /nodata, $
  xstyle=1, ystyle=1, xrange=[amin,amax],yrange=[emin,emax], $
  position=[0.72,0.08,0.99,0.49], /noerase
if (ans_rem) then begin
   usersym, fractiny*cos(Z), fractiny*sin(Z), /fill
   oplot, asec*a_full, e_full, psym=8
   usersym, fracsmall*cos(Z), fracsmall*sin(Z), /fill
endif
if (count3 gt 0) then oplot, asec*a_array(sig3), e_array(sig3), psym=8, color=2
if (count2 gt 0) then oplot, asec*a_array(sig2), e_array(sig2), psym=8, color=3
if (count1 gt 0) then oplot, asec*a_array(sig1), e_array(sig1), psym=8, color=1

device, /close
set_plot,'x'



!P.Multi = 0


;print,'Parameter   Mean  Median  stdev'
;print,ellabel(0),mean(P_array),median(P_array),stdev(P_array)
;print,ellabel(1),mean(T_array),median(T_array),stdev(T_array)
;print,ellabel(2),mean(e_array),median(e_array),stdev(e_array)
;print,ellabel(3),mean(a_array),median(a_array),stdev(a_array)
;print,ellabel(4),mean(i_array),median(i_array),stdev(i_array)
;print,ellabel(5),mean(Wcap_array),median(Wcap_array),stdev(Wcap_array)
;print,ellabel(6),mean(wlow_array),median(wlow_array),stdev(wlow_array)


; Find solutions with minimum chi2
ind = where(chi2_array eq min(chi2_array))
ind = ind(0)
print,'Solution with minimum chi2:'
print,P_array(ind),T_array(ind),e_array(ind),a_array(ind),i_array(ind),Wcap_array(ind),wlow_array(ind),chi2_array(ind)

; Find solutions with minimum a and maximum a
ind = where(a_array eq min(a_array))
ind = ind(0)
print,'Solution with minimum a:'
print,P_array(ind),T_array(ind),e_array(ind),a_array(ind),i_array(ind),Wcap_array(ind),wlow_array(ind),chi2_array(ind)

ind = where(a_array eq max(a_array))
ind = ind(0)
print,'Solution with maximum a:'
print,P_array(ind),T_array(ind),e_array(ind),a_array(ind),i_array(ind),Wcap_array(ind),wlow_array(ind),chi2_array(ind)

; Find solutions with minimum i and maximum i
ind = where(i_array eq min(i_array))
ind = ind(0)
print,'Solution with minimum i:'
print,P_array(ind),T_array(ind),e_array(ind),a_array(ind),i_array(ind),Wcap_array(ind),wlow_array(ind),chi2_array(ind)

ind = where(i_array eq max(i_array))
ind = ind(0)
print,'Solution with maximum i:'
print,P_array(ind),T_array(ind),e_array(ind),a_array(ind),i_array(ind),Wcap_array(ind),wlow_array(ind),chi2_array(ind)

; Find solutions with minimum Omega and maximum Omega
ind = where(Wcap_array eq min(Wcap_array))
ind = ind(0)
print,'Solution with minimum Omega:'
print,P_array(ind),T_array(ind),e_array(ind),a_array(ind),i_array(ind),Wcap_array(ind),wlow_array(ind),chi2_array(ind)

ind = where(Wcap_array eq max(Wcap_array))
ind = ind(0)
print,'Solution with maximum Omega:'
print,P_array(ind),T_array(ind),e_array(ind),a_array(ind),i_array(ind),Wcap_array(ind),wlow_array(ind),chi2_array(ind)


stop,'Type .cont to continue'

end
