pro scale_pasep, data_file

; Scale uncertainties by multiplying by sqrt(chi2red) to force red_chi2 =1
; The code will prompt for the chi2 value for the uncertainty scaling.

close,1

; Scale the separations by a constant percentage?
; keyword_set returns True (1) if psf_name is defined, False (0) if undefined

ans_sep = keyword_set(scale_sep)


; Read in data points from data_file

temp1 = 0d
temp2 = 0d
temp3 = 0d	; temporary variables to read data from file
temp4 = 0d
temp5 = 0d

num=1000.0

time = dblarr(num)
theta = dblarr(num)
rho = dblarr(num)
dtheta = dblarr(num)
drho = dblarr(num)

openr,1,data_file

i = 0
while not EOF(1) do begin

	readf, 1, temp1, temp2, temp3, temp4, temp5

	time(i) = temp1
	theta(i) = temp2
	dtheta(i) = temp3
	rho(i) = temp4	
	drho(i) = temp5

        i = i + 1
endwhile
close,1
num = i
time = time(0:num-1)
theta = theta(0:num-1)
dtheta = dtheta(0:num-1)
rho = rho(0:num-1)
drho = drho(0:num-1)

chi2red = 0.0d
print,'Enter reduced chi2:'
read,chi2red


; convert theta and dtheta to radians

theta = theta*!dpi/180.0
dtheta = dtheta*!dpi/180.0

; convert data points to x and y coordinates

x = rho * cos(theta)	; x coordinate
y = rho * sin(theta)	; y coordinate

; propagate errors in sep and PA to x and y:

dx = sqrt(cos(theta)^2*drho^2 + rho^2*sin(theta)^2*dtheta^2)
dy = sqrt(sin(theta)^2*drho^2 + rho^2*cos(theta)^2*dtheta^2)

; Multiply sigma by sqrt(chi2red)
;
; To keep PA of error ellipse constant, scale uncertainties
; in x,y rather than sep,PA

dx_scale = sqrt(chi2red)*dx
dy_scale = sqrt(chi2red)*dy

; Now propagate back to dsep,dPA:

drho_scale = sqrt((y*dy_scale)^2 + (x*dx_scale)^2)/rho

dtheta_scale  = sqrt((dx_scale*y/x^2)^2 + (dy_scale/x)^2)*(cos(theta))^2

; convert theta and dtheta to degress

theta = theta*180.0/!dpi
dtheta = dtheta*180.0/!dpi
dtheta_scale = dtheta_scale*180.0/!dpi

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;; Significant figures and format for table ;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;print,'t sep dsep PA dPA'
for i=0,num-1 do print,format='(f10.4,f9.3,f7.3,f9.4,f9.5)',time(i),theta(i),dtheta_scale(i),rho(i),drho_scale(i)
;for i=0,num-1 do print,format='(f9.4,f10.4,f8.4,f9.4,f9.5)',time(i),theta(i),dtheta_scale(i),rho(i),drho_scale(i)

;stop,'Type .cont to continue'

end
