pro scale_pasep_ell, data_file, scale_sep=scale_sep 

; Scale uncertainties by multiplying by sqrt(chi2red) to force red_chi2 =1
; The code will prompt for the chi2 value for the uncertainty scaling.
;
; Optionally, set scale_sep to scale separations by a constant percentage
; (e.g., for varying wavelength calibration uncertainties). scale_sep
; can be positive or negative percentage.

close,1

; Scale the separations by a constant percentage?
; keyword_set returns True (1) if psf_name is defined, False (0) if undefined

ans_sep = keyword_set(scale_sep)

temp1 = 0d
temp2 = 0d
temp3 = 0d	; temporary variables to read data from file
temp4 = 0d
temp5 = 0d
temp6 = 0d

num=1000.0

time = dblarr(num)
theta = dblarr(num)
rho = dblarr(num)
dmajor = dblarr(num)
dminor = dblarr(num)
theta_err = dblarr(num)

openr,1,data_file

i = 0
while not EOF(1) do begin

	readf, 1, temp1, temp2, temp3, temp4, temp5, temp6

	time(i) = temp1
	theta(i) = temp2
	rho(i) = temp3	
	dmajor(i) = temp4
	dminor(i)= temp5
	theta_err(i) = temp6
	
        i = i + 1
endwhile
close,1
num = i
time = time(0:num-1)
theta = theta(0:num-1)
rho = rho(0:num-1)
dmajor = dmajor(0:num-1)
dminor = dminor(0:num-1)
theta_err = theta_err(0:num-1)

chi2red = 0.0d
print,'Enter reduced chi2:'
read,chi2red

if (ans_sep) then rho = rho*(1 + scale_sep)

; multiply sigma by sqrt(chi2red)

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;; Significant figures and format for table ;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;print,'t sep dsep PA dPA'
for i=0,num-1 do print,format='(f10.4,f11.5,f11.8,f11.8,f11.8,f11.6)',time(i),theta(i),rho(i),dmajor(i)*sqrt(chi2red),dminor(i)*sqrt(chi2red),theta_err(i)

end
