pro solve_lunar

; Solve actual separation and PA for binary based on two lunar
; occultation  projections.


pa1 = 0.0d
sep1 = 0.0d
dpa1 = 0.0d
dsep1 = 0.0d

pa2 = 0.0d
sep2 = 0.0d
dpa2 = 0.0d
dsep2 = 0.0d

print,'Enter sep and PA of first lunar occultation:'
read,sep1,pa1
print,'Enter errors:'
read,dsep1,dpa1

print,'Enter sep and PA of second lunar occultation:'
read,sep2,pa2
print,'Enter errors:'
read,dsep2,dpa2

; Convert PA from deg to radians
pa1 = pa1*!dpi/180.0
pa2 = pa2*!dpi/180.0

dpa1 = dpa1*!dpi/180.0
dpa2 = dpa2*!dpi/180.0

x1 = sep1*sin(pa1)
y1 = sep1*cos(pa1)

x2 = sep2*sin(pa2)
y2 = sep2*cos(pa2)

; Propagate errors:

dx1 = sqrt((sin(pa1)*dsep1)^2 + (sep1*cos(pa1)*dpa1)^2)
dy1 = sqrt((cos(pa1)*dsep1)^2 + (-sep1*sin(pa1)*dpa1)^2)

dx2 = sqrt((sin(pa2)*dsep2)^2 + (sep2*cos(pa2)*dpa2)^2)
dy2 = sqrt((cos(pa2)*dsep2)^2 + (-sep2*sin(pa2)*dpa2)^2)

; find equation of line perpendicular to projection going through (x,y)

pa1_perp = pa1 + !dpi/2.0
pa2_perp = pa2 + !dpi/2.0

inter1 = x1 - y1*tan(pa1_perp)
inter2 = x2 - y2*tan(pa2_perp)

dinter1 = sqrt( (dx1)^2 + (-tan(pa1_perp)*dy1)^2 + (-y1*dpa1*(1.0 + (tan(pa1_perp))^2))^2 )
dinter2 = sqrt( (dx2)^2 + (-tan(pa2_perp)*dy2)^2 + (-y2*dpa2*(1.0 + (tan(pa2_perp))^2))^2 )


ytrue = (inter2 - inter1)/(tan(pa1_perp) - tan(pa2_perp))
xtrue = tan(pa1_perp)*ytrue + inter1

dytrue = sqrt( (dinter1^2 + dinter2^2)/(tan(pa1_perp) - tan(pa2_perp))^2  $
               + (dpa1^2 * (inter2 - inter1)^2 * (1.0 + (tan(pa1_perp))^2)^2  $
               +  dpa2^2 * (inter2 - inter1)^2 * (1.0 + (tan(pa2_perp))^2)^2 )$
                 /(tan(pa1_perp) - tan(pa2_perp))^4 )

dxtrue = sqrt( (dytrue*tan(pa1_perp))^2 + dinter1^2 + (dpa1*ytrue*(1 + (tan(pa1_perp))^2))^2 )


patrue = atan(xtrue,ytrue)
septrue = sqrt(xtrue^2 + ytrue^2)


dseptrue = sqrt( (dxtrue*xtrue/septrue)^2 + (dytrue*ytrue/septrue)^2)

dpatrue = sqrt( (dxtrue/ytrue)^2 + (-xtrue/ytrue^2)^2 )/(1 + (xtrue/ytrue)^2)



print,'True sep and PA:'
print,septrue,patrue*180.0/!dpi
print,'Errors:'
print,dseptrue,dpatrue*180.0/!dpi

xmax = max(abs([x1,y1,x2,y2,xtrue,ytrue]))
xmax = xmax + 0.05*xmax


set_plot,'ps'

plot,[0,x1],[0,y1],xrange=[xmax,-xmax],yrange=[-xmax,xmax],/isotropic, $
     xstyle = 1, ystyle=1
oplot,[0,x2],[0,y2]

oplot,[x1,xtrue],[y1,ytrue],linestyle=1
oplot,[x2,xtrue],[y2,ytrue],linestyle=1

oplot,[xmax,-xmax],[0,0],linestyle=2
oplot,[0,0],[-xmax,xmax],linestyle=2

device,/close


set_plot,'x'

end
