;
; mean_flux.pro
;
; computes the mean flux in the middle channel and prints it.
;
; USAGE:
;	mean_flux, files, OUTFILE=outfile
;
; EXAMPLE:
;	mean_flux, file_search('PACMAN_LAB_DARK*[0-9].fits'), outfile='fluxdark.txt
;	mean_flux, file_search('PACMAN_LAB_FLAT*[0-9].fits'), outfile='fluxlab.txt
;	mean_flux, file_search('PACMAN_SKY_BACK*[0-9].fits'), outfile='fluxback.txt
;	mean_flux, file_search('PACMAN_SKY_FLAT*[0-9].fits'), outfile='fluxsky.txt
;
;
PRO mean_flux, files, OUTFILE=outfile

  if keyword_set(outfile) then begin
      openw,OUT,outfile,/get_lun
      print,"Writing to ",outfile
  endif else $
    OUT= -1	;; write to stdout

  printf,OUT,"Mean flux in channel 3:"

  for iFile=0,N_elements(files)-1 do begin
      ;print,Format='(A-80)',$
      ;  files[iFile]+" ------------------------------------------------------------------------"
      fbt = fbt_open(files[iFile])

      target= strtrim((fbt.fileobj->prihead())->getpar('HIERARCH ESO OBS TARG NAME'),2)

      data= fbt.IMAGING_DATA_FSUA->readrows()
      Nrows= N_elements(data)
      fluxA= (total(data.data1[2]) + total(data.data2[2]) + $
              total(data.data3[2]) + total(data.data4[2]) ) / float(4*Nrows)

      data= fbt.IMAGING_DATA_FSUB->readrows()
      Nrows= N_elements(data)
      fluxB= (total(data.data1[2]) + total(data.data2[2]) + $
              total(data.data3[2]) + total(data.data4[2]) ) / float(4*Nrows)

      printf,OUT,format='(A," ",A-20," FSUA:",F7.1," FSUB:",F7.1)',files[iFile],target,fluxA,fluxB

      fbt_close, fbt
  endfor

  if OUT gt 0 then free_lun,OUT
end
