function read_fit_ext, fits_frame, ext_number, rows_number
;this function is provided with FITS_frame to read and the Extension number to read
;output: data structure with the data from the extension and the number of rows of the extension
output_data = mrdfits(fits_frame, ext_number)
data_size = SIZE(output_data)
rows_number = data_size[1]
return, output_data
end

FUNCTION phasediff_rainer, real1,imag1, real2,imag2


     cor = real1 * real2 + imag1 * imag2
     coi = imag1 * real2 - real1 * imag2
     ;coi = imag2 * real1 - real2 * imag1
     offset = atan(total(coi),total(cor))
return, offset
 
end


PRO skyoffsets

dummy=""
OPENR, frames, 'frames.dat', /GET_LUN 
framename=""
break=""
WHILE ~ EOF(frames) DO BEGIN
if break eq "n" then GOTO, LEAVE
READF, frames, framename
print, "Processing file ",framename
;read in header
header_read=MRDFITS(framename,0,header)
target_ind = where(strmatch(header,'OBJECT*') eq 1)
target = string(STRMID(header[target_ind],1+STRPOS(header[target_ind],"'"),(STRPOS(header[target_ind],"'",/REVERSE_SEARCH)-1-STRPOS(header[target_ind],"'"))))

FSUoneID_ind = where(strmatch(header,'HIERARCH ESO ISS PRI FSU1 ID*') eq 1)
FSUoneID = string(STRMID(header[FSUoneID_ind],1+STRPOS(header[FSUoneID_ind],"'"),(STRPOS(header[FSUoneID_ind],"'",/REVERSE_SEARCH)-1-STRPOS(header[FSUoneID_ind],"'"))))

FSUtwoID_ind = where(strmatch(header,'HIERARCH ESO ISS PRI FSU2 ID*') eq 1)
FSUtwoID = string(STRMID(header[FSUtwoID_ind],1+STRPOS(header[FSUtwoID_ind],"'"),(STRPOS(header[FSUtwoID_ind],"'",/REVERSE_SEARCH)-1-STRPOS(header[FSUtwoID_ind],"'"))))
print, "original target: ",target
print, "FSU1_ID        : ",FSUoneID
print, "FSU2_ID        : ",FSUtwoID
;check if to use the framename
plotdata=""
READ, plotdata, PROMPT='Plotting data? [y/n] (yes by default - if no, then file will not be processed any further!!!)'
if plotdata ne "n" then begin
device, true=24,decompose=0,retain=2
loadct, 12, /SILENT
;colors goodto use: 
;48 - green
;80 - light blue
;96 - deep blue
;128 - magenta
;176 - red

;check if to use FSUA and/or FSUB
imagA=read_fit_ext(framename,9,rows_imagA)
imagB=read_fit_ext(framename,10,rows_imagB)
metroA=read_fit_ext(framename,11,rows_metroA)
metroB=read_fit_ext(framename,12,rows_metroB)
; now FSUA and FSUB data will be replotted within different ranges until user can decide if to use the FSU

for fsu=0 , 1 do begin
; point to FSUA or FSUB depending on index fsu
; do anything on the data here
if fsu eq 0 then begin
imagdata=imagA
rows_imag=rows_imagA
metro=metroA
fsuname="FSU_A"
endif
if fsu eq 1 then begin
imagdata=imagB
rows_imag=rows_imagB
metro=metroB
fsuname="FSU_B"
endif
;whether to use the fsu data or not
;first look on metro
title="Metrology of "+fsuname
plot, metro[*].(0),metro[*].(1), /XSTYLE, /YSTYLE, XTITLE='time', YTITLE='delta L',TITLE=title
READ, dummy, PROMPT='Press ENTER to continue. ' 
plot_min_ind=0
plot_max_ind=WHERE(imagdata[*].(0) eq MAX(imagdata[*].(0)))
plot_min=imagdata[plot_min_ind].(0)
plot_max=imagdata[plot_max_ind].(0)
replot="y"
replot_vis="y"
replot_phase="y"
replot_all="y"
while replot_all eq "y" do begin
; maybe a better look on a first visibility (and or phase) estimate will give an idea about where to look for the fringes
X_one =imagdata[*].(5)(1)-imagdata[*].(7)(1)
Y_one =imagdata[*].(6)(1)-imagdata[*].(8)(1)
;total_one=imagdata[*].(5)(1)+imagdata[*].(6)(1)+imagdata[*].(7)(1)+imagdata[*].(8)(1)
X_five=imagdata[*].(5)(5)-imagdata[*].(7)(5)
Y_five=imagdata[*].(6)(5)-imagdata[*].(8)(5)
;total_five=imagdata[*].(5)(5)+imagdata[*].(6)(5)+imagdata[*].(7)(5)+imagdata[*].(8)(5)
phase_one =atan(Y_one,X_one)/!DPI
phase_five=atan(Y_five,X_five)/!DPI
vis_one =sqrt(X_one*X_one+Y_one*Y_one);/(total_one*total_one))
vis_five=sqrt(X_five*X_five+Y_five*Y_five);/(total_five*total_five))
;maxind=WHERE(vis_one eq MAX(vis_one))
;maxvis=MAX(vis_one)
;print, maxvis,vis_one[maxind], X_one[maxind],Y_one[maxind],total_one[maxind],imagdata[maxind].(5)(1),imagdata[maxind].(6)(1),imagdata[maxind].(7)(1),imagdata[maxind].(8)(1)
;visibility
while replot_vis eq "y" do begin
plot, imagdata[plot_min_ind:plot_max_ind].(0),vis_one[plot_min_ind:plot_max_ind],/XSTYLE, /YSTYLE, XTITLE='time', YTITLE='visibility'
READ, dummy, PROMPT='Presse ENTER to overplot with channel 5 ' 
oplot, imagdata[plot_min_ind:plot_max_ind].(0),vis_five[plot_min_ind:plot_max_ind],color=176

READ, replot_vis, PROMPT='Replot the data with different XRANGE? [y/n] '
if replot_vis eq "y" then begin
; set new range
READ, xmin_new, PROMPT='Provide new XMIN : (> '+STRTRIM(STRING(MIN(imagdata[*].(0))),1)+')  '
READ, xmax_new, PROMPT='Provide new XMAX : (< '+STRTRIM(STRING(MAX(imagdata[*].(0))),1)+')  '
plot_min_ind=MIN(WHERE(imagdata[*].(0) gt xmin_new AND imagdata[*].(0) ne 0.0d))
plot_max_ind=MAX(WHERE(imagdata[*].(0) lt xmax_new AND imagdata[*].(0) ne 0.0d))
plot_min=imagdata[plot_min_ind].(0)
plot_max=imagdata[plot_max_ind].(0)
; all set up for new plot
endif
endwhile
;phase
while replot_phase eq "y" do begin
plot, imagdata[plot_min_ind:plot_max_ind].(0),phase_one[plot_min_ind:plot_max_ind],/XSTYLE, YRANGE=[-1.0d,1.0d], XTITLE='time', YTITLE='phase / pi'
READ, dummy, PROMPT='Presse ENTER to overplot with channel 5 ' 
oplot, imagdata[plot_min_ind:plot_max_ind].(0),phase_five[plot_min_ind:plot_max_ind],color=176

READ, replot_phase, PROMPT='Replot the data with different XRANGE? [y/n] '
if replot_phase eq "y" then begin
; set new range
READ, xmin_new, PROMPT='Provide new XMIN : (> '+STRTRIM(STRING(MIN(imagdata[*].(0))),1)+')  '
READ, xmax_new, PROMPT='Provide new XMAX : (< '+STRTRIM(STRING(MAX(imagdata[*].(0))),1)+')  '
plot_min_ind=MIN(WHERE(imagdata[*].(0) gt xmin_new AND imagdata[*].(0) ne 0.0d))
plot_max_ind=MAX(WHERE(imagdata[*].(0) lt xmax_new AND imagdata[*].(0) ne 0.0d))
plot_min=imagdata[plot_min_ind].(0)
plot_max=imagdata[plot_max_ind].(0)
; all set up for new plot
endif
endwhile

; here the plotting will be performed on channel1 and cannel5 of A
while replot eq "y" do begin
plot, imagdata[plot_min_ind:plot_max_ind].(0),imagdata[plot_min_ind:plot_max_ind].(5)(1),/XSTYLE, /YSTYLE, XTITLE='time', YTITLE='counts'
;if replot eq "stupid" then plot, imagdata[plot_min_ind:plot_max_ind].(0),imagdata[plot_min_ind:plot_max_ind].(5)(1),/XSTYLE, /YSTYLE, XTITLE='time', YTITLE='counts'
;if replot ne "stupid" then plot, imagdata[plot_min_ind:plot_max_ind].(0),imagdata[plot_min_ind:plot_max_ind].(5)(1),XRANGE=[plot_min,plot_max], /YSTYLE, XTITLE='time', YTITLE='counts'
print, "XRANGE = [",plot_min,";",plot_max,"]"
READ, dummy, PROMPT='Presse ENTER to overplot with channel 5 ' 
oplot, imagdata[plot_min_ind:plot_max_ind].(0),imagdata[plot_min_ind:plot_max_ind].(5)(5),color=176
READ, replot, PROMPT='Replot the data with different XRANGE? [y/n] '
if replot eq "y" then begin
; set new range
READ, xmin_new, PROMPT='Provide new XMIN : (> '+STRTRIM(STRING(MIN(imagdata[*].(0))),1)+')  '
READ, xmax_new, PROMPT='Provide new XMAX : (< '+STRTRIM(STRING(MAX(imagdata[*].(0))),1)+')  '
plot_min_ind=MIN(WHERE(imagdata[*].(0) gt xmin_new AND imagdata[*].(0) ne 0.0d))
plot_max_ind=MAX(WHERE(imagdata[*].(0) lt xmax_new AND imagdata[*].(0) ne 0.0d))
plot_min=imagdata[plot_min_ind].(0)
plot_max=imagdata[plot_max_ind].(0)
; all set up for new plot
endif
endwhile
READ, replot_all, PROMPT='Replot the data with the new XRANGE? [y/n] '
if replot_all eq "y" then begin
replot="y"
replot_vis="y"
replot_phase="y"
reset_range=""
READ, reset_range, PROMPT='Do you want to reset the range? [y/n] '
if reset_range eq "y" then begin
plot_min_ind=0
plot_max_ind=WHERE(imagdata[*].(0) eq MAX(imagdata[*].(0)))
plot_min=imagdata[plot_min_ind].(0)
plot_max=imagdata[plot_max_ind].(0)
endif
endif
endwhile
; left the loop means that no more replot -> decide whether to use the FSU or not
usefsu=""
READ, usefsu, PROMPT='Do you want to compute offsets from this data? [y/n] '
if usefsu ne "n" then begin
;being here means that data will be analyzed
openw, result_A,'obs_generic_offsets_FSUA.csv', bufsize=1024, width=240,/APPEND ,/get_lun
openw, result_B,'obs_generic_offsets_FSUB.csv', bufsize=1024, width=240,/APPEND ,/get_lun


;plot the signals to file for each channel (ABCD overplotted)
psfilename=STRSPLIT(framename,'.fits',/EXTRACT)+"_"+fsuname+"_signal.ps"
set_plot, 'PS'
device, filename=psfilename,FONT_SIZE=10, /COLOR, /PORTRAIT,XSIZE=19,YSIZE=28, XOFFSET=2, YOFFSET=2; , xsize=10.0, ysize=7.0, yoffset=12.0
TVLCT, [0,255,0,0], [0,0,255,0], [0,0,0,255]
!P.MULTI = [0, 1, 3] 
for channels = 0, 5 do begin
range_A=MAX(imagdata[plot_min_ind:plot_max_ind].(5)(channels))-MIN(imagdata[plot_min_ind:plot_max_ind].(5)(channels))
range_B=MAX(imagdata[plot_min_ind:plot_max_ind].(6)(channels))-MIN(imagdata[plot_min_ind:plot_max_ind].(6)(channels))
range_C=MAX(imagdata[plot_min_ind:plot_max_ind].(7)(channels))-MIN(imagdata[plot_min_ind:plot_max_ind].(7)(channels))
range_D=MAX(imagdata[plot_min_ind:plot_max_ind].(8)(channels))-MIN(imagdata[plot_min_ind:plot_max_ind].(8)(channels))
title="IMAGING_DATA  -  Channel "+STRING(channels)
plot, imagdata[plot_min_ind:plot_max_ind].(0),((imagdata[plot_min_ind:plot_max_ind].(5)(channels)-MIN(imagdata[plot_min_ind:plot_max_ind].(5)(channels)))/range_A),/XSTYLE,/YSTYLE,XTITLE = 'time / microsec',YTITLE = 'normalized ADU',TITLE=title
oplot, imagdata[plot_min_ind:plot_max_ind].(0),((imagdata[plot_min_ind:plot_max_ind].(6)(channels)-MIN(imagdata[plot_min_ind:plot_max_ind].(6)(channels)))/range_B),COLOR=1
oplot, imagdata[plot_min_ind:plot_max_ind].(0),((imagdata[plot_min_ind:plot_max_ind].(7)(channels)-MIN(imagdata[plot_min_ind:plot_max_ind].(7)(channels)))/range_C),COLOR=2
oplot, imagdata[plot_min_ind:plot_max_ind].(0),((imagdata[plot_min_ind:plot_max_ind].(8)(channels)-MIN(imagdata[plot_min_ind:plot_max_ind].(8)(channels)))/range_D),COLOR=3
legend,['A','B','C','D'],linestyle=0,colors=[0,1,2,3],textcolor=0
endfor
device, /close
set_plot, 'X'
!P.MULTI = [0, 1, 1] 

; get the offsets AB BC CD AC AD BD for each channel and write them to file
time_min_ind=plot_min_ind
time_max_ind=plot_max_ind
time_min=plot_min
time_max=plot_max
time_metro_min_ind=MIN(WHERE(metro[*].(0) gt time_min))
time_metro_max_ind=MAX(WHERE(metro[*].(0) lt time_max))
; decide if to truncate data due to metrology
truncate_metro=""
while truncate_metro ne "n" do begin
plot, metro[time_metro_min_ind:time_metro_max_ind].(0),metro[time_metro_min_ind:time_metro_max_ind].(1),PSYM=3, /XSTYLE, /YSTYLE, XTITLE='time', YTITLE='delta L'
metrofit=LINFIT(metro[time_metro_min_ind:time_metro_max_ind].(0),metro[time_metro_min_ind:time_metro_max_ind].(1),/DOUBLE)
oplot,metro[time_metro_min_ind:time_metro_max_ind].(0),metro[time_metro_min_ind:time_metro_max_ind].(0)*metrofit[1]+metrofit[0],PSYM=3,COLOR=80
legend,['metrology','LINFIT'],linestyle=0,colors=[0,80],textcolor=80
print, "XRANGE = [",metro[time_metro_min_ind].(0),";",metro[time_metro_max_ind].(0),"]"
truncate_metro=""
READ, truncate_metro, PROMPT='Truncate XRANGE due to METROLOGY? [y/n] '
if truncate_metro eq "y" then begin
; set new range due to metrology
READ, tmin_new, PROMPT='Provide new XMIN : '
READ, tmax_new, PROMPT='Provide new XMAX : '
time_min_ind=MIN(WHERE(imagdata[*].(0) gt tmin_new AND imagdata[*].(0) gt time_min))
time_max_ind=MAX(WHERE(imagdata[*].(0) lt tmax_new AND imagdata[*].(0) lt time_max))
time_min=imagdata[time_min_ind].(0)
time_max=imagdata[time_max_ind].(0)
time_metro_min_ind=MIN(WHERE(metro[*].(0) gt tmin_new))
time_metro_max_ind=MAX(WHERE(metro[*].(0) lt tmax_new))
metrofit=LINFIT(metro[time_metro_min_ind:time_metro_max_ind].(0),metro[time_metro_min_ind:time_metro_max_ind].(1),/DOUBLE)
endif
endwhile
print, "Slope of metro is ",metrofit[1]," m/microsec"
; now do the FFT for the different channels

; maybe range should be adjusted (to check)
if fsuname eq "FSU_A" then printf, result_A, framename, " ", fsuname, " ",FORMAT='(a,a,a,a,$)'
if fsuname eq "FSU_B" then printf, result_B, framename, " ", fsuname, " ",FORMAT='(a,a,a,a,$)'
; in this while loop wide channel, channel1 and channel 5 of A will be plotted to find the right range for the offset computation
replot="firstrun"
while replot ne "n" do begin
for channels=0, 5 do begin
if channels eq 0 OR channels eq 1 OR channels eq 5 then begin
response_A=FFT(imagdata[time_min_ind:time_max_ind].(5)(channels),DIMENSION=1,DOUBLE=1)
str=SIZE(response_A)
points_A=LONG(str[1])
;apodrange=MAX(WHERE(wavenumbers lt 20000.0d))
;response_A[0:apodrange]=DCOMPLEX(0.0d,0.0d)
;response_A[(points_A/2):points_A-1]=DCOMPLEX(0.0d,0.0d)
;normfactorA=1.0d/(MAX(abs(response_A)))
;response_A=response_A*normfactorA
endif
if channels eq 0 then begin
;set up the x-axis (wavenumbers)
if replot eq "firstrun" then wavenumbers=DINDGEN(points_A)/abs((imagdata[time_max_ind].(0)-imagdata[time_min_ind].(0))*metrofit[1])
if replot eq "firstrun" then offset_min_ind=1
if replot eq "firstrun" then offset_max_ind=points_A/2 - 1
apodrange=Long(points_A/100)
response_A[0:apodrange]=DCOMPLEX(0.0d,0.0d)
response_A[(points_A/2):points_A-1]=DCOMPLEX(0.0d,0.0d)
normfactorA=1.0d/(MAX(abs(response_A[offset_min_ind:offset_max_ind])))
response_A=response_A*normfactorA
plot, wavenumbers[offset_min_ind:offset_max_ind] ,abs(response_A[offset_min_ind:offset_max_ind]), /XSTYLE, /YSTYLE
print, "XRANGE = [",wavenumbers[offset_min_ind],";",wavenumbers[offset_max_ind],"]"
print, "resolution in wavenumber: ",1.0d/abs((imagdata[time_max_ind].(0)-imagdata[time_min_ind].(0))*metrofit[1])
READ, dummy, PROMPT='Press ENTER to overplot with channel 1 '
endif
if channels eq 1 then begin 
response_A[0:apodrange]=DCOMPLEX(0.0d,0.0d)
response_A[(points_A/2):points_A-1]=DCOMPLEX(0.0d,0.0d)
normfactorA=1.0d/(MAX(abs(response_A[offset_min_ind:offset_max_ind])))
response_A=response_A*normfactorA
oplot, wavenumbers[offset_min_ind:offset_max_ind] ,abs(response_A[offset_min_ind:offset_max_ind]), color = 80
print, "XRANGE = [",wavenumbers[offset_min_ind],";",wavenumbers[offset_max_ind],"]"
print, "resolution in wavenumber: ",1.0d/abs((imagdata[time_max_ind].(0)-imagdata[time_min_ind].(0))*metrofit[1])
READ, dummy, PROMPT='Press ENTER to overplot with channel 5 '
endif
if channels eq 5 then begin 
response_A[0:apodrange]=DCOMPLEX(0.0d,0.0d)
response_A[(points_A/2):points_A-1]=DCOMPLEX(0.0d,0.0d)
normfactorA=1.0d/(MAX(abs(response_A[offset_min_ind:offset_max_ind])))
response_A=response_A*normfactorA
oplot, wavenumbers[offset_min_ind:offset_max_ind] ,abs(response_A[offset_min_ind:offset_max_ind]), color = 176
print, "XRANGE = [",wavenumbers[offset_min_ind],";",wavenumbers[offset_max_ind],"]"
print, "resolution in wavenumber: ",1.0d/abs((imagdata[time_max_ind].(0)-imagdata[time_min_ind].(0))*metrofit[1])
READ, replot, PROMPT='Replot the data with different XRANGE? [y/n] '
if replot ne "n" then begin
; set new range
waveminnew=0.0d
wavemaxnew=0.0d
READ, waveminnew, PROMPT='Provide new XMIN : '
READ, wavemaxnew, PROMPT='Provide new XMAX : '
offset_min_ind=MAX(WHERE(wavenumbers le waveminnew ))
offset_max_ind=MAX(WHERE(wavenumbers lt wavemaxnew ))
print, "offset_ind_min ; offset_ind_max",offset_min_ind, " ",offset_max_ind
; all set up for new plot
endif
endif
endfor
endwhile

compoffsets=""
READ, compoffsets, PROMPT='Still want to compute offsets? [y/n] : '
if compoffsets ne "n" then begin
for channels=0, 5 do begin
;compute response for A, B, C, D
print, "Processing channel ",channels, " QUAD A"
response_A=FFT(imagdata[time_min_ind:time_max_ind].(5)(channels),DIMENSION=1,DOUBLE=1)
str=SIZE(response_A)
points_A=str[1]
apodrange=Long(points_A/100)
response_A[0:apodrange]=DCOMPLEX(0.0d,0.0d)
response_A[(points_A/2):points_A-1]=DCOMPLEX(0.0d,0.0d)
;apodrange=Long(points_A/100)
;response_A[0:apodrange]=DCOMPLEX(0.0d,0.0d)
;response_A[(points_A/2):points_A-1]=DCOMPLEX(0.0d,0.0d)
normfactorA=1.0d/(MAX(abs(response_A[offset_min_ind:offset_max_ind])))
response_A=response_A*normfactorA
print, "Processing channel ",channels, " QUAD B"
response_B=FFT(imagdata[time_min_ind:time_max_ind].(6)(channels),DIMENSION=1,DOUBLE=1)
response_B[0:apodrange]=DCOMPLEX(0.0d,0.0d)
response_B[(points_A/2):points_A-1]=DCOMPLEX(0.0d,0.0d)
normfactorB=1.0d/(MAX(abs(response_B[offset_min_ind:offset_max_ind])))
response_B=response_B*normfactorB
;str=SIZE(response_B)
;points_B=str[1]
print, "Processing channel ",channels, " QUAD C"
response_C=FFT(imagdata[time_min_ind:time_max_ind].(7)(channels),DIMENSION=1,DOUBLE=1)
response_C[0:apodrange]=DCOMPLEX(0.0d,0.0d)
response_C[(points_A/2):points_A-1]=DCOMPLEX(0.0d,0.0d)
normfactorC=1.0d/(MAX(abs(response_C[offset_min_ind:offset_max_ind])))
response_C=response_C*normfactorC
;str=SIZE(response_C)
;points_C=str[1]
print, "Processing channel ",channels, " QUAD D"
response_D=FFT(imagdata[time_min_ind:time_max_ind].(8)(channels),DIMENSION=1,DOUBLE=1)
response_D[0:apodrange]=DCOMPLEX(0.0d,0.0d)
response_D[(points_A/2):points_A-1]=DCOMPLEX(0.0d,0.0d)
normfactorD=1.0d/(MAX(abs(response_D[offset_min_ind:offset_max_ind])))
response_D=response_D*normfactorD

print, "Computing offsets for channel ",channels
;compute the offsets
phaseAB=phasediff_rainer(REAL_PART(response_A[offset_min_ind:offset_max_ind]),IMAGINARY(response_A[offset_min_ind:offset_max_ind]),REAL_PART(response_B[offset_min_ind:offset_max_ind]),IMAGINARY(response_B[offset_min_ind:offset_max_ind]) )/!DPI
phaseAC=phasediff_rainer(REAL_PART(response_A[offset_min_ind:offset_max_ind]),IMAGINARY(response_A[offset_min_ind:offset_max_ind]),REAL_PART(response_C[offset_min_ind:offset_max_ind]),IMAGINARY(response_C[offset_min_ind:offset_max_ind]) )/!DPI
phaseAD=phasediff_rainer(REAL_PART(response_A[offset_min_ind:offset_max_ind]),IMAGINARY(response_A[offset_min_ind:offset_max_ind]),REAL_PART(response_D[offset_min_ind:offset_max_ind]),IMAGINARY(response_D[offset_min_ind:offset_max_ind]) )/!DPI
phaseBC=phasediff_rainer(REAL_PART(response_B[offset_min_ind:offset_max_ind]),IMAGINARY(response_B[offset_min_ind:offset_max_ind]),REAL_PART(response_C[offset_min_ind:offset_max_ind]),IMAGINARY(response_C[offset_min_ind:offset_max_ind]) )/!DPI
phaseBD=phasediff_rainer(REAL_PART(response_B[offset_min_ind:offset_max_ind]),IMAGINARY(response_B[offset_min_ind:offset_max_ind]),REAL_PART(response_D[offset_min_ind:offset_max_ind]),IMAGINARY(response_D[offset_min_ind:offset_max_ind]) )/!DPI
phaseCD=phasediff_rainer(REAL_PART(response_C[offset_min_ind:offset_max_ind]),IMAGINARY(response_C[offset_min_ind:offset_max_ind]),REAL_PART(response_D[offset_min_ind:offset_max_ind]),IMAGINARY(response_D[offset_min_ind:offset_max_ind]) )/!DPI
if fsuname eq "FSU_A" then printf, result_A, phaseAB," ",phaseBC," ",phaseCD," ",phaseAC," ",phaseAD," ",phaseBD," ",metrofit[1]," ",metrofit[0]," ",FORMAT='(d,a,d,a,d,a,d,a,d,a,d,a,d,a,d,a,$)'
if fsuname eq "FSU_B" then printf, result_B, phaseAB," ",phaseBC," ",phaseCD," ",phaseAC," ",phaseAD," ",phaseBD," ",metrofit[1]," ",metrofit[0]," ",FORMAT='(d,a,d,a,d,a,d,a,d,a,d,a,d,a,d,a,$)'
endfor
;endwhile
; FORMAT (file fsu offsets tmin tmax fftINDmin fftINDmax metro_slope metro_b comments)
note=""
READ, note, PROMPT='Any comment? : '
if fsuname eq "FSU_A" then printf, result_A, time_min, " ", time_max, " ",offset_min_ind," ",offset_max_ind," ", note
if fsuname eq "FSU_B" then printf, result_B, time_min, " ", time_max, " ",offset_min_ind," ",offset_max_ind," ", note
endif
free_lun, result_A
free_lun, result_B
endif
;leaving this for loop means leaving the file
endfor
endif
READ, break,PROMPT='Next File? [y/n] '
endwhile

LEAVE:
free_lun, frames
print, "Last file was file: ",framename
END 
