;
; baseline.pro
; Created:     Fri Dec  7 14:44:53 2007 by Koehler@Six
; Last change: Tue Feb  1 13:47:04 2011
;
; Copyright 2008 Rainer Koehler
;
; This file is part of Pacmart.
;
; Pacmart is free software; you can redistribute it and/or modify
; it under the terms of the GNU General Public License as published by
; the Free Software Foundation; either version 2 of the License, or
; (at your option) any later version.
;
; Pacmart is distributed in the hope that it will be useful,
; but WITHOUT ANY WARRANTY; without even the implied warranty of
; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
; GNU General Public License for more details.
;
; You should have received a copy of the GNU General Public License
; along with Pacmart; if not, write to the Free Software
; Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
;
pro fill_obscat
  obscat= fitstable_create('OBSERVER_CATALOG', '../PACMA_COCO_OBCAT.fits', iErr)
  if iErr then begin
      print,"Please make sure ../PACMA_COCO_OBCAT.fits is here."
      return
  endif
  obscat->close
  obscat_row = obscat->template()
  ;help,obscat_row,/str
  for i=0,N_tags(obscat_row)-1 do obscat_row.(i)=0
  ;print,obscat_row

  prihead= obscat->prihead()
  prihead->addESOPar,'PRO CATG', 'COCO_OBCAT', Comment=' professional category oberver catalog'
  prihead->addESOPar,'WARN1','THIS FILE WAS MADE FROM 100% RECYCLABLE ELECTRONS'
  prihead->addESOPar,'WARN2','Contents may have settled during shipping.'
  prihead->addESOPar,'WARN3','Warning: Do not leave human operator unattended at any time!'

  obscat->newfile, 'OBERVER_CATALOG.fits', iErr=iErr, prihead=prihead
  if iErr then $
	print,"creation of new file OBERVERS_CATALOG.FITS had issues, iErr =",iErr

  starnames= ["Pacman", "Pacwoman", "Pacgirl", "Pacboy", "Pacbaby", "Pacdog", "Pacmouse"]

  for iStar=0,N_elements(starnames)-1 do begin
      obscat_row.id    = string(Format='(A25)',starnames[iStar])
      obscat_row.CAL   = 1	;; for now
      obscat_row.REF_EPOCH=2000.0
      obscat_row.RA_SI_EPOCH=2000.0
      obscat_row.RA_SI = randomu(seed,/uniform)*24.
      obscat_row.DEC_SI_EPOCH=2000.0
      obscat_row.Dec_Si= (randomu(seed,/uniform)*180.)-90.
      obscat->writeRows, obscat_row
  endfor
  obscat->close
  obj_destroy, obscat
end

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;; make baseline crapilator catalogs
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

PRO baseline_calibrator_cat, MJD0, epoch, baseNm, baseRA, baseDec

  ;;blcat= fitstable_create('BASELINE_CATALOG', '/home/istilz/test/coco_cat/BASELINE_CALIBRATOR_CATALOG.fits',iErr=iErr)
  blcat= fitstable_create('BASELINE_CATALOG', '/home/istilz/test/coco_cat/PACMA_COCO_BLCAT.fits',iErr=iErr)
  if iErr then begin
      print,"Please make sure ../PACMA_COCO_BLCAT.fits is here."
      return
  endif
  blcat->close
  blcat_row = blcat->template()
  help,blcat_row,/str
  for i=0,N_tags(blcat_row)-1 do blcat_row.(i)=0

  prihead= blcat->prihead()
  prihead->addESOPar,'PRO CATG','COCO_BLCAT', Comment=" Coco Baseline Calibrator Cat"
  prihead->addESOPar,'FUN1','Kepler:  "Did you know that Tycho, my boss,"'
  prihead->addESOPar,'FUN2','          had an artificial nose?"'
  prihead->addESOPar,'FUN3','Galileo: "An artificial nose! How did he smell?"'
  prihead->addESOPar,'FUN4','Kepler:  "Terrible!"'

  blcat->newfile, 'BASELINE_CALIBRATOR_CATALOG.fits', iErr=iErr, prihead=prihead
  if iErr then $
	print,"creation of new file BASELINE_CALIBRATOR_CATALOG.FITS had issues, iErr =",iErr

  ;;observer_catalog_row__Define, blcat_row

  time= -1.5d	;; hours
  for iStar=0,9 do begin
      RA = baseRA[iStar]
      Dec= baseDec[iStar]
      name = string(Format='("RK",A,I02,I02)', Dec ge 0.? '+':'-', fix(abs(Dec)), fix(RA))
      baseNm[iStar]= name
      print,iStar,": Name ",name,", RA =",RA,", Dec =",Dec

      blcat_row.id    = string(Format='(A-25)',name)	;;strtrim(byte('A')+byte(iStar),2)
      blcat_row.CAL   = 1	;; for now
      blcat_row.REF_EPOCH= epoch	;2000.0
      blcat_row.RA_SI_EPOCH= epoch	;2000.0
      blcat_row.RA_SI = RA
      blcat_row.DEC_SI_EPOCH= epoch	;2000.0
      blcat_row.Dec_Si= Dec
      blcat_row.pI    = 1d-6
      ;;print,"blcat_row:",blcat_row
      print,"prallaalx:",blcat_row.PI
      blcat->writeRows, blcat_row

      ;;VLTIresponse,STARTTIME=MJD_to_ESO_string(MJD0-0.2498/24.),/Starspectrum,Startemp=3333.
      starspectrum_one, 'SPECTRUM_'+name+'.fits',$
                        {Starpos, Name:name, RA:RA, Dec:Dec, pmRA:0d, pmDec:0d, Epoch:2000d, Parallax:0d, v_rad:0d},$
                        MJD= MJD0+time/24.
      time += 9.d/60.
  endfor
  blcat->close
  obj_destroy, blcat
end

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

PRO baseline_testfiles, MJD=MJD0

  hbaseRA = [   3.,   3.,   1.,   1.,   1. ]
  hbaseDec= [ -50., -10., -30., -70., +10. ]

  if not keyword_set(MJD0) then MJD0= MJulday(2000,1,1, 0,0,0)

  epoch= (MJD0-MJulday(2000,1,1, 0,0,0))/365.25 + 2000.
  print,"epoch",epoch

  environment, MJD=MJD0-0.5		;; env should start at noon on previous day

  VLTIresponse,STARTTIME=MJD_to_ESO_string(MJD0-2./24.)

  ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

  lst0= lst_from_date(MJD0+5.d/24.d)	;; LST at middle of obs.

  baseNm = strarr(2*N_elements(hbaseRA))
  baseRA = dblarr(2*N_elements(hbaseRA))
  baseDec= dblarr(2*N_elements(hbaseRA))

  baseRA[0:4] = lst0-hbaseRA
  baseRA[5:9] = reverse(lst0+hbaseRA)
  baseDec[0:4]= hbaseDec-5.
  baseDec[5:9]= reverse(hbaseDec)

  baseline_calibrator_cat, MJD0, epoch, baseNm, baseRA, baseDec

;print,"Abort observation because of time constraints"
;return

  ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
  ;;;;; start observing
  ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

print,"Device is ",!D.name
  if !D.name eq 'PS' then device,/landscape,filename='sky_distrib.ps'

  plot, [-4,4],[-90,+30], /nodata, xtitle='Hour Angle [hours]', ytitle='Declination [deg]'

  time= 0.d	;; in hours
  star= -1
  obscnt= 0
  while time lt 10. do begin
      print,"======================================================================"
      ;; find a star to observe
      MJD = MJD0 + time/24.
      lst = lst_from_date(MJD)

      repeat begin
          star++
          if star gt 9 then star=0
          ha = lst - baseRA[star]
          if ha le -12. then ha += 24.
          if ha gt  12. then ha -= 24.
      endrep until (abs(ha) lt 3.)
      print,"Baseline obs",obscnt,", time",time,", star",star,", ha =",ha

      ;oplot, [ha], [baseDec[star]], psym=fix(star mod 5)
      xyouts, ha, baseDec[star], strtrim(star,2)

      ra = baseRA[star]
      dec= baseDec[star]
      ;;co_aberration, MJD+2400000.5d, ra*15., dec, d_ra, d_dec
      ;;ra += d_ra /3600./15.
      ;;dec+= d_dec/3600.
      ;;print,"aberation:",d_ra[0],d_dec[0],' arcsec'

      skarflat, MJD=MJD, DITa=0.1, DitB=0.1	;; 10Hz is default rate in astrometry
      ;; skyback adds 2.5min, skarflat adds 1min => astromet starts at 3:30

      print,"Start Baseline fringe track, MJD",MJD

      a= obj_new('astrometry',File_prefix='PACMA')
      a->set_startMJD, MJD
      a->set_pos,$
         A={ Starpos, Name: baseNm[star]+'c',RA:ra, Dec:dec, pmRA:0d, pmDec:0d, Epoch:2000d, Parallax:1d-6, v_rad: 0d},$
         B={ Starpos, Name: baseNm[star],    RA:ra, Dec:dec, pmRA:0d, pmDec:0d, Epoch:2000d, Parallax:1d-6, v_rad: 0d}
      a->set_exptime, 300.
      a->set_DITs, FSUA=0.	;; hack around scicrap2
      a->set_n_phonoise, 0
      ;;a->set_FSU_param, "wave", 1. / [2.5, 2.4, 2.3, 2.2, 2.1]
      a->writefile, MJD
      obj_destroy,a

      print,"Finished Baseline fringe track, MJD",MJD

      obscnt++
      ;;time += 12.d/60.
      time = (MJD-MJD0)*24.
  endwhile

  if !D.name eq 'PS' then device,/close
end

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

pro fix_wbase, wbname, BASELINE= baseline

  if not keyword_set(baseline) then baseline= [100.,0.,0.,0.]
  wbout= 'WBASE_fixed.fits'

  stinfo= fitstable_openr(wbname,'STARINFO')
  stdata= stinfo->readrows()

  prihead= stinfo->prihead()
  ;;prihead->addpar,'COMMENT','fixed baseline'

  stinfo->newFile, wbout, prihead=prihead
  stinfo->writerows,stdata

  base = fitstable_openr(wbname,'WIDE_BASELINE')
  bdata= base->readrows()

  bdata.bx= baseline[0] & bdata.bx_err= 0.
  bdata.by= baseline[1] & bdata.by_err= 0.
  bdata.bz= baseline[2] & bdata.bz_err= 0.
  bdata.cterm= baseline[3] & bdata.cterm_err= 0.
  bdata.numdelay= 32767
  bdata.residual= 0.

  base->appendtofile, stinfo
  base->writerows, bdata
  base->close

  obj_destroy, stinfo
;  obj_destroy, base
end

pro append_wbase, wbname, STATIONS=stations, BASELINE=baseline, OUT=wbout

  if not keyword_set(stations) then stations= ['A2','Q7']
  if not keyword_set(baseline) then baseline= [100.,0.,0.,0.]	;; x,y,z,const
  if not keyword_set(wbout) then wbout= 'WBASE_fixed.fits'

  stinfo= fitstable_openr(wbname,'STARINFO')
  stdata= stinfo->readrows()

  prihead= stinfo->prihead()
  ;;prihead->addpar,'COMMENT','fixed baseline'

  stinfo->newFile, wbout, prihead=prihead
  stinfo->writerows,stdata

  base = fitstable_openr(wbname,'WIDE_BASELINE')
  bdata= base->readrows()

  base->appendtofile, stinfo
  base->writerows, bdata

  bdata= bdata[0]

  bdata.station1= stations[0]
  bdata.station2= stations[1]
  bdata.bx= baseline[0] & bdata.bx_err= 0.
  bdata.by= baseline[1] & bdata.by_err= 0.
  bdata.bz= baseline[2] & bdata.bz_err= 0.
  bdata.cterm= baseline[3] & bdata.cterm_err= 0.
  bdata.numdelay= 32767
  bdata.residual= 0.
  base->writerows, bdata

  base->close

  obj_destroy, stinfo
end

pro all_baselines, wbin, wbout

  if N_params() lt 1 then wbin = "PACMA_COCO_WBASE.fits"
  if N_params() lt 2 then wbout= 'WBASE_all.fits'

  stinfo= fitstable_openr(wbin,'STARINFO')
  stdata= stinfo->readrows()

  prihead= stinfo->prihead()
  ;;prihead->addpar,'COMMENT','fixed baseline'

  stinfo->newFile, wbout, prihead=prihead
  stinfo->writerows,stdata

  base = fitstable_openr(wbin,'WIDE_BASELINE')
  bdata= base->readrows()

  base->appendtofile, stinfo
  ;;base->writerows, bdata	-- forget the old crap
  bdata = bdata[0]

  openr,BLD,getenv("HOME")+"/PRIMA/Pacmart/baselinedata.txt",/get_lun

  line = ""
  readf,BLD,line	;; read geader line

  while( not eof(BLD)) do begin
     readf,BLD,line
     fields  = strsplit(line," ",/Extract)
     stations= strsplit(fields[0],"-",/Extract)
     len = double(fields[1])
     PA  = double(fields[2])
     print,stations[0],"--",stations[1]," / ",len," / ",PA

     PA *= !dpi/180.d	;; PA is measured from N to E

     bdata.station1 = stations[0]
     bdata.station2 = stations[1]

     bdata.bx= len * cos(PA)	& bdata.bx_err= 0.001	;; 1mm error
     bdata.by= len * sin(PA)	& bdata.by_err= 0.001
     bdata.bz= 0.		& bdata.bz_err= 0.001
     bdata.cterm= 0.		& bdata.cterm_err= 0.001
     bdata.numdelay= 0.
     bdata.residual= 0.

     base->writerows, bdata
  endwhile

  free_lun,BLD

  base->close
  obj_destroy, stinfo
end
