;
; check_mdl_header.pro
; Created:     Wed Jul 28 15:23:34 2010 by Rkoehler@lx40
; Last change: Wed Jul 28 15:49:00 2010
;
; PURPOSE:
;	read header keywords for delay line position
;	compute difference START - END
;
; WARNING:
;	This program may contain strong violence, adult content, and
;	language.  Parental guidance is advised.
;
PRO check_mdl_header, files

  Nfiles= N_elements(files)

  dl1arr = dblarr(Nfiles)
  dl2arr = dblarr(Nfiles)

  for iFile=0,Nfiles-1 do begin

     fits = obj_new('FitsFile',files[iFile],iErr=iErr)
     if iErr ne 0 then continue

     prihead= fits->priHead()

     DL1S = prihead->getpar('HIERARCH ESO DEL DLT1 OPL START')
     DL1E = prihead->getpar('HIERARCH ESO DEL DLT1 OPL END')
     DL2S = prihead->getpar('HIERARCH ESO DEL DLT2 OPL START')
     DL2E = prihead->getpar('HIERARCH ESO DEL DLT2 OPL END')

     print,files[iFile],", DL1:",(DL1S-DL1E)*1d9,", DL2:",(DL2S-DL2E)*1d9," nm"

     dl1arr[iFile] = (DL1S-DL1E)*1d9
     dl2arr[iFile] = (DL2S-DL2E)*1d9

     obj_destroy,fits
  endfor

  good1 = where(abs(dl1arr) lt 1e9,cnt)
  dl1g = dl1arr[good1]

  plot, dl1g, psym=3

  print,"RMS:",sqrt(mean(dl1g*dl1g))

  ;;plot, dindgen(20)*10-100, histogram(dl1g,min=-100,max=100,NBIN=20), psym=10


end
