;
; check_metro.pro
; Created:     Mon Jul 26 16:08:30 2010 by Rkoehler@lx40
; Last change: Mon Jul 26 17:24:10 2010
;
; PURPOSE:
;	find out what the most common PRIMET-status is
;
; WARNING:
;	This program may contain strong violence, adult content, and
;	language.  Parental guidance is advised.
;
PRO check_metro, fname, VERBOSE=verbose

  for iFile=0,N_elements(fname)-1 do begin

     print,Format='(A,": ",$)',fname[iFile]

     metro = fitstable_openr(fname[iFile],"METROLOGY_DATA",iErr=iErr)

     if iErr ne 0 then continue

     data = metro->readrows()

     if size(data,/TName) eq 'STRUCT' then begin

        sstat = data[sort(data.status)].status
        uidx  = uniq(sstat)
        if N_elements(uidx) gt 1 then begin
           ;; uniq() gives the *last* index for a value

           N_val = [ uidx, N_elements(sstat)-1] - [ -1, uidx ]

           if keyword_set(verbose) then begin
              print, N_elements(sstat)," rows"
              print,"vals:",sstat[uidx]
              print,"uniq:",uidx
              print,"Nval:",N_val
           endif
           most = max(N_val,midx)
           mval = sstat[ uidx[midx]]
        endif else $
           mval = sstat[0]	;; only one value - all statusses are the same

        good = where(data.status eq mval, goodcnt)
        allcnt = N_elements(data)

        ;print, goodcnt*100/allcnt, " % of rows have status 319 (",goodcnt,"/",allcnt,")"
        print,"most common status:",mval,",", goodcnt*100/allcnt, " % of rows (",goodcnt,"/",allcnt,")"

     endif else $
        print," no data"

     obj_destroy,metro
  endfor
end
