;
; comm_report.pro
; Created:     Thu Jul 23 20:46:12 2009 by Koehler@Six
; Last change: Mon Jul 27 17:22:41 2009
;
; PURPOSE:
;	none
;
; WARNING:
;	This program may contain strong violence, adult content, and
;	language.  Parental guidance is advised.
;
PRO comm_report, files, OUTFILE=outfname

  outunit= -1	;; stdout
  if keyword_set(outfname) then openw,outunit,outfname,/get_lun

  for iFile=0,N_elements(files)-1 do begin
      print,"Reading ",files[iFile]
      printf,outunit,"File: ",files[iFile]
      fbt = fbt_open(files[iFile])

      printf,outunit,"Tables:"
      tblnames= tag_names(fbt)
      ;; index 0 and 1 are filename and fileobj
      for i=2,N_Tags(fbt)-1 do printf,outunit,'        '+tblnames[i]

      ;;for iTbl=2,N_tags(fbt)-1 do begin
      ;;    printf,outunit,"------------------------------------------------------------------------"
      ;;    printf,outunit,"Columns in table ",tblnames[iTbl]
      ;;    tab = fbt.(iTbl)->readrows(1)
      ;;    tnames= tag_names(tab)
      ;;    for i=0,N_Tags(tab)-1 do begin
      ;;        N = N_elements(tab[0].(i))
      ;;        Nstr= N gt 1 ? (strtrim(N,2)+' ') : ''
      ;;        printf,outunit,Format='("      ",A-16,A,A,A)',$
      ;;          tnames[i], Nstr, strlowcase(size(tab[0].(i),/tname))
      ;;    endfor
      ;;endfor

      if !D.name eq 'PS' then begin
          fname= files[iFile]
          fname= file_dirname(outfname)+'/'+strmid(fname,0,strlen(fname)-5)+'_plots.ps'
          print,"Plotting to ",fname
          device,file=fname,/landsc
      endif
      fsub= fbt.imaging_data_fsub->readrows()
      plot,fsub.time,fsub.data1[0],xtitle='TIME',ytitle='FSUB / DATA1[0]',title=files[iFile]
      fsub= 0

      metro= fbt.metrology_data->readrows()
      plot,metro.time,metro.deltaL,xtitle='TIME',ytitle='METROLOGY / DELTAL',title=files[iFile]
      metro= 0

      metroB= fbt.metrology_data_fsuB->readrows()
      plot,metroB.time,metroB.deltaL,xtitle='TIME',ytitle='METROLOGY_FSUB / DELTAL',title=files[iFile]
      metroB= 0

      opdc= fbt.opdc->readrows()
      opdcstate= opdc.state
      plot,opdc.time,opdcstate,xtitle='TIME',ytitle='OPDC / STATE',title=files[iFile]
      opdc= 0

      Nrows= N_elements(opdcstate)/100.	;; make percent
      sev= where(opdcstate eq 7, cnt7)
      fiv= where(opdcstate eq 5, cnt5)
      one= where(opdcstate eq 1, cnt1)
      print,"opdc.state",cnt7/Nrows,"% 7,",cnt5/Nrows,"% 5,",cnt1/Nrows,"% 1"

      if !D.name eq 'PS' then device,/close

      printf,outunit,""
      printf,outunit,"========================================================================"

      fbt_close,fbt
  endfor
  if keyword_set(outfname) then free_lun,outunit
end
