;
; defaults.pro
; Created:     Mon Apr  7 12:04:46 2008 by Rkoehler@lx40
; Last change: Tue Aug 31 16:55:15 2010
;
; Copyright 2008 Rainer Koehler
;
; This file is part of Pacmart.
;
; Pacmart is free software; you can redistribute it and/or modify
; it under the terms of the GNU General Public License as published by
; the Free Software Foundation; either version 2 of the License, or
; (at your option) any later version.
;
; Pacmart is distributed in the hope that it will be useful,
; but WITHOUT ANY WARRANTY; without even the implied warranty of
; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
; GNU General Public License for more details.
;
; You should have received a copy of the GNU General Public License
; along with Pacmart; if not, write to the Free Software
; Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
;

pro init_defaults
  Common PACSIM_DEFAULTS, ld_bias, ld_dark, ld_noise,$
			  lf_flux, lf_noise,  sb_flux,$
			  kappa_center, kappa_width

  ;; labdark
  ld_bias = [  0. ,  0. ,  0. ,  0. ,  0. ,  0.  ]
  ld_dark = [ 11.6, 15.0, 14.6, 13.5, 12.7, 11.9 ]
  ld_noise= [  2.2,  2.3,  2.2,  2.2,  2.4,  2.2 ]

  ;; labflat (real raw data)
  ;;lf_flux = [[ 1450., 210., 320., 340., 390., 390.],$
  ;;           [  675., 355., 630., 675., 720., 680.],$
  ;;           [  555., 230., 570., 630., 710., 375.],$
  ;;           [ 1070., 325., 680., 740., 740., 280.] ]

  ;; labflat, (real data, normalized in each channel)
  lf_flux = [[ 1.000, 0.592, 0.471, 0.459, 0.527, 0.574 ],$
             [ 0.466, 1.000, 0.926, 0.912, 0.973, 1.000 ],$
             [ 0.383, 0.648, 0.838, 0.851, 0.959, 0.551 ],$
             [ 0.738, 0.915, 1.000, 1.000, 1.000, 0.412 ] ]

  lf_noise= [[ 17.,  6.,  7.,  7.,  8.,  8.],$
             [ 10.,  8., 10., 10., 10., 10.],$
             [ 10.,  6., 10., 10., 11.,  7.],$
             [ 17.,  7., 12., 14., 13.,  7.] ]

  ;; skybackground
  sb_flux = [ 500., 150., 280., 300., 320., 220. ]
  ;; default skyback noise is sqrt(flux)

  ;; FSUreponse
  ;kappa_center= [ 0.455, 0.504, 0.482, 0.460, 0.433, 0.412 ] * 1d6	;; [1/m], based on testbed-data
  ;kappa_width = [ 0.085, 0.022, 0.025, 0.020, 0.016, 0.013 ] * 1d6

  ;; [1/m], based on COMM11
  ;; DOUBLE Array[6, 4]
  ;; 1.idx = wavelen channel, 2.idx = ABCD, 3.idx = FSU
  kappa_center= [[[ 451961.d, 495971.d, 469677.d, 443110.d, 420139.d, 405605.d],$	;; FSUA
                  [ 454622.d, 499951.d, 473032.d, 445377.d, 421568.d, 405651.d],$
                  [ 454197.d, 504256.d, 480955.d, 454100.d, 430187.d, 413272.d],$
                  [ 456449.d, 505664.d, 482573.d, 455813.d, 431662.d, 417176.d] ],$
                 [[ 455991.d, 500568.d, 473632.d, 448266.d, 425167.d, 409085.d],$	;; FSUB
                  [ 454271.d, 495342.d, 469983.d, 444779.d, 422431.d, 406856.d],$
                  [ 459881.d, 505016.d, 478547.d, 450505.d, 426743.d, 411903.d],$
                  [ 456247.d, 502143.d, 479549.d, 450984.d, 426468.d, 410894.d] ]]

  kappa_width = [ 0.085, 0.022, 0.025, 0.020, 0.016, 0.013 ] * 1d6

end

;; old:

Function default_detector_bias
  print,"WARNING: USING OLD default_detector_bias()!\a!\a!\a"
  return, [ 3., 4., 5., 6., 7.]
end

Function default_sky_background
  return, ([40.,44.,48.,52.,56.] + 420.)
end
