;
; fbtv.pro
; Created:     Wed Aug  8 17:08:09 2007 by Rkoehler@lx40
; Last change: Fri Mar 18 17:36:54 2011
;
; Copyright 2008 Rainer Koehler
;
; This file is part of Pacmart.
;
; Pacmart is free software; you can redistribute it and/or modify
; it under the terms of the GNU General Public License as published by
; the Free Software Foundation; either version 2 of the License, or
; (at your option) any later version.
;
; Pacmart is distributed in the hope that it will be useful,
; but WITHOUT ANY WARRANTY; without even the implied warranty of
; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
; GNU General Public License for more details.
;
; You should have received a copy of the GNU General Public License
; along with Pacmart; if not, write to the Free Software
; Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
;
;;;;;
;
; extra_keys is array of strings containing extra header keywords
; displayed by pacmafs
;
PRO fbtv, filename, DIR=dir, XOFFSET=xoffset, HELP=help, EXTRA_KEYS=extra_keys

  if keyword_set(help) then begin
     print,"USAGE: fbtv, [filename,] [DIR=directory,] [XOFFSET=xoffset,] [/HELP]"
     return
  endif

  if N_elements(filename) lt 1 then begin
     ;;filename = Dialog_Pickfile(Title="Select file",/Read,$
     ;;                           Default_EXtension="fits", Filter="*.fits")
     if keyword_set(dir) then begin
        if dir eq '?' then dir= Dialog_Pickfile(Title="Select Directory",/Directory)
     endif else cd,current=dir	;;get cwd

     print,"searching in ",dir

     filename= pacmafs(dir, EXTRA_KEYS=extra_keys)
     if filename[0] eq "" then return
     if N_elements(filename) gt 1 then begin
        for i=0,(N_elements(filename)-1) < 5 do fbtv,filename[i],Xoffset=i*200
        return
     endif
     filename= filename[0]
  endif
  if not keyword_set(xoffset) then xoffset=0

  fbt= fbt_open(filename)
  ;;help,fbt,/str

  base = widget_base(Title='fbtv '+filename,/Column,XOffSet=xoffset)
  tags = tag_names(fbt)
  Ntags= N_elements(tags)
  desc = strarr( (Ntags-2)*4+2+3)
  desc[0]= '0, LABEL, ' + FILE_Basename(filename)
  desc[1]= '0, BUTTON, Primary Header, FRAME, TAG=PRIHEAD'
  d=2
  for i=0,Ntags-1 do begin
      if tags[i] eq "FILENAME" or tags[i] eq 'FILEOBJ' then continue
      rows = (fbt.(i)->head())->getpar('NAXIS2')
      label= tags[i] + ' (' + strtrim(rows,2) + ' rows)'
      desc[d++] = '1, BASE, ,ROW,FRAME'
      desc[d++] = '0, BUTTON, Header, TAG='+strtrim(-i,2)
      desc[d++] = '0, BUTTON, Data, TAG='+strtrim(i,2)
      desc[d++] = '2, LABEL, '+label+',RIGHT'
  endfor
  desc[d++] = '1, BASE, , ROW'
  desc[d++] = '0, BUTTON, |  Open another file  |, TAG=OPEN'
  desc[d]   = '0, BUTTON, |         Quit         |, TAG=Quit'
  ;;for i=0,d do print,i,": /",desc[i],'/'

  cwfid= cw_form(base,desc,/column)
  WIDGET_CONTROL, base, /REALIZE
  Widget_Control, base, Set_Uvalue= fbt
  xmanager, 'fbtv', base, /No_block
end

PRO fbtv_event, ev
  widget_control, ev.top, get_uvalue=fbt
  ;help,ev,/st

  if ev.tag eq 'QUIT' then begin
      fbt_close, fbt
      Widget_Control, ev.top, /destroy ;; activate self-destruct
      return
  endif else if ev.tag eq 'PRIHEAD' then begin
      fbtheaderview, "Primary Header of "+fbt.filename, fbt.fileobj->prihead()
  endif else if ev.tag eq 'OPEN' then begin
     fbtv
  endif else begin
     ;;print,"Tag is ",ev.tag
     ;;help, fbt.(abs(ev.tag))
      if ev.tag ge 0 then begin
          fbtableview, fbt.(ev.tag)
      endif else begin
          tab= fbt.(-ev.tag)
          fbtheaderview, "Header of "+fbt.filename+" // "+tab->extname(), tab->head()
      endelse
  endelse
end


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;; TABLEVIEW
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

PRO fbtableview, file, tabname
  COMMON fbtable_export, data

  Nshow = 226	;; max. number of lines shown (should be a parameter, or adjustable, or...)
		;; 226 will show the entire environment_description

  type = size(file,/TNAME)
  ;print,"type is ",type

  if type eq 'STRING' then begin
      tab = fitstable_openr(file,strupcase(tabname))
      title= file + " // " + tabname
      data= tab->readrows()
      obj_destroy,tab
  endif else if type eq 'OBJREF' then begin
      class= obj_class(file)
      if class ne 'FITSTABLE' then begin
          print,'Input is a ',class,' object, not a FITSTABLE object'
          return
      endif
      tab= file
      title= (tab->file())->filename() + " // " + tab->extName()
      data= tab->readrows()
      ;; don't damage the object given to us!
  endif else begin
      print,'Input has type ',type
      print,'We accept only filenames or FITSTABLE objects'
      return
  endelse
  ;;help,data,/str

  type = size(data,/TYPE)
  if type ne 8 then begin
      print,"Unstructured data (type ",strtrim(type,2),"), probably an empty table"
      return
  endif

  fields= tag_names(data)
  Nflds = N_elements(fields)

  if N_elements(data) gt Nshow then begin
      tdata = data[ [indgen(Nshow/2),N_elements(data)-1-indgen(Nshow/2)] ]
  endif else tdata= data

  datarr= strarr(Nflds,N_elements(tdata))
  colwid= intarr(Nflds)
  colhdr= fields
  ;help,datarr

  screensz= get_screen_size()

  waitop= widget_base(Title="fbtableview - please wait",$
                      XOffset=screensz[0]/2-200, YOffset=screensz[1]/2-50)
  waitl = widget_label(waitop,Value='Formatting table, please be patient',XSize=400,YSize=100)
  Widget_Control, waitop, /REALIZE

  for i=0,Nflds-1 do begin
      unit = (tab->head())->getpar('TUNIT'+strtrim(i+1,2))
      if size(unit,/TName) eq 'STRING' then $
        colhdr[i] += " ["+strtrim(unit,2)+"]"
      colwid[i]= strlen(colhdr[i])
      Nelem = N_elements(tdata[0].(i))
      print,">>>>> Field ",colhdr[i],",	",strtrim(Nelem,2)," elements"
      if Nelem eq 1 then begin
          datarr[i,*]= strtrim(tdata.(i),2)
      endif else if Nelem le 10 then begin
          Fmt = '(A,' + strtrim(Nelem-1,2) + '(", ",A,$))'
          ;;print,"format is ",Fmt
          for j=0L,N_elements(tdata)-1L do begin
              str = string(strtrim(tdata[j].(i),2),Format=Fmt,/Print)
              datarr[i,j]= str
          endfor
          print,'data[0]=',datarr[i,0]
      endif else datarr[i,*] = 'TOO MUCH'
      colwid[i] = colwid[i] > (max(strlen(datarr[i,*]))+1)
  endfor
  if N_elements(data) gt Nshow then datarr[*,Nshow/2] = '...'

  base = widget_base(Title="fbtableview "+title, /Column, /TLB_SIZE_EVENTS)
  ;action_buts= cw_bgroup(base,[" Okay ","Cancel"],/Row,/Return_Name)

  desc= ['0, BUTTON, Close Window, TAG=Quit',$
         '0, DROPLIST, Choose',$
         '0, DROPLIST, Choose',$
         '0, BUTTON, Quick Plot,TAG=PLOT',$
         '0, BUTTON, Plot data, TAG=PLOT2',$
         '0, BUTTON, Expand Row, TAG=EXPAND',$
         '0, BUTTON, Print Table,TAG=PRINT',$
         '0, BUTTON, Save Table, TAG=SAVE' ]

  for i=0,Nflds-1 do begin
      desc[1] += '|'+fields[i]
      desc[2] += '|'+fields[i]
  endfor
  desc[1] += ', LABEL_LEFT=x-Axis, TAG=X'
  desc[2] += ', LABEL_LEFT=y-Axis, TAG=Y'

  action_buts= cw_form(base,desc)
  table= widget_table(base,UNAME="TABLE", Alignment=1, Disjoint_select=0,/Resizeable_Columns,$
                      SCR_XSIZE= (screensz[0]-20 < 1000), SCR_YSIZE= (screensz[1]-100 < 400),$
                      Column_Labels= colhdr, Column_Widths= colwid*7, Value= datarr, /NO_COPY)

  Widget_Control, waitop, /destroy
  Widget_Control, base, /REALIZE
  Widget_Control, base, Set_Uvalue={ action_buts:action_buts, base_widg:base, tbl_widg:table,$
                                     plotx: 0, ploty: 0, splotx: '', sploty: strarr(8),$
                                     psym: intarr(8), lstyle: intarr(8)+1, color:indgen(8)+1,$
                                     data: data, title: title }, /NO_COPY
  xmanager, "fbtableview", base, /No_Block
end

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

PRO fbtableview_event, ev
  widget_control, ev.top, get_uvalue=data

  if ev.id eq data.action_buts then begin
      ;help,ev,/str
      case ev.tag of
          "QUIT": begin
              Widget_Control, ev.top, /destroy ;; activate self-destruct
              return
          end
          "X": data.plotx= ev.value
          "Y": data.ploty= ev.value
          "PLOT": begin
              if data.plotx eq 0 || data.ploty eq 0 then begin
                  print,"Please choose the axes first"
              endif else begin
                  fields= tag_names(data.data)
                  xid = data.plotx-1
                  yid = data.ploty-1
                  print, "we wanna plot ",fields(xid)," vs ",fields[yid]
                  rkplot, data.data.(xid), data.data.(yid),$
                          Title=data.title, XTitle=fields[xid], YTitle=fields[yid]
              endelse
          end
          "PLOT2": fbtplotselect, data.data, data.title, Parent=data.base_widg
          "EXPAND": begin
             select= Widget_info(data.tbl_widg,/Table_SElect)
             row = select[1]
             print,"ROW ",row
             if row lt N_elements(data.data) then $
                fbtrowview, data.title+', Row '+strtrim(row,2), data.data[row]
          end
          "PRINT": begin
              filename= Dialog_Pickfile(Dialog_parent=ev.top,$
                                        Title = "Select file for printing",$
                                        File  = "table.txt", Default_Extension="txt",$
                                        Filter= ["*.txt"], /Write,/Overwrite_prompt)
              if filename eq "" then return
              openw, unit, filename, /get_lun
              Widget_control, data.tbl_widg, Get_Value=value
              sz = size(value)
              printf,unit,Format='((A,' + strtrim(sz[1]-1) + '(" | ",A)))', value
              ;help,value
              ;print,sz
              close,unit & free_lun,unit
          end
          "SAVE": begin
             filename= Dialog_Pickfile(Dialog_parent=ev.top,$
                                       Title = "Select file for saving",$
                                       File  = "table.sav", Default_Extension="sav",$
                                       Filter= ["*.sav"], /Write,/Overwrite_prompt)
             if filename eq "" then return
             tbldata= data.data
             tblname= data.title
             save,file=filename,tblname,tbldata
          end
      endcase
      Widget_Control, ev.top, Set_Uvalue= data
  endif else begin
     ;;print,"no-button event:" & help,ev,/str
     if ev.id eq data.base_widg  and $
        tag_names(ev,/structure_name) eq "WIDGET_BASE" then begin
        ;; this is a resize-event
        tbl_geom = Widget_info(data.tbl_widg,/Geometry)
        col_wids = Widget_info(data.tbl_widg,/column_widths)
        but_geom = Widget_info(data.action_buts, /GEometry)
        table_w = ev.x - 7
        table_h = ev.y - (but_geom.scr_ysize + 2 * but_geom.margin) - 24
        if total(col_wids) lt tbl_geom.scr_xsize then $
          col_wids += (table_w - tbl_geom.scr_xsize)/N_elements(col_wids)
        widget_control, data.tbl_widg, scr_xsize=table_w, scr_ysize=table_h
        ;;, Column_widths=col_wids
     endif
  endelse
end


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;; ROW VIEWER
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

PRO fbtrowview, title, rowdata

  if size(rowdata,/TNAME) ne 'STRUCT' then begin
     print,"fbtrowview expects a struct"
     return
  endif

  fields= tag_names(rowdata)
  Nflds = N_elements(fields)

  datarr= strarr(3,Nflds)

  for i=0,Nflds-1 do begin
     datarr[0,i] = fields[i]
     datarr[1,i] = size(rowdata.(i),/TName)
     datarr[2,i] = strjoin(strtrim(rowdata.(i),2),", ")
     print,i,datarr[*,i]
  endfor

  print,"Column_widths= ", max(strlen(datarr),Dim=2)

  base = widget_base(Title='fbtrowview '+title, /TLB_SIZE_EVENTS)
  table= widget_table(base,UNAME="TABLE", Alignment=1, Disjoint_select=0,/Resizeable_Columns,$
                      Column_Labels= ["Field", "Type", "Value"], $
                      Column_widths= max(strlen(datarr),Dim=2)*8, Value= datarr, /NO_COPY )
  Widget_Control, base, /REALIZE
  xmanager, "fbtrowview", base, /No_Block
end

PRO fbtrowview_event, ev
  print,"fbtrowview event"
end

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;; PLOT SELECT - selective plotting
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

PRO fbtplotselect, data, title, Parent=Mamabase

  ;;tnpos = strpos(title,' // ',/reverse_search)
  ;;tabname= (tnpos gt -1) ? strmid(title,tnpos+4) : title
  ;;print,'/// fbtpsel: ',title,'/',tnpos
  ;;print,'==> ',tabname

  if keyword_set(Mamabase) then begin
      widget_control, Mamabase, get_uvalue=Mamadata
      psym  = Mamadata.psym
      lstyle= Mamadata.lstyle
      color = Mamadata.color
  endif else begin
      Mamadata= {splotx: '', sploty: strarr(8) }
      psym  = intarr(8)
      lstyle= intarr(8)+1	;; was: indgen(8) mod 6
      color = indgen(8)+1
  endelse

  Nfields= 0
  tags = tag_names(data)
  for i=0,N_elements(tags)-1 do Nfields += N_elements(data[0].(i))

  tabname= strjoin(tags,":")
  fields = strarr(Nfields+1)
  fields[0]='--'
  f=1
  for i=0,N_elements(tags)-1 do begin
      Nelem= N_elements(data[0].(i))
      if Nelem eq 1 then begin
          fields[f] = "d."+tags[i]
          f++
      endif else begin
          for j=0,Nelem-1 do begin
              fields[f] = "d."+tags[i]+'['+strtrim(j,2)+']'
              f++
          endfor
      endelse
  endfor

  top = Widget_base(Title='Select data for plot',$
                    Xoffset=100, Yoffset=20, /Column,/Base_Align_Center)

  plid= -1
  rkplot_ids= rkplot_instances(rkplot_names)
  if rkplot_ids[0] ne -1 then $
     plid= Widget_droplist(top,Title='Show plot in ',Value=['new window', rkplot_names])

  base = Widget_base(top,/Frame,/Row)
  base1= Widget_base(base,Row=9, Grid_layout=0)
  base2= Widget_base(base,Row=9,/Grid_layout)

  xfields= fields
  xfields[0]= 'row no.'

  xlabl= Widget_label(base1,Value=" x:", XSize=32, YSize=30)
  xwidg= Widget_Combobox(base1,VALUE=xfields,/editable,XSize=260)
  label= Widget_Label(base2,VALUE="Linestyle", YSize=30)
  label= Widget_Label(base2,VALUE="Symbol")
  label= Widget_Label(base2,VALUE="Color")

  if Mamadata.splotx ne '' then begin
      idx = where(Mamadata.splotx eq fields)
      idx = idx[0]
      if idx eq -1 then begin
          Widget_control,xwidg,Combobox_Additem=Mamadata.splotx
          idx= N_elements(fields)
          print,"add index:",idx
      endif
  endif else idx=1
  Widget_Control,xwidg, SET_COMBOBOX_SELECT=idx

  ywidg= intarr(8)
  psymw= intarr(8)
  lstyw= intarr(8)
  colrw= intarr(8)

  for yw=0,7 do begin
      ylabl= Widget_label(base1,Value="y"+strtrim(yw,2)+":", XSize=32, YSize=30)
      ywidg[yw]= Widget_Combobox(base1,VALUE=fields,/editable,/Dynamic_Resize,XSize=260)
      lstyw[yw]= widget_Combobox(base2,VALUE=["None","Solid","Dotted","Dashed","Dash Dot","Dash Dot Dot","Long Dash"])
      psymw[yw]= widget_Combobox(base2,VALUE=["None","Plus","Asterisk","Period","Diamond","Triangle","Square","X"])
      colrw[yw]= widget_Combobox(base2,VALUE=["White", "Red", "Green", "Blue", "Cyan", "Magenta", "Yellow"])

      if Mamadata.sploty[yw] ne '' then begin
          idx = where(Mamadata.sploty[yw] eq fields)
          idx = idx[0]
          if idx eq -1 then begin
              Widget_control,ywidg[yw],Combobox_Additem=Mamadata.sploty[yw]
              idx= N_elements(fields)
              print,"add index:",idx
          endif
      endif else idx=(yw eq 0) ? 2 : 0
      Widget_Control,ywidg[yw],SET_COMBOBOX_SELECT=idx
      Widget_Control,psymw[yw],SET_COMBOBOX_SELECT=psym[yw]
      Widget_Control,lstyw[yw],SET_COMBOBOX_SELECT=lstyle[yw]
      Widget_Control,colrw[yw],SET_COMBOBOX_SELECT=color[yw]-1
  endfor

  fbtv_plotcfg= 0	;; make sure there is something
  plotcfgw= -1
  if file_test('~/.fbtv',/READ) then begin
     restore,'~/.fbtv'
     if N_elements(fbtv_plotcfg) gt 0 then begin
        print,"Saved plot-configs:"
        idx = where(fbtv_plotcfg.tabname eq tabname)
        if idx[0] gt -1 then begin
           fbtv_plotcfg= fbtv_plotcfg[idx]
           plotcfg_name= strarr(N_elements(fbtv_plotcfg))
           for i=0,N_elements(fbtv_plotcfg)-1 do begin
              ;;help,fbtv_plotcfg[i],/str
              sy= strmid(fbtv_plotcfg[i].sploty,2)	;; rm "d."
              plotcfg_name[i]= strmid(fbtv_plotcfg[i].splotx,2) + " vs. " + $
                               strjoin(sy[where(sy ne '')], ", ")
              print," -> ",plotcfg_name[i]
              if strlen(plotcfg_name[i]) gt 103 then $
                 plotcfg_name[i] = strmid(plotcfg_name[i],0,100)+'...'
           endfor
           plotcfgw= widget_Combobox(top,VALUE=plotcfg_name)
        endif
     endif
  endif

  butts = cw_form(top,['0, BUTTON, | Cancel |, TAG=Cancel',$
                       '0, BUTTON, |  Okay  |, TAG=OK'])

  Widget_Control, top, /REALIZE
  Widget_Control, top, Set_Uvalue= { mama: Mamabase, butts: butts, xwidg:xwidg, ywidg:ywidg,$
                                     data: data, title: title, tabname: tabname, $
                                     plid: plid, plotidx: 0, rkplot_ids: rkplot_ids,$
                                     psymw: psymw, lstyw: lstyw,  colrw: colrw,$
                                     psym:  psym, lstyle: lstyle, color: color,$
                                     plotcfgw: plotcfgw, plotcfg: fbtv_plotcfg $
                                   }
  xmanager, "fbtplotselect", top, /No_Block
  ;; Currently not needed:, Cleanup="fbtplotselect_cleanup"
end

;PRO fbtplotselect_cleanup, widg
;  print,"fbtplotsel_cleanup widget ",widg
;  widget_control, widg, get_uvalue=me
;  print,"User value:"
;  help,me,/str
;end

PRO fbtplotselect_plot, me, xstr, ystr, ycnt, d
  print,"should plot ",ycnt," lines"

  if xstr eq 'row no.' then xarr= findgen(N_elements(d)) $
  else begin
     xcmd= 'xarr = double('+xstr+')'
     print,"xcmd ",xcmd
     if not execute(xcmd) then print,"execute '"+xcmd+"' failed"
  endelse
  yi = 0
  ytt= ' '
  yarr= dblarr(ycnt,N_elements(d))

  labels= 'dummy'

  for i=0,N_elements(me.ywidg)-1 do begin
      if ystr[i] ne '--' then begin
          ytt += ystr[yi]+" "
          labels= [ labels, ystr[yi] ]

          ycmd= 'yarr['+string(yi)+',*] = '+ystr[i]
          print,"ycmd ",ycmd
          if not execute(ycmd) then print,"execute '"+ycmd+"' failed"
          yi++
      endif
  endfor
  labels= labels[1:*]
  ;print,"fbt linestyle: ",me.lstyle

  plotid= (me.plotidx ne 0) ?  me.rkplot_ids[me.plotidx-1] : 0

  if me.plotidx eq 0  or  widget_info(plotid,/valid) eq 0 then begin
     ;; plot in new window
     rkplot, xarr, yarr, title=me.title, xtitle=xstr, ytitle=ytt,$
             psym=me.psym, Linestyle=me.lstyle, Color=me.color, Labels=labels
  endif else begin
     ;; plot in existing window
     for i=0,ycnt-1 do begin
        rkplot_add_graph, plotid, xarr, yarr[i,*], Label=labels[i], $
                          psym=me.psym[i], Linestyle=me.lstyle[i], Color=me.color[i]
        print,i,"psym=",me.psym[i]," Linestyle=",me.lstyle[i]," Color=",me.color[i]
     endfor
  endelse
end

PRO fbtplotselect_event, ev
  widget_control, ev.top, get_uvalue=me

  if ev.id eq me.butts then begin
      if ev.tag eq 'OK' then begin
          xstr = widget_info(me.xwidg,/ComboBox_GeTtext)
          print,"x: ",xstr
          ycnt= 0
          ystr= strarr(N_elements(me.ywidg))
          for i=0,N_elements(me.ywidg)-1 do begin
              ystr[i]= widget_info(me.ywidg[i],/ComboBox_GeTtext)
              print,"y: ",ystr[i]
              if ystr[i] ne '--' then ycnt++
          endfor
          widget_control, me.mama, get_uvalue= mamadata
          mamadata.splotx= xstr
          mamadata.sploty= ystr
          mamadata.psym  = me.psym
          mamadata.lstyle= me.lstyle
          mamadata.color = me.color	;& print,"mamacolor:",mamadata.color
          widget_control, me.mama, set_uvalue= mamadata

          my_plotcfg= { tabname: me.tabname,$
                        lastused: systime(/Julian),$
                        splotx: xstr,$
                        sploty: ystr,$
                        psym:   me.psym,$
                        lstyle: me.lstyle,$
                        color:  me.color }

          if file_test('~/.fbtv',/READ) then restore,'~/.fbtv'

          ;; append new plotcfg before deleting duplicates to make
          ;; sure there is at least one element left in array.
          fbtv_plotcfg = (N_elements(fbtv_plotcfg) gt 0) ? $
                         [ fbtv_plotcfg, my_plotcfg ] : my_plotcfg

          ;; start at end because we change the size of the arr while
          ;; we loop over it
          ;; last element is new plotcfg and should not be touched
          for i=N_elements(fbtv_plotcfg)-2,0,-1 do begin
             if fbtv_plotcfg[i].tabname eq my_plotcfg.tabname and $
                fbtv_plotcfg[i].splotx eq my_plotcfg.splotx and $
                array_equal( fbtv_plotcfg[i].sploty, my_plotcfg.sploty) and $
                array_equal( fbtv_plotcfg[i].psym,   my_plotcfg.psym  ) and $
                array_equal( fbtv_plotcfg[i].lstyle, my_plotcfg.lstyle) and $
                array_equal( fbtv_plotcfg[i].color,  my_plotcfg.color) then begin

                print,"new plotcfg is already here (index ",strtrim(i,2),") - remove it"
                N = N_elements(fbtv_plotcfg)
                if N ge 2 then begin
                   if i+1 lt N then fbtv_plotcfg[i:N-2] = fbtv_plotcfg[i+1:N-1]
                   fbtv_plotcfg = fbtv_plotcfg[0:N-2]
                endif else print,"fbtplotselect_event: This should not happen"
             endif
          endfor
          save, fbtv_plotcfg, file='~/.fbtv'

          fbtplotselect_plot, me, xstr, ystr, ycnt, me.data
      endif
      Widget_Control, ev.top, /destroy ;; activate self-destruct
  endif else if ev.id eq me.plotcfgw then begin
     new_cfg= me.plotcfg[ev.index]
     ;;help,new_cfg,/str

     widget_control,me.xwidg,GET_Value=fields
     idx = where(new_cfg.splotx eq fields)
     idx = idx[0]
     if idx eq -1 then begin
        Widget_control,me.xwidg,Combobox_Additem=new_cfg.splotx
        idx= N_elements(fields)
        print,"add index:",idx
     endif
     Widget_Control,me.xwidg,SET_COMBOBOX_SELECT=idx

     for yw=0,7 do begin	;; foreach y-line; we set '--' lines, too
        widget_control,me.ywidg[yw],GET_Value=fields ;& print,yw,fields
        idx = where(new_cfg.sploty[yw] eq fields)
        idx = idx[0]
        if idx eq -1 then begin
           Widget_control,me.ywidg[yw],Combobox_Additem=new_cfg.sploty[yw]
           idx= N_elements(fields)
           print,"add index:",idx
        endif
        Widget_Control,me.ywidg[yw],SET_COMBOBOX_SELECT=idx
        Widget_Control,me.psymw[yw],SET_COMBOBOX_SELECT=new_cfg.psym[yw]
        Widget_Control,me.lstyw[yw],SET_COMBOBOX_SELECT=new_cfg.lstyle[yw]
        Widget_Control,me.colrw[yw],SET_COMBOBOX_SELECT=new_cfg.color[yw]-1
     endfor
  endif else begin
      for i=0,7 do begin
          if ev.id eq me.psymw[i] then me.psym[i]  = ev.index
          if ev.id eq me.lstyw[i] then me.lstyle[i]= ev.index
          if ev.id eq me.colrw[i] then me.color[i] = ev.index+1
      endfor
      if ev.id eq me.plid then me.plotidx= ev.index

      Widget_Control, ev.top, Set_Uvalue=me
  endelse
end

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;; HEADER VIEW
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

PRO fbtheaderview, title, head

  str = head->stHead()
  for i=N_elements(str)-1,0,-1 do $
      if not stregex(str[i],'^ *$',/Boolean) then break

  str = str[0:i]
  ;print,str
  ;print,"truncate hdr to",i," lines"

  base = widget_base(Title=title, /Column)
  text = widget_text(base,FRAME=3,$;SCR_XSIZE=640,SCR_YSIZE=640,$
                     Value= str, XSize=80,YSize=(42<i+1),/Scroll)
  ;;quit = widget_button(base, Value="Dismiss")
  butts= cw_form(base,['0, BUTTON, Search, TAG=SEABUT',$
                       '0, TEXT, , Width=42, TAG=SEATXT',$
                       '0, LABEL,                      ',$
                       '0, BUTTON, Dismiss, TAG=QUIT' ] )

  Widget_Control, base, /REALIZE
  Widget_Control, base, Set_Uvalue= { text: text, butts: butts }
  xmanager, "fbtheaderview", base, /No_Block
end

PRO fbtheaderview_event, ev
;  help,ev,/str
  widget_control, ev.top, get_uvalue=me

  if ev.id eq me.butts then begin
      case ev.tag of
          'SEABUT': print,"Search butt!"
          'SEATXT': if ev.value ne '' then begin
              print,"Serach text: ", ev.value
              widget_control, me.text, get_value=str
              help,str
              pos = stregex(str,ev.value,Length=len,/Fold_case)
              idx = where(pos gt -1)
              i0= idx[0]
              if i0 gt -1 then begin
                  print,str[idx]
                  print,"i0: ",i0,pos[i0],len[i0]
                  widget_control, me.text, Set_Text_Select=[ i0*81+pos[i0], len[i0]]
              endif $
              else widget_control, me.text, Set_Text_Select=[0]
          endif else widget_control, me.text, Set_Text_Select=[0]
          'QUIT': Widget_Control, ev.top, /destroy ;; activate self-destruct
      endcase
  endif
end
