;# Name:        fct_magnitude.pro
;# Version:     7.5
;# Created:     Tue, 2008 Jan 22 by Ronny Geisler
;# Last change: Tue Sep 16 11:49:10 2008
;#
;# PURPOSE: calculate from the number of electrons
;#          (without background) the star magnitude
;#
;#
;# Action items: ---
;#



FUNCTION FCT_MAGNITUDE, A_ElectrNr, wave, time, throughput, tel_diam

;INPUT:
; A_ElectrNr*   double  e/raw/pixel  2D-array (# of wavenumbers * 4[ABCD])
; wave          double  1/microns    1D-array (# of wavenumbers)
; time          double  s	     scalar
; throughput    double  -            single
; tel_diam      double  m            single

;* it is really the electronnumber at the detector, if you used the FCT_PHOTONNUMBER before,
;  you have to multiply the photonnumber by the "throughput" first!
;  (in electrons per raw integration time[default: 1ms] and pixel)

;define constants:
PI = 3.1415926535897932d0 ;-    Pi
h  = 6.62606930e-34       ;Js   Planck constant
c  = 299792450.d0         ;m/s  Speed of Light

;# of wavenumbers
n_wave = SIZE(wave,/N_ELEMENTS)



m_m = MAKE_ARRAY(n_wave,/DOUBLE)             ;magnitude vector
F   = [4.7d0,4.07d0,3.5d0,3.0d0,2.6d0]*1e-10 ;flux densities (W/(m2*microns))

;calculate star magnitude m_m (bandpass = 0.09 microns):
FOR i=0, n_wave-1 DO BEGIN ;# of wavenumbers
   m_m[i] = -2.5d0 * ALOG10((h*c*MEAN(A_ElectrNr[i,*])/time) / (throughput*1.d0/wave[i]*F[i]*0.5d0*PI*tel_diam^2*0.09e-6))
   ;PRINT, "lambda,  photon#,  magnitude"
   ;PRINT, 1.d0/wave[i], MEAN(A_ElectrNr[i,*])/(time/1000.d0), m_m[i]
ENDFOR

PRINT, " "
PRINT, "      mean lambda: mean e-/s/pixel: mean magnitude:"
PRINT, MEAN(1.d0/wave), MEAN(A_ElectrNr)/time, MEAN(m_m)
PRINT, " "

RETURN, m_m; vector[# of wavenumbers]: magnitudes for every wavenumber

END
