;
; fix_beam.pro
; Created:     Fri Jul 23 15:51:50 2010 by Rkoehler@lx40
; Last change: Mon Dec 13 17:54:57 2010
;
; PURPOSE:
;	none
;
; WARNING:
;	This program may contain strong violence, adult content, and
;	language.  Parental guidance is advised.
;
; TODO:
;	- copy extension headers
;	- why do we get string arrays instead of simple strings in
;         table template??
;
PRO fix_beam, infile, newbeam

  if N_elements(infile) le 0 then begin
     infile = Dialog_Pickfile(Filter="*.fits",/READ)
     if infile eq "" then return
  endif

  for iFile=0,N_elements(infile)-1 do begin
     print,"Reading ",infile[iFile]
     infits= fbt_open(infile[iFile])

     if (pos = strpos(infile[iFile],".fits",/Reverse_Search)) ge 0 then begin
        outfile = strmid(infile[iFile],0,pos) + "_FIX" + strmid(infile[iFile],pos)
     endif else $
        outfile += "_FIX.fits"

     print,"Writing ",outfile

     Extensions = Tag_Names(infits)
     ;; Tag 0 is filename, Tag 1 is Fileobj
     for iExt=2,N_elements(Extensions)-1 do begin

        outext = fitstable_create( Extensions[iExt], infits.(iExt)->template(), iErr=iErr)

        if iExt eq 2 then begin
           ;; first extension, must create new file and add priHeader
           outext->newFile, outfile, priHead= infits.fileobj->priHead(), iErr=iErr
        endif else begin
           outext->appendtofile, prevext
        endelse

        data = infits.(iExt)->readrows()
        print,Format='(A24,I7," rows")', Extensions[iExt]+":", N_elements(data)

        if (Extensions[iExt] eq 'IMAGING_DATA_FSUA') or (Extensions[iExt] eq 'IMAGING_DATA_FSUB') then begin
           if N_elements(newbeam) le 0 then read,PROMPT='Please enter beam number: ',beam
           if N_elements(newbeam) eq 1 then beam= newbeam $
           else beam= newbeam[iFile mod N_elements(newbeam)]

           print,"Setting STEPPING_PHASE to ",strtrim(beam,2)
           data.Stepping_phase = beam
        endif

        outext->writeRows, data,iErr=iErr

        if iExt gt 2 then obj_destroy,prevext
        prevext = outext

        data = 0	;; data? what data?
     endfor

     outext->close
     obj_destroy,outext	;; close last extension

     fbt_close,infits
  endfor	;; infiles
end


pro fix_beams, files

  if N_elements(files) le 0 then files = file_search("*.fits")

  laststart = ''
  beam = 0

  for iFile=0,N_elements(files)-1 do begin
     LUN = 0
     openr,LUN,files[iFile],/get_lun
     saveLUN= LUN	;; fitsheader does nasty things if it can't open the header
     prihead = obj_new('fitsheader',LUN)

     if obj_valid(prihead) then begin
        tplid= strtrim(prihead->getpar('HIERARCH ESO TPL ID'),2)
        tplst= strtrim(prihead->getpar('HIERARCH ESO TPL START'),2)
        tech = strtrim(prihead->getpar('HIERARCH ESO DPR TECH'),2)
        type = strtrim(prihead->getpar('HIERARCH ESO DPR TYPE'),2)
        catg = strtrim(prihead->getpar('HIERARCH ESO DPR CATG'),2)
        obj_destroy,prihead

        if (tech eq 'IMAGE') and (type eq 'FLAT,SKY') and (catg eq 'CALIB') then begin
           print,files[iFile],"	",TPLid,"	",tplSt,"	",tech,"	",type ;,"	",catg

           if laststart eq '' then beam= 1	;; must be first flat in template
           if laststart eq tplst then beam++	;; not first flat in template

           print,files[iFile]," - Flat No.",beam

           if beam le 2 then fix_beam, files[iFile], beam

           laststart = tplst
        endif else laststart= ''

     endif else print,files[iFile]," - can't open"
     free_lun,saveLUN
  endfor
end
