;
; fix_metro.pro
; Created:     Fri Jul 23 15:51:50 2010 by Rkoehler@lx40
; Last change: Sat Feb 12 10:03:23 2011
;
; PURPOSE:
;	none
;
; WARNING:
;	This program may contain strong violence, adult content, and
;	language.  Parental guidance is advised.
;
; TODO:
;	- copy extension headers
;	- why do we get string arrays instead of simple strings in
;         table template??
;
PRO fix_metro, infile, ZERO=zero

  if N_elements(infile) le 0 then begin
     infile = Dialog_Pickfile(Filter="*.fits",/READ)
     if infile eq "" then return
  endif

  for iFile=0,N_elements(infile)-1 do begin
     print,"Reading ",infile[iFile]
     infits= fbt_open(infile[iFile])

     if (pos = strpos(infile[iFile],".fits",/Reverse_Search)) ge 0 then begin
        outfile = strmid(infile[iFile],0,pos) + "_FIX" + strmid(infile[iFile],pos)
     endif else $
        outfile += "_FIX.fits"

     print,"Writing ",outfile

     Extensions = Tag_Names(infits)
     ;; Tag 0 is filename, Tag 1 is Fileobj
     for iExt=2,N_elements(Extensions)-1 do begin

        outext = fitstable_create( Extensions[iExt], infits.(iExt)->template(), iErr=iErr)

        if iExt eq 2 then begin
           ;; first extension, must create new file and add priHeader
           outext->newFile, outfile, priHead= infits.fileobj->priHead(), iErr=iErr
        endif else begin
           outext->appendtofile, prevext
        endelse

        data = infits.(iExt)->readrows()
        print,Format='(A24,I7," rows")', Extensions[iExt]+":", N_elements(data)

        if Extensions[iExt] eq 'METROLOGY_DATA' then begin
           data.status = 319
           if keyword_set(zero) then data.deltaL = 0.
        endif

        outext->writeRows, data,iErr=iErr

        if iExt gt 2 then obj_destroy,prevext
        prevext = outext

        data = 0	;; data? what data?
     endfor

     outext->close
     obj_destroy,outext	;; close last extension

     fbt_close,infits
  endfor	;; infiles
end
