;
; fix_vlti_steps.pro
; Created:     Fri Jul 23 15:51:50 2010 by Rkoehler@lx40
; Last change: Fri Jun 10 17:47:52 2011
;
; PURPOSE:
;	none
;
; WARNING:
;	This program may contain strong violence, adult content, and
;	language.  Parental guidance is advised.
;
; TODO:
;	- copy extension headers
;	- why do we get string arrays instead of simple strings in
;         table template??
;
pro fix_vlti_steps, files

  if N_elements(files) le 0 then files = file_search("*.fits")

  laststart = ''
  beam = 0

  for iFile=0,N_elements(files)-1 do begin
      print,"Reading ",files[iFile]
      infits= fbt_open(files[iFile])
      if size(infits,/TNAME) ne 'STRUCT' then continue

      prihead = infits.fileobj->prihead()

      tplid= strtrim(prihead->getpar('HIERARCH ESO TPL ID'),2)
      tplst= strtrim(prihead->getpar('HIERARCH ESO TPL START'),2)
      tech = strtrim(prihead->getpar('HIERARCH ESO DPR TECH'),2)
      type = strtrim(prihead->getpar('HIERARCH ESO DPR TYPE'),2)
      catg = strtrim(prihead->getpar('HIERARCH ESO DPR CATG'),2)

      if (tech eq 'INTERFEROMETRY,SPECTRUM') and (type eq 'OBJECT') and (catg eq 'CALIB') then begin
          print,files[iFile],"	",TPLid,"	",tplSt,"	",tech,"	",type ;,"	",catg

          if (pos = strpos(files[iFile],".fits",/Reverse_Search)) ge 0 then begin
              outfile = strmid(files[iFile],0,pos) + "_FIX" + strmid(files[iFile],pos)
          endif else $
            outfile += "_FIX.fits"

          print,"Writing ",outfile

          Extensions = Tag_Names(infits)
          ;; Tag 0 is filename, Tag 1 is Fileobj
          for iExt=2,N_elements(Extensions)-1 do begin

              if (Extensions[iExt] eq 'DOPDC') then begin
                  newrow = {DOPDC_row}
                  outext = fitstable_create( Extensions[iExt], newrow, iErr=iErr)
              endif else $
                outext = fitstable_create( Extensions[iExt], infits.(iExt)->template(), iErr=iErr)

              if iExt eq 2 then begin
                  ;; first extension, must create new file and add priHeader
                  outext->newFile, outfile, priHead= infits.fileobj->priHead(), iErr=iErr
              endif else begin
                  outext->appendtofile, prevext
              endelse

              data = infits.(iExt)->readrows()
              print,Format='(A24,I8," rows")', Extensions[iExt]+":", N_elements(data)

              if (Extensions[iExt] eq 'DOPDC') then begin
                  Nrows = N_elements(data)
                  newdata = replicate({DOPDC_row},Nrows)

                  step = 0
                  oldstate= -1
                  searching= 1

                  for i=0L,Nrows-1 do begin
                      struct_assign,data[i],newrow
                      if searching eq 1 then begin
                         ;; skip everything before and including first STATE=21
                         if data[i].state eq 21 then begin
                            oldstate = 21
                            searching = 0
                         endif
                      endif else if data[i].state ne oldstate then begin
                          step++
                          oldstate= data[i].state
                          print,"Row",i,": new scan no.",step
                      endif
                      newrow.stepping_phase = (data[i].state eq 20 or data[i].state eq 21) ? step : 0
                      newdata[i] = newrow
                  endfor
                  data = newdata
                  newdata = 0
                  print,"Last step No.",step
              endif

              outext->writeRows, data,iErr=iErr
              if iErr ne 0 then print,"Couldn't write new data!"

              if iExt gt 2 then obj_destroy,prevext
              prevext = outext

              data = 0	;; data? what data?
          endfor

          outext->close
          obj_destroy,outext	;; close last extension

      endif
      fbt_close,infits
  endfor
end
