;
; fix_metro.pro
; Created:     Fri Jul 23 15:51:50 2010 by Rkoehler@lx40
; Last change: Fri Feb 11 11:20:28 2011
;
; PURPOSE:
;	none
;
; WARNING:
;	This program may contain strong violence, adult content, and
;	language.  Parental guidance is advised.
;
; TODO:
;	- copy extension headers
;	- why do we get string arrays instead of simple strings in
;         table template??
;
PRO flatten_fsuresp, infile

  if N_elements(infile) le 0 then begin
     infile = Dialog_Pickfile(Filter="*_FSURESP.fits",/READ)
     if infile eq "" then return
  endif

  for iFile=0,N_elements(infile)-1 do begin
     print,"Reading ",infile[iFile]
     infits= fbt_open(infile[iFile])

     if (pos = strpos(infile[iFile],".fits",/Reverse_Search)) ge 0 then begin
        outfile = strmid(infile[iFile],0,pos) + "_FLAT" + strmid(infile[iFile],pos)
     endif else $
        outfile += "_FLAT.fits"

     print,"Writing ",outfile

     Extensions = Tag_Names(infits)
     ;; Tag 0 is filename, Tag 1 is Fileobj
     for iExt=2,N_elements(Extensions)-1 do begin

        outext = fitstable_create( Extensions[iExt], infits.(iExt)->template(), iErr=iErr)

        if iExt eq 2 then begin
           ;; first extension, must create new file and add priHeader
           outext->newFile, outfile, priHead= infits.fileobj->priHead(), iErr=iErr
        endif else begin
           outext->appendtofile, prevext
        endelse

        data = infits.(iExt)->readrows()
        print,Format='(A24,I7," rows")', Extensions[iExt]+":", N_elements(data)

        if strmatch(Extensions[iExt],'RESPONSE_FSU?',/Fold_case) then begin
           data.Real_A=  1.  &  data.Real_err_A= 0.0001
           data.Real_B=  0.  &  data.Real_err_B= 0.0001
           data.Real_C= -1.  &  data.Real_err_C= 0.0001
           data.Real_D=  0.  &  data.Real_err_D= 0.0001
           data.Imag_A=  0.  &  data.Imag_err_A= 0.0001
           data.Imag_B=  1.  &  data.Imag_err_B= 0.0001
           data.Imag_C=  0.  &  data.Imag_err_C= 0.0001
           data.Imag_D= -1.  &  data.Imag_err_D= 0.0001
           data.Covar_A= 42.
           data.Covar_B= 42.
           data.Covar_C= 42.
           data.Covar_D= 42.
        endif
        outext->writeRows, data,iErr=iErr

        if iExt gt 2 then obj_destroy,prevext
        prevext = outext

        data = 0	;; data? what data?
     endfor

     outext->close
     obj_destroy,outext	;; close last extension

     fbt_close,infits
  endfor	;; infiles
end
