;
; labdark.pro
; Created:     Wed Apr 18 15:01:13 2007 by Rkoehler@lx40
; Last change: Thu Dec 10 15:58:43 2009
;
; PURPOSE:
;	this is the template for the dark side of PRIMA
;
; Copyright 2008 Rainer Koehler
;
; This file is part of Pacmart.
;
; Pacmart is free software; you can redistribute it and/or modify
; it under the terms of the GNU General Public License as published by
; the Free Software Foundation; either version 2 of the License, or
; (at your option) any later version.
;
; Pacmart is distributed in the hope that it will be useful,
; but WITHOUT ANY WARRANTY; without even the implied warranty of
; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
; GNU General Public License for more details.
;
; You should have received a copy of the GNU General Public License
; along with Pacmart; if not, write to the Free Software
; Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

PRO sim_header, head, bias, dark, noise

  for i=0,N_elements(bias)-1 do $
     head->addESOpar, 'SIM BIAS'+string(i+1,format="(I1)"), bias[i],$
                      Comment=' bias of wavenumber channel '+strtrim(i+1,2)

  for i=0,N_elements(dark)-1 do $
     head->addESOpar, 'SIM DARK'+string(i+1,format="(I1)"), dark[i],$
                      Comment=' dark current of wavenumber channel '+strtrim(i+1,2)

  if N_elements(noise) gt 1 then begin
     for i=0,N_elements(noise)-1 do $
        head->addESOpar, 'SIM NOISE'+string(i+1,format="(I1)"),noise[i],$
                         Comment=' noise in wavenumber channel '+strtrim(i+1,2)
  endif else $
     head->addESOpar, 'SIM NOISE',noise, Comment=' noise in all wavenumber channels'
end


PRO labdark_img_data_header, head

  head->addESOPar, 'ISS DID', 'JICD-1.0', Comment=' Data Dictionary name'
  head->addESOPar, 'ISS ID' , '1.0',	  Comment=' Data Dictionary version number'
  head->addESOPar, 'ISS DIP', '089-3200-6467', Comment=' Data Dictionary phone number'

  head->addPar, 'NREGION', 4,	  Comment=' Number of regions used (always 4)'
  head->addPar, 'MAXTEL', 0,	  Comment=' Maximum number of contributing telescopes'
end

PRO labdark_write_imaging_data, table, nexp, dit, bias, dark, noise

  tabdat = replicate( { imaging_data_FSU_row }, nexp )
  tabdat.time = lindgen(nexp) * long(dit*1000000L + 100000L) ;; microsec, 100ms for readout
  for i=0,nexp-1 do begin
      tabdat[i].data1= bias + dark * dit + noise * randomn(seed,6)
      tabdat[i].data2= bias + dark * dit + noise * randomn(seed,6)
      tabdat[i].data3= bias + dark * dit + noise * randomn(seed,6)
      tabdat[i].data4= bias + dark * dit + noise * randomn(seed,6)
  endfor
  table->writeRows, tabdat
end


PRO labdark_file, MJD0, TPLstart, nexp, dit, bias, dark, noise, FSUA=fsuA, FSUB=fsuB

  dit = float(dit)	;; will it float?
  dita= 0. & if keyword_set(fsuA) then dita= dit
  ditb= 0. & if keyword_set(fsuB) then ditb= dit

  filename = 'PACMA.' + MJD_to_ESO_string(MJD0) + ".fits"
  print, "File: ",filename

  pfile= Pacman_binfile(MJD0)
  ;;
  ;; PRIMARY header
  ;;
  prihead= pfile.arrdesc->prihead()
  prihead->addPar,'EXPTIME',nexp*dit,Comment= " (seconds)"

  standard_primary_header, prihead, dita,ditb, SIM_CODE='LD'
  prihead->addESOPar,'TPL START', MJD_to_ESO_string(TPLstart), Comment=" TPL start time"
  ;;
  ;; Tables in DICD-Order
  ;;
  Pacman_binfile_create_arrdesc, pfile, filename             ;; Array description: empty
  Pacman_binfile_create_arrgeom, pfile                       ;; Array geometry: empty
  Pacman_binfile_create_optrain, pfile                       ;; Optical train: empty
  Pacman_binfile_create_MDL, pfile                           ;; Main Delay: non existant
  ;;
  ;; Img_detector_FSUA: not empty
  ;;
  head= pfile.det_A->head()
  standard_img_detector_header, head, 'Romeo', 8.9d
  if keyword_set(FSUA) then sim_header, head, bias, dark, noise

  Pacman_binfile_create_DetA, pfile
  if keyword_set(FSUA) then standard_img_detector_table, pfile.det_A
  ;;
  ;; imaging data FSUA: not empty
  ;;
  labdark_img_data_header, pfile.dataA->head()

  Pacman_binfile_create_DataA, pfile
  if keyword_set(FSUA) then labdark_write_imaging_data, pfile.dataA, nexp, dit, bias, dark, noise
  ;;
  ;; Imaging detector FSUB: not empty
  ;;
  head= pfile.det_B->head()
  standard_img_detector_header, head, 'Juliet', 8.9d
  if keyword_set(FSUA) then sim_header, head, bias, dark, noise

  Pacman_binfile_create_DetB, pfile
  if keyword_set(FSUB) then standard_img_detector_table, pfile.det_B
  ;;
  ;; imaging data FSUB: not empty
  ;;
  labdark_img_data_header, pfile.dataB->head()

  Pacman_binfile_create_DataB, pfile
  if keyword_set(FSUB) then labdark_write_imaging_data, pfile.dataB, nexp, dit, bias, dark, noise
  ;;
  ;; more empty Tables
  ;;
  Pacman_binfile_create_metro, pfile	;; PRIMET: empty
  Pacman_binfile_create_metroB,pfile    ;; PRIMETB: empty
  Pacman_binfile_create_DDL,   pfile    ;; DDL: empty
  Pacman_binfile_create_OPDC,  pfile
  Pacman_binfile_create_DOPDC, pfile
  ;;
  ;; close the door and cleanup before you leave
  ;;
  Pacman_binfile_close,  pfile
  Pacman_binfile_cleanup,pfile
end

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

PRO labdark, MJD=MJD, NEXP=nexp, DITs=dits, FSUA=fsua, FSUB=fsub, BIAS=bias, DARK=dark, NOISE=noise

  Common PACSIM_DEFAULTS

  print,"===== labdark template ====="

  if not keyword_set(MJD)   then MJD = MJulDay(2008, 4, 1, 0,0,0)
  if not keyword_set(nexp)  then nexp= 100
  if not keyword_set(DITs)  then dits= [ 0.125, 0.125, 0.25, 0.5, 1.0, 1.0 ]
  if not keyword_set(bias)  then bias = ld_bias
  if not keyword_set(dark)  then dark = ld_dark
  if not keyword_set(noise) then noise= ld_noise
  if not keyword_set(fsua) and not keyword_set(fsub) then begin & fsua=1 & fsub=1 & endif

  TPLstart= MJD
  ;;openw,unit,'PACMA.'+MJD_to_ESO_string(MJD)+".sof",/get_lun

  for i=0,N_elements(dits)-1 do begin
      labdark_file, MJD, TPLstart, nexp, dits[i], bias, dark, noise, FSUA=fsua, FSUB=fsub
      ;;printf,unit,'PACMA.' + MJD_to_ESO_string(MJD) + ".fits  LAB_DARK_RAW"
      MJD += 1./24./60.
  end
  ;;close,unit & free_lun,unit
  print,"===== Labdark template finished ====="
  print,""
end

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

PRO labdark_zero

  labdark, BIAS= [ 0., 0., 0., 0., 0., 0. ],$
           DARK= [ 0., 0., 0., 0., 0., 0. ],$
           NOISE=[ 1., 1., 1., 1., 1., 1. ] * 0. ;;/ 1e6
  ;; Nick-algorithms need some noise
end
