;
; labflat.pro
; Created:     Wed Apr 18 15:01:13 2007 by Rkoehler@lx40
; Last change: Mon Nov 16 17:54:36 2009
;
; PURPOSE:
;	this is the template for the flat side of PRIMA
;
; Copyright 2008 Rainer Koehler
;
; This file is part of Pacmart.
;
; Pacmart is free software; you can redistribute it and/or modify
; it under the terms of the GNU General Public License as published by
; the Free Software Foundation; either version 2 of the License, or
; (at your option) any later version.
;
; Pacmart is distributed in the hope that it will be useful,
; but WITHOUT ANY WARRANTY; without even the implied warranty of
; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
; GNU General Public License for more details.
;
; You should have received a copy of the GNU General Public License
; along with Pacmart; if not, write to the Free Software
; Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

PRO labflat_sim_header, head, bias, flux, noise

  for i=0,N_elements(bias)-1 do $
     head->addESOpar, 'SIM BIAS'+string(i+1,format="(I1)"), bias[i],$
                      Comment=' bias of wavenumber channel '+strtrim(i+1,2)

  if N_elements(flux) gt 1 then  begin
     sz= size(flux)
     for ch=0,sz[1]-1 do begin
        for i=0,sz[2]-1 do begin
           pixnm = string(byte('A')+byte(i)) + string(ch+1,format="(I1)")
           head->addESOpar, 'SIM FLUX'+pixnm, flux[ch,i], Comment=' flux in pixel '+pixnm
        endfor
     endfor
  endif else $
     head->addESOpar, 'SIM FLUX',flux, Comment=' flux in all channels'

  if N_elements(noise) gt 1 then begin
     sz= size(noise)
     for ch=0,sz[1]-1 do begin
        for i=0,sz[2]-1 do begin
           pixnm = string(byte('A')+byte(i)) + string(ch+1,format="(I1)")
           head->addESOpar, 'SIM NOISE'+pixnm, noise[ch,i],$
                         Comment=' noise in pixel '+pixnm
        endfor
     endfor
  endif else $
     head->addESOpar, 'SIM NOISE',noise, Comment=' noise in all wavenumber channels'
end

PRO labflat_img_data_header, head, active, bias, flat, noise

  head->addESOPar, 'ISS DID', 'JICD-1.0', Comment=' Data Dictionary name'
  head->addESOPar, 'ISS ID' , '1.0',	  Comment=' Data Dictionary version number'
  head->addESOPar, 'ISS DIP', '089-3200-6467', Comment=' Data Dictionary phone number'

  head->addPar, 'NREGION', 4,	  Comment=' Number of regions used (always 4)'
  head->addPar, 'MAXTEL', 0,	  Comment=' Maximum number of contributing telescopes'

  if not keyword_set(active) then return

  labflat_sim_header, head, bias, flat, noise
end

PRO labflat_write_imaging_data, table, nexp, dit, bias, flux, noise, stepphase

  tabdat = replicate( { imaging_data_FSU_row }, nexp )
  tabdat.time = lindgen(nexp) * long(dit*1000000L + 100000L) ;; microsec, 100ms for readout
  for i=0,nexp-1 do begin
      tabdat[i].data1= round(bias + flux[*,0] * dit + noise[*,0] * randomn(seed,6))
      tabdat[i].data2= round(bias + flux[*,1] * dit + noise[*,1] * randomn(seed,6))
      tabdat[i].data3= round(bias + flux[*,2] * dit + noise[*,2] * randomn(seed,6))
      tabdat[i].data4= round(bias + flux[*,3] * dit + noise[*,3] * randomn(seed,6))
  endfor
  tabdat.stepping_phase = stepphase
  table->writeRows, tabdat
end


PRO labflat_file, MJD0, TPLstart, nexp, dit, bias, flux, noise, stepphase, FSUA=fsuA, FSUB=fsuB

  dit = float(dit)	;; will it float?
  dita= 0. & if keyword_set(fsuA) then dita= dit
  ditb= 0. & if keyword_set(fsuB) then ditb= dit

  filename = 'PACMA.' + MJD_to_ESO_string(MJD0) + ".fits"
  print, "File: ",filename

  pfile= Pacman_binfile(MJD0)
  ;;
  ;; PRIMARY header
  ;;
  prihead= pfile.arrdesc->prihead()
  prihead->addPar,'EXPTIME',nexp*dit,Comment= " (seconds)"

  standard_primary_header, prihead, dita,ditb, SIM_CODE='LF'
  prihead->addESOPar,'TPL START', MJD_to_ESO_string(TPLstart), Comment=" TPL start time"
  ;;
  ;; Tables in DICD-Order
  ;;
  Pacman_binfile_create_arrdesc, pfile, filename	;; Array description: empty
  Pacman_binfile_create_arrgeom, pfile			;; Array geometry: empty
  Pacman_binfile_create_optrain, pfile			;; Optical train: empty
  Pacman_binfile_create_MDL,     pfile			;; Main Delay: empty
  ;;
  ;; Img_detector_FSUA: not empty
  ;;
  head= pfile.det_A->head()
  standard_img_detector_header, head, 'Romeo', 8.9d
  if keyword_set(FSUA) then labflat_sim_header, head, bias, flux, noise

  Pacman_binfile_create_DetA, pfile
  if keyword_set(FSUA) then standard_img_detector_table, pfile.det_A
  ;;
  ;; imaging data FSUA: not empty
  ;;
  labflat_img_data_header, pfile.dataA->head(), fsua, bias, flux, noise
  Pacman_binfile_create_DataA, pfile
  if keyword_set(FSUA) then $
     labflat_write_imaging_data, pfile.dataA, nexp, dit, bias, flux, noise, stepphase
  ;;
  ;; Imaging detector FSUB: not empty
  ;;
  head= pfile.det_B->head()
  standard_img_detector_header, head, 'Juliet', 8.9d
  if keyword_set(FSUA) then labflat_sim_header, head, bias, flux, noise

  Pacman_binfile_create_DetB, pfile
  if keyword_set(FSUB) then standard_img_detector_table, pfile.det_B
  ;;
  ;; imaging data FSUB: not empty
  ;;
  labflat_img_data_header, pfile.dataB->head(), fsuB, bias, flux, noise
  Pacman_binfile_create_DataB, pfile
  if keyword_set(FSUB) then $
     labflat_write_imaging_data, pfile.dataB, nexp, dit, bias, flux, noise, stepphase
  ;;
  ;; more empty Tables
  ;;
  Pacman_binfile_create_metro, pfile	;; PRIMET: empty
  Pacman_binfile_create_metroB,pfile    ;; PRIMETB: empty
  Pacman_binfile_create_DDL,   pfile    ;; DDL: empty
  Pacman_binfile_create_OPDC,  pfile
  Pacman_binfile_create_DOPDC, pfile
  ;;
  ;; close the door and cleanup before you leave
  ;;
  Pacman_binfile_close,  pfile
  Pacman_binfile_cleanup, pfile
end

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

PRO labflat, MJD=MJD, NEXP=nexp, DITs=dits, FSUA=fsua, FSUB=fsub, BIAS=bias, FLUX=flux, NOISE=noise

  Common PACSIM_DEFAULTS

  print,"===== labflat template ====="

  if not keyword_set(MJD)   then MJD = MJulDay(2008,4,1, 0,10,0)
  if not keyword_set(nexp)  then nexp= 100
  if not keyword_set(DITs)  then dits= 1.0
  if not keyword_set(bias)  then bias= ld_bias
  if not keyword_set(flux)  then flux= lf_flux*2000.
  if not keyword_set(noise) then noise= lf_noise
  if not keyword_set(fsua) and not keyword_set(fsub) then begin & fsua=1 & fsub=1 & endif

  TPLstart= MJD

  for i=0,N_elements(dits)-1 do begin
      labflat_file, MJD, TPLstart, nexp, dits[i], bias, flux, noise, 1, FSUA=fsua, FSUB=fsub
      MJD += 1./24./60.
      labflat_file, MJD, TPLstart, nexp, dits[i], bias, flux, noise, 2, FSUA=fsua, FSUB=fsub
      MJD += 1./24./60.
  end
  print,"===== Labflat template finished ====="
  print,""
end

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

PRO labflat_testfiles
  MJD = MJulDay(2009,4,1, 0,10,0)

  labflat,MJD=MJD,/FSUA,/FSUB & MJD += 2./24./60.
  labflat,MJD=MJD,/FSUA & MJD += 2./24./60.
  labflat,MJD=MJD,/FSUB & MJD += 2./24./60.
end
