;
; phase.pro
; Created:     Tue Aug 21 14:03:36 2007 by Rkoehler@lx40
; Last change: Tue Dec  1 15:12:50 2009
;
; Copyright 2008 Rainer Koehler
;
; This file is part of Pacmart.
;
; Pacmart is free software; you can redistribute it and/or modify
; it under the terms of the GNU General Public License as published by
; the Free Software Foundation; either version 2 of the License, or
; (at your option) any later version.
;
; Pacmart is distributed in the hope that it will be useful,
; but WITHOUT ANY WARRANTY; without even the implied warranty of
; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
; GNU General Public License for more details.
;
; You should have received a copy of the GNU General Public License
; along with Pacmart; if not, write to the Free Software
; Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
;
function modulus_ch, d, ch
  re = d.real_a[ch]
  im = d.imag_a[ch]
  ;;help,re,im
  return, sqrt(re*re + im*im)
end

function modulus, re, im
  return, sqrt(re*re + im*im)
end

function phase, d, ch
  return, atan( float(d.data2[ch]-d.data4[ch]), float(d.data1[ch]-d.data3[ch]))*180./!pi
end

function phaseABCD, d, ch
  return, atan( float(d.B[ch]-d.D[ch]), float(d.A[ch]-d.C[ch]))*180./!pi
end
