#!/usr/bin/perl -w
#
# primet_status.pl
# Created:     Tue Jul 28 02:34:51 2009 by Koehler@Six
# Last change: Tue Jul 28 02:41:46 2009
#
# This file is Hellware!
# It may send you and your data straight to hell without further notice.
#
if ($#ARGV lt 0 or $ARGV[0] =~ /-h/) {
  print "USAGE: perl $0 status-code\n";
  exit 0;
}

while($status = shift) {
  print "Status $status:\n";
  print "  450kHz Ref detected\n" if ($status & 1);
  print "  650kHz Ref detected\n" if ($status & 2);
  print "  450k Probe detected\n" if ($status & 4);
  print "  650k Probe detected\n" if ($status & 8);
  print "  PLL Locked         \n" if ($status & 0x10);
  print "  200kHz Probe detected\n" if ($status & 0x20);
  print "  PM Overflow (BAD)\n"    if ($status  & 0x40);
  print "  FC Overflow (BAD)\n"    if ($status  & 0x80);
  print "  Trigger detected\n"     if ($status & 0x100);
  print "  Reset detected (BAD)\n" if ($status & 0x200);
  print "---------------------------------------\n";
}
