;
; rkscired2.pro
; Created:     Thu Mar 10 17:03:11 2011 by Rkoehler@lx40
; Last change: Fri May 27 15:07:20 2011
;
; PURPOSE:
;	none
;
; WARNING:
;	This program may contain strong violence, adult content, and
;	language.  Parental guidance is advised.
;
;	The source code will be unreadable if viewed in eclipse
;
PRO rkscired2, files, residuals

  Nfiles= N_elements(files)

  if Nfiles lt 1 then begin
     files = file_search('PACMA*.fits')
     Nfiles= N_elements(files)
  endif

  Nrows_per_file= intarr(Nfiles)
  mtime = dblarr(Nfiles)
  mdopd = dblarr(Nfiles)
  mswap = dblarr(Nfiles)


  for iFile=0,Nfiles-1 do begin
     fname= files[iFile]
     file = fbt_open(fname)
     phead= file.fileobj->prihead()
     MJD  = phead->getpar('MJD-OBS')
     mode = phead->getpar('HIERARCH ESO INS MODE')
     data = file.Diff_delay->readrows()
     idx  = where(data.QUALity eq 0, nrows)
     swap1= replicate(1.d,nrows)

     baseline, fname, TIMES=data[idx].time_ave, LENGTH=blen1, ANGLE=bangle1, /Quiet
     if strmatch(mode,'SWAP*') then begin
        blen1 = -blen1
        swap1 = -swap1
        print,fname,": swapping"
     endif

     Nrows_per_file[iFile] = nrows

     if iFile le 0 then begin
        MJD0  = MJD
        stime = 0.
        time  = data[idx].time_ave[0]
        metro = data[idx].total[0]
        blen  = blen1
        bangle= bangle1
        swap  = swap1
     endif else begin
        stime = (MJD-MJD0)*86400.d
        time  = [time , data[idx].time_ave[0]+stime ]
        metro = [metro, data[idx].total[0] ]
        blen  = [blen , blen1  ]
        bangle= [bangle,bangle1]
        swap  = [swap , swap1  ]
     endelse

     mtime[iFile] = mean(data[idx].time_ave[0]) + stime
     mdopd[iFile] = median(data[idx].total[0])
     mswap[iFile] = swap1[0]

     print, Format='(">",A,"<",F16.8,F8.2,F5.2)',mode,MJD,stime,data[0].time_ave

     fbt_close,file
  endfor

  Npnts = N_elements(metro)
  print,Npnts," data points"

  ;separation = 9.2d *!dpi/180./3600.	;; arcsec to rad, HIP DM for HD 100286 alias HIP 56280
  ;positangle = 210.d - 180.d		;; deg

  separation = 35.7d	;; arcsec to rad, HD 66598 from BrightDoubles
  positangle = 135.d	;; deg

  Expect_x = -separation * sin(positangle * !dpi/180.d)
  Expect_y =  separation * cos(positangle * !dpi/180.d)

  separation *= !dpi / 180.d/3600.d 	;; arcsec to rad

  model = blen * separation * cos( (bangle-positangle) * !dpi/180.d )

  plots= dblarr(3,Npnts)
  plots[0,*] = metro
  plots[1,*] = model
  plots[2,*] = metro-model

  ;if !D.name eq "PS" then begin
  ;   tek_color
  ;
  ;   device,file='delays1.ps',/landscape,/color, YSIZE=4.,/inch	;; 4in heigh
  ;   plot, time, metro*1e3, /nodata, xtitle='Time [sec]', ytitle='Delay [mm]',$
  ;         xthick=3, ythick=3, charsize=1.2
  ;   oplot, time, metro*1e3, psym=3, color=2
  ;   device,/close
  ;endif else $
  ;   rkplot, time, plots, psym=[3,3,3], linestyle=[0,0,0], color=[1,2,3], $
  ;           labels=['Metrology', 'Model', 'Metro-Model']

  ;; simplified for Science Team:

  device,decompos=1
  ;rkplot, time, metro, psym=3, linestyle=0, color=2, xtitle='Time', ytitle='Delay', labels=''
  ;rkplot, mtime, mdopd, psym=1, linestyle=0, color=2, xtitle='Time', ytitle='Delay', labels=''

  ;;;;; now do the special fit

  strad= time * 1.0027379093d * !pi/12./3600d	;; siderial time, convert sec -> rad
  mstra= mtime * 1.0027379093d * !pi/12./3600d

  Amat = dblarr(4,Npnts)

  Amat[0,*] = swap		;; constant term from vec_B * vec_ds
  Amat[1,*] = swap*cos(strad)
  Amat[2,*] = swap*sin(strad)
  Amat[3,*] = 1.		;; metrology zeropoint

  res = la_least_squares(Amat,metro,Residual=resi,/double)

  print,"Astrom-const:",res[0]
  print,"Astrom-cos:  ",res[1]
  print,"Astrom-sin:  ",res[2]
  print,"PRIMET-const:",res[3]
  print,"Residual:",resi

  delay = (metro - res[3])	;; contains swap sign

  plots[0,*] = delay * swap
  plots[1,*] = model * swap

  if !D.name eq "PS" then begin
     device,file='delays2.ps',/landscape,/color, YSIZE=4.,/inch	;; 4in heigh
     ;plot, time, plots[1,*]*1e3, /nodata, yst=16
     ;polyfill,[!X.crange[0],!X.crange[1],!X.crange[1],!X.crange[0]],$
     ;         [!Y.crange[0],!Y.crange[0],!Y.crange[1],!Y.crange[1]], color=21

     plot, time, plots[1,*]*1e3, /nodata, xtitle='Time [sec]', ytitle='Delay [mm]', yst=16,/noerase
     oplot, time, plots[0,*]*1e3, psym=3, color=2
     oplot, time, plots[1,*]*1e3, psym=3, color=3
     device,/close
  endif else $
     rkplot, time, plots[0:1,*], psym=[3,3,3], linestyle=[0,0,0], color=[2,3,1], $
             labels=['Delay', 'Model', 'Metro-Model'], xtitle='Time', ytitle='Delay'

  residuals = delay - swap * (res[0] + res[1]*cos(strad) + res[2]*sin(strad))

  rkplot, time, residuals*1d6, psym=[3,3,3], linestyle=[0,0,0], color=[2,3,1], $
             labels=['Residuals'], xtitle='Time', ytitle='Residual Delay [um]'

  mresi = mdopd - res[3] - mswap * (res[0] + res[1]*cos(mstra) + res[2]*sin(mstra))
  rkplot, mtime, mresi*1d6, psym=1, linestyle=[0,0,0], color=1, $
             labels=['Residuals'], xtitle='Time', ytitle='Residual Delay [um]'


  sep  = delay / blen		;; both contain swap sign => sep does not
  sep *= 180.d*3600.d/!dpi	;; convert to arcsec

  pa = bangle * !dpi/180.d

  sepx= -sep * sin(pa)
  sepy=  sep * cos(pa)

  if !D.name eq "PS" then $
     device,file='separation.ps',/landscape,/color $
  else begin
     window,0
     device,decompos=0
  endelse

  plot, sepx,sepy, /iso, /nodata, xrange=[-34,-20], yrange=[-27,-12],/xst,/yst,$
        xtitle='Offset West-East [arcsec]', ytitle='Offset North-South [arcsec]'

  avg_sep= dblarr(Nfiles)
  avg_bpa= dblarr(Nfiles)	;; baseline projection angle
  start = 0

  for iFile=0,Nfiles-1 do begin
     nrows = Nrows_per_file[iFile]
     avg_sep[iFile] = mean( sep[start:start+nrows-1] )
     avg_bpa[iFile] = mean(  pa[start:start+nrows-1] )
     start += nrows	;; start of next file
  endfor

  sepxx= -avg_sep * sin(avg_bpa)
  sepyy=  avg_sep * cos(avg_bpa)

  perp = !dpi/2.	;; 90deg = "perpendicular"

  for i=0,Nfiles-1 do begin
     dx = -20. * sin(avg_bpa[i]+perp)
     dy =  20. * cos(avg_bpa[i]+perp)

     oplot, sepxx[i]+[-dx,dx], sepyy[i]+[-dy,dy], linestyle=0, color=15
  endfor

  oplot, sepx,sepy, psym=3, color=2
  oplot, [Expect_x], [Expect_y], psym=1, color=3, symsize=5.

  if !D.name eq 'PS' then device,/close
  device,decom=1
end
