;
; scan_labdarks.pro
; Created:     Tue Feb 16 14:20:14 2010 by Koehler@Six
; Last change: Fri Feb 19 15:46:20 2010
;
PRO scan_labdarks, flist, OUTFILE=outfile

  if N_elements(flist) le 0 then flist= file_search(".", "*_LABDARK.fits")
  if not keyword_set(outfile) then outfile= "labdark_overview.csv"

  openw,out,outfile,/get_lun
  printf,out,Format='(A,", ",A,",",A,$)',"Filename","FSU","DIT"
  for iABCD=1,4 do begin
     ;;printf,out,Format='(", DATA",A,$)',strtrim(iABCD,2)
     for iCh=1,5 do $
        printf,out,Format='(", ","MEAN",I1,"[",I1,"], ","STDEV",I1,"[",I1,"]",$)',$
               iABCD,iCh, iABCD,iCh
  endfor
  printf,out

  FSUs = [ "FSUA", "FSUB" ]

  for iFile=0,N_elements(flist)-1 do begin
     print,"No.",iFile," = ",flist[iFile]

     for iFSU=0,1 do begin

        table= fitstable_openr(flist[iFile],'DARK_'+FSUs[iFSU]+'_AVE')
        data = table->readrows()

        if size(data,/tname) eq 'STRUCT' then begin

           for iDit=0,N_elements(data)-1 do begin
              printf,out,Format='(A,", ",A,",",F10.7,$)',flist[iFile],FSUs[iFSU],data[iDit].DIT
              tags= Tag_names(data)
              for iABCD=1,4 do begin
                 ;;printf,out,Format='(", DATA",A,$)',strtrim(iABCD,2)
                 midx = where(tags eq 'MEAN'+strtrim(iABCD,2))
                 sidx = where(tags eq 'STDEV'+strtrim(iABCD,2))
                 for iCh=1,5 do begin
                    mn = data[iDit].(midx)[iCh]
                    sd = data[iDit].(sidx)[iCh]
                    printf,out,Format='(", ",F10.3,", ",%"%10.3f",$)',mn,sd
                 endfor
              endfor
              printf,out
           endfor
        endif
        obj_destroy,table
     endfor
  endfor

  free_lun,out	;; also closes file
end
