;
; scired2.pro
; Created:     Wed Sep  3 16:42:33 2008 by Rkoehler@lx39
; Last change: Mon Dec 15 15:14:16 2008
;
; PURPOSE:
;	unit and other tests for pacma_scired2
;
; Copyright 2008 Rainer Koehler
;
; This file is part of Pacmart.
;
; Pacmart is free software; you can redistribute it and/or modify
; it under the terms of the GNU General Public License as published by
; the Free Software Foundation; either version 2 of the License, or
; (at your option) any later version.
;
; Pacmart is distributed in the hope that it will be useful,
; but WITHOUT ANY WARRANTY; without even the implied warranty of
; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
; GNU General Public License for more details.
;
; You should have received a copy of the GNU General Public License
; along with Pacmart; if not, write to the Free Software
; Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
;
;
PRO write_obscat_row, obscat, pos

  obscat_row = obscat->template()
  ;help,obscat_row,/str
  for i=0,N_tags(obscat_row)-1 do obscat_row.(i)=0
  ;print,obscat_row

  obscat_row.id    = string(Format='(A25)',pos.name)
  obscat_row.CAL   = 1	;; for now
  obscat_row.REF_EPOCH=2000.0
  obscat_row.RA_SI_EPOCH=2000.0
  obscat_row.DEC_SI_EPOCH=2000.0

  obscat_row.RA_SI = pos.RA
  obscat_row.Dec_Si= pos.Dec
  obscat->writeRows, obscat_row
end


PRO aberration

  JD0 = Julday(3,21,2008, 0,0,0)

  JPLEPHREAD, getenv('HOME')+'/PRIMA/cmephem/JPLEPH.405', pinfo, pdata, [JD0-1,JD0+1]
  JPLEPHINTERP, pinfo, pdata, JD0, Xe, Ye, Ze, VXe, VYe, VZe,$
                /EARTH, /VELOCITY, posunits='AU'
  ;; now X/Y/Zearth are vectors with earth position in AU at JD0

  environment, MJD=MJulday(2008,3,21,0,0,0)-0.5

  obscat= fitstable_create('OBSERVER_CATALOG', '../PACMA_COCO_OBCAT.fits', iErr=iErr)
  if iErr then begin
      print,"Please make sure ../PACMA_COCO_OBCAT.fits is here."
      return
  endif
  obscat->close

  prihead= obscat->prihead()
  prihead->addESOPar,'PRO CATG', 'COCO_OBCAT', Comment=' professional category oberver catalog'
  prihead->addESOPar,'WARN1','THIS FILE WAS MADE FROM 100% RECYCLABLE ELECTRONS'
  prihead->addESOPar,'WARN2','Contents may have settled during shipping.'
  prihead->addESOPar,'WARN3','Warning: Do not leave human operator unattended at any time!'

  obscat->newfile, 'OBERVER_CATALOG.fits', iErr=iErr, prihead=prihead
  if iErr then $
	print,"creation of new file OBERVERS_CATALOG.FITS had issues, iErr =",iErr


  a = obj_new("astrometry")
  a->set_rates, FSUA=4., FSUB=10.
  a->set_n_phonoise,1
  a->set_primet_noise, 1d-6
  a->set_primet0, [ 0., 5.d-3/3600.]	;; 5um/hr

  V_RA =  12./!dpi * atan( VYe, VXe)  &  if (V_RA lt 0.) then V_RA += 24.
  V_Dec= 180./!dpi * asin( VZe/sqrt(VXe*VXe+VYe*VYe+VZe*VZe))

  print,"Earth going towards",V_RA,V_Dec

  pos_A= { Name: "Max diff Aberration A", RA: V_RA, Dec: V_Dec }
  pos_B= { Name: "Max diff Aberration B", RA: V_RA, Dec: V_Dec+10d/3600. }

  write_obscat_row, obscat, pos_A
  write_obscat_row, obscat, pos_B

  starspectrum_one, 'STARSPECTRUM_MaxA.fits', pos_A, MJD= MJulday(2008,3,20, 0, 0,0)
  starspectrum_one, 'STARSPECTRUM_MaxB.fits', pos_B, MJD= MJulday(2008,3,20, 0,10,0)

  a->set_pos, A=pos_A, B=pos_B
  a->set_startMJD, MJulday(2008,3,21,0,0,0)
  a->simulate

  vxp = -Vye	;; vector perpendicular to Vearth, in x-y-plane
  vyp =  Vxe
  vzp =  0

  V_RA = 12./!dpi * atan( VYp, VXp)  &  if (V_RA lt 0.) then V_RA += 24.
  V_Dec= 0.	;; 180./!dpi * asin( VZp/sqrt(...))

  print,"Perpendicular:",V_RA,V_Dec

  pos_A= { Name: "Zero diff Aberration A", RA: V_RA, Dec: V_Dec-5d/3600. }
  pos_B= { Name: "Zero diff Aberration B", RA: V_RA, Dec: V_Dec+5d/3600. }

  write_obscat_row, obscat, pos_A
  write_obscat_row, obscat, pos_B

  starspectrum_one, 'STARSPECTRUM_ZeroA.fits', pos_A, MJD= MJulday(2008,3,20, 0,20,0)
  starspectrum_one, 'STARSPECTRUM_ZeroB.fits', pos_B, MJD= MJulday(2008,3,20, 0,30,0)

  a->set_pos, A=pos_A, B=pos_B
  a->set_startMJD, MJulday(2008,3,21,0,30,0)
  a->simulate

  vxp =  0	;; vector perpendicular to Vearth, in y-z-plane
  vyp =  Vze
  vzp = -Vye

  V_RA =  12./!dpi * atan( VYp, VXp)  &  if (V_RA lt 0.) then V_RA += 24.
  V_Dec= 180./!dpi * asin( VZp/sqrt(VYp*VYp+VZp*VZp))

  print,"(Near) pole:",V_RA,V_Dec

  pos_A= { Name: "Pole of ecliptic A", RA: V_RA, Dec: V_Dec-5d/3600. }
  pos_B= { Name: "Pole of ecliptic B", RA: V_RA, Dec: V_Dec+5d/3600. }

  write_obscat_row, obscat, pos_A
  write_obscat_row, obscat, pos_B

  starspectrum_one, 'STARSPECTRUM_PoleA.fits', pos_A, MJD= MJulday(2008,3,20, 0,40,0)
  starspectrum_one, 'STARSPECTRUM_PoleB.fits', pos_B, MJD= MJulday(2008,3,20, 0,50,0)

  a->set_pos, A=pos_A, B=pos_B
  a->set_startMJD, MJulday(2008,3,21,1,0,0)
  a->simulate

  obscat->close
  obj_destroy,obscat
  obj_destroy,a
end

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; observe prima/secunda while they're goint through the meridian
;;
pro meridian

  MJD0 = MJulday(2008,9,23, 4,32-16,1.68)
  ;; approx. equinox, fine-tuned to catch stars at meridian
  ;; (10 minutes for starbg and skyflat)

  print,"lst = ",lst_from_date(MJD0)

  environment, MJD=floor(MJD0)-0.5

  a = obj_new("astrometry")
  a->set_rates, FSUA=10., FSUB=10.
  a->set_baseline, [0.,100.,0.]	;; 100m N-S
  a->set_n_phonoise,0
  a->set_primet_noise, 0d-6
  a->set_primet0, [ 0., 0.]
  a->set_startMJD, MJD0
  a->simulate
  obj_destroy,a

end

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; observe prima/secunda while they're goint through the meridian
;;
pro bigmeridian

  MJD0 = MJulday(2008,9,23, 3,32-16,1.68)
  ;; approx. equinox, fine-tuned to catch stars at meridian
  ;; (10 minutes for starbg and skyflat)

  print,"lst = ",lst_from_date(MJD0)

  environment, MJD=floor(MJD0)-0.5

  fc= Default_FSU_Config()
  ;;fc.star_angdiam /= 10.

  a = obj_new("astrometry", FSU_CONFIG=fc)
  a->set_rates, FSUA=4., FSUB=4., MAIN_DELAY=100., PRIMET=100.
  a->set_exptime, 1800.
  a->set_baseline, [0.,100.,0.]	;; 100m N-S
  a->set_n_phonoise,0
  a->set_primet_noise, 0d-6
  a->set_primet0, [ 0., 0.]
  a->set_startMJD, MJD0
  a->simulate
  obj_destroy,a

end

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

pro scired2_baseline_test

  MJD0 = MJulday(2008,10,31, 0,0,0)

  environment, MJD=floor(MJD0)-0.5

  a = obj_new("astrometry", FSU_CONFIG=fc)
  a->set_rates, FSUA=4., FSUB=4.
  a->set_baseline, [0.,100.,0.]	;; 100m N-S
  a->set_n_phonoise,0
  a->set_primet_noise, 0d-6
  a->set_primet0, [ 0., 0.]

  ;; we would need a new environment after 12h
  for hr=0,11 do begin
      a->set_startMJD, MJulday(2008,10,31, hr,0,0)
      a->simulate
  endfor
  obj_destroy,a
end
