;
; skarflat.pro
; Created:     Wed Apr 18 15:01:13 2007 by Rkoehler@lx40
; Last change: Tue Sep 28 19:26:54 2010
;
; PURPOSE:
;	this is the template for the flat side of PRIMA
;
; TODO:
; - different fluxes for A and B
; - blackbody spectrum
; - include skybackground-flux in imaging-data-table
;
; Copyright 2008 Rainer Koehler
;
; This file is part of Pacmart.
;
; Pacmart is free software; you can redistribute it and/or modify
; it under the terms of the GNU General Public License as published by
; the Free Software Foundation; either version 2 of the License, or
; (at your option) any later version.
;
; Pacmart is distributed in the hope that it will be useful,
; but WITHOUT ANY WARRANTY; without even the implied warranty of
; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
; GNU General Public License for more details.
;
; You should have received a copy of the GNU General Public License
; along with Pacmart; if not, write to the Free Software
; Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

PRO skarflat_sim_header, head, bias, flux, noise

  for i=0,N_elements(bias)-1 do $
     head->addESOpar, 'SIM BIAS'+string(i+1,format="(I1)"), bias[i],$
                      Comment=' bias of wavenumber channel '+strtrim(i+1,2)

  if N_elements(flux) gt 1 then  begin
     sz= size(flux)
     for ch=0,sz[1]-1 do begin
        for i=0,sz[2]-1 do begin
           pixnm = string(byte('A')+byte(i)) + string(ch+1,format="(I1)")
           head->addESOpar, 'SIM FLUX'+pixnm, flux[ch,i], Comment=' flux in pixel '+pixnm
        endfor
     endfor
  endif else $
     head->addESOpar, 'SIM FLUX',flux, Comment=' flux in all channels'

  if N_elements(noise) gt 1 then begin
     sz= size(noise)
     for ch=0,sz[1]-1 do begin
        for i=0,sz[2]-1 do begin
           pixnm = string(byte('A')+byte(i)) + string(ch+1,format="(I1)")
           head->addESOpar, 'SIM NOISE'+pixnm, noise[ch,i],$
                         Comment=' noise in pixel '+pixnm
        endfor
     endfor
  endif else $
     head->addESOpar, 'SIM NOISE',noise, Comment=' noise in all wavenumber channels'
end


PRO skarflat_img_data_header, head

  head->addESOPar, 'ISS DID', 'JICD-1.0', Comment=' Data Dictionary name'
  head->addESOPar, 'ISS ID' , '1.0',	  Comment=' Data Dictionary version number'
  head->addESOPar, 'ISS DIP', '089-3200-6467', Comment=' Data Dictionary phone number'

  head->addPar, 'NREGION', 4,	  Comment=' Number of regions used (always 4)'
  head->addPar, 'MAXTEL', 0,	  Comment=' Maximum number of contributing telescopes'
end

PRO skarflat_write_imaging_data, table, nexp, dit, bias, flat, noise, stepphase

  tabdat = replicate( { imaging_data_FSU_row }, nexp )
  tabdat.time = lindgen(nexp) * long(dit*1000000L + 100000L) ;; microsec, 100ms for readout
  for i=0,nexp-1 do begin
      tabdat[i].data1= round(bias + flat[*,0] * dit + noise * randomn(seed,6))
      tabdat[i].data2= round(bias + flat[*,1] * dit + noise * randomn(seed,6))
      tabdat[i].data3= round(bias + flat[*,2] * dit + noise * randomn(seed,6))
      tabdat[i].data4= round(bias + flat[*,3] * dit + noise * randomn(seed,6))
  endfor
  tabdat.stepping_phase = stepphase
  table->writeRows, tabdat
end


PRO skarflat_file, MJD0, TPLstart, nexp, dita, ditb, bias, flat, noise, stepphase

  ;;;; Nick assumes starflat uses the shorter dit
  ;; Of course, this is rubbish
  ;;if dita gt 0 and ditb gt 0 then begin
  ;;   dita = float(dita<ditb)	;; will it float?
  ;;   ditb = float(dita<ditb)
  ;;endif
  filename = 'PACMA.' + MJD_to_ESO_string(MJD0) + ".fits"
  print, "File: ",filename

  pfile= Pacman_binfile(MJD0)
  ;;
  ;; PRIMARY header
  ;;
  prihead= pfile.arrdesc->prihead()
  prihead->addPar,'EXPTIME',nexp*(dita>ditb),Comment= " (seconds)"

  standard_primary_header, prihead, dita,ditb, SIM_CODE='SF'
  prihead->addESOPar,'TPL START', MJD_to_ESO_string(TPLstart), Comment=" TPL start time"
  ;;
  ;; Tables in DICD-Order
  ;;
  Pacman_binfile_create_arrdesc, pfile, filename             ;; Array description: empty
  Pacman_binfile_create_arrgeom, pfile                       ;; Array geometry: empty
  Pacman_binfile_create_optrain, pfile                       ;; Optical train: empty
  Pacman_binfile_create_MDL, pfile                           ;; Main Delay: non existant
  ;;
  ;; Img_detector_FSUA: not empty
  ;;
  head= pfile.det_A->head()
  standard_img_detector_header, head, 'Romeo', 8.9d
  if dita gt 0. then skarflat_sim_header, head, bias, flat, noise

  Pacman_binfile_create_DetA, pfile
  if dita gt 0. then standard_img_detector_table, pfile.det_A
  ;;
  ;; imaging data FSUA: not empty
  ;;
  skarflat_img_data_header, pfile.dataA->head()

  Pacman_binfile_create_DataA, pfile
  if dita gt 0. then $
     skarflat_write_imaging_data, pfile.dataA, nexp, dita, bias, flat, noise, stepphase
  ;;
  ;; Imaging detector FSUB: not empty
  ;;
  head= pfile.det_B->head()
  standard_img_detector_header, head, 'Juliet', 8.9d
  if ditb gt 0. then skarflat_sim_header, head, bias, flat, noise

  Pacman_binfile_create_DetB, pfile
  if ditb gt 0. then standard_img_detector_table, pfile.det_B
  ;;
  ;; imaging data FSUB: not empty
  ;;
  skarflat_img_data_header, pfile.dataB->head()

  Pacman_binfile_create_DataB, pfile
  if ditb gt 0. then $
     skarflat_write_imaging_data, pfile.dataB, nexp, ditb, bias, flat, noise, stepphase
  ;;
  ;; more empty Tables
  ;;
  Pacman_binfile_create_metro, pfile	;; PRIMET: empty
  Pacman_binfile_create_metroB,pfile    ;; PRIMETB: empty
  Pacman_binfile_create_DDL,   pfile    ;; DDL: empty
  Pacman_binfile_create_OPDC,  pfile
  Pacman_binfile_create_DOPDC, pfile
  ;;
  ;; close the door and cleanup before you leave
  ;;
  Pacman_binfile_close,  pfile
  Pacman_binfile_cleanup, pfile
end

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;;old: PRO skarflat, MJD=MJD, NEXP=nexp, DITs=dits, FSUA=fsua, FSUB=fsub, BIAS=bias, FLAT=flat, NOISE=noise

PRO skarflat, MJD=MJD, NEXP=nexp, DITA=dita, DITB=ditb, TEMPER=temper,$
              BIAS=bias, SKYBG=skybg, FLAT=flat, NOISE=noise

  Common PACSIM_DEFAULTS

  print,"===== s-flat template ====="

  if not keyword_set(MJD)   then MJD = MJulDay(2008,4,1, 4,0,0)
  if not keyword_set(nexp)  then nexp= 60
  if N_elements(ditA) lt 1  then ditA= 1.0
  if N_elements(ditB) lt 1  then ditB= 1.0
  if not keyword_set(temper) then temper= 4200.

  if N_elements(bias)  lt 1 then bias = ld_bias
  if N_elements(skybg) lt 1 then skybg= sb_flux
  if N_elements(flat)  lt 1 then begin
     bb = blackbody( kappa_center, kappa_width, temper) * 10.
     flux = lf_flux * 2000.	;; give it some counts to work with (see labflat.pro)
     help,flux
     for i=0,3 do flux[*,i] *= bb
  endif else $
     flux = flat	;; copy variable, so we don't overwrite what our caller gave us

  for i=0,3 do flux[*,i] += skybg

  if N_Elements(noise) lt 1 then noise= sqrt(flux*float(dita<ditb))

  TPLstart= MJD

  ;; if dita is an array, then also ditb must be one with the same size!
  for i=0,N_elements(dita)-1 do begin
     if dita[i] gt 0. then begin
        skybackground, MJD=MJD, DITA=dita[i], DITB=dita[i], BIAS=bias, NOISE=noise
        MJD += 2.5/60./24.
     endif
     if ditb[i] gt 0. then begin
        skybackground, MJD=MJD, DITA=ditb[i], DITB=ditb[i], BIAS=bias, NOISE=noise
        MJD += 2.5/60./24.
     endif
     print,"Skarflat DitA",dita[i],", DitB",ditb[i]
     skarflat_file, MJD, TPLstart, nexp, dita[i], ditb[i], bias, flux, noise, 1
     MJD += 1./24./60.
     skarflat_file, MJD, TPLstart, nexp, dita[i], ditb[i], bias, flux, noise, 2
     MJD += 1./24./60.
  end
  print,"===== s-flat finished ====="
end

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
