;
; skybackground.pro
; Created:     Wed Apr 18 15:01:13 2007 by Rkoehler@lx40
; Last change: Thu Jun 25 16:42:57 2009
;
; PURPOSE:
;	this is the template for the sky background
;
; Copyright 2008 Rainer Koehler
;
; This file is part of Pacmart.
;
; Pacmart is free software; you can redistribute it and/or modify
; it under the terms of the GNU General Public License as published by
; the Free Software Foundation; either version 2 of the License, or
; (at your option) any later version.
;
; Pacmart is distributed in the hope that it will be useful,
; but WITHOUT ANY WARRANTY; without even the implied warranty of
; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
; GNU General Public License for more details.
;
; You should have received a copy of the GNU General Public License
; along with Pacmart; if not, write to the Free Software
; Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

PRO skybg_sim_header, head, bias, flux, noise

  for i=0,N_elements(bias)-1 do $
     head->addESOpar, 'SIM BIAS'+string(i+1,format="(I1)"), bias[i],$
                      Comment=' bias of wavenumber channel '+strtrim(i+1,2)

  for i=0,N_elements(flux)-1 do $
     head->addESOpar, 'SIM FLUX'+string(i+1,format="(I1)"), flux[i],$
                      Comment=' sky + dark current in wavenumber ch.'+strtrim(i+1,2)

  if N_elements(noise) gt 1 then begin
     for i=0,N_elements(noise)-1 do $
        head->addESOpar, 'SIM NOISE'+string(i+1,format="(I1)"),noise[i],$
                         Comment=' noise in wavenumber channel '+strtrim(i+1,2)
  endif else $
     head->addESOpar, 'SIM NOISE',noise, Comment=' noise in all wavenumber channels'
end


PRO skybg_img_data_header, head

  head->addESOPar, 'ISS DID', 'JICD-1.0', Comment=' Data Dictionary name'
  head->addESOPar, 'ISS ID' , '1.0',	  Comment=' Data Dictionary version number'
  head->addESOPar, 'ISS DIP', '089-3200-6467', Comment=' Data Dictionary phone number'

  head->addPar, 'NREGION', 4,	  Comment=' Number of regions used (always 4)'
  head->addPar, 'MAXTEL', 0,	  Comment=' Maximum number of contributing telescopes'
end

PRO skybg_write_imaging_data, table, exptime, dit, bias, flux, noise

  nexp = long(exptime/dit)
  tabdat = replicate( { imaging_data_FSU_row }, nexp )
  tabdat.time = lindgen(nexp) * round(dit*1000000L + 100000L) ;; microsec, 100ms for readout
  for i=0L,nexp-1 do begin
      tabdat[i].data1= round(bias + (flux + noise * randomn(seed,6)) * dit)
      tabdat[i].data2= round(bias + (flux + noise * randomn(seed,6)) * dit)
      tabdat[i].data3= round(bias + (flux + noise * randomn(seed,6)) * dit)
      tabdat[i].data4= round(bias + (flux + noise * randomn(seed,6)) * dit)
  endfor
  table->writeRows, tabdat
end


PRO skybg_file, MJD0, exptime, dita, ditb, bias, flux, noise

  dita= float(dita)
  ditb= float(ditb)

  filename = 'PACMA.' + MJD_to_ESO_string(MJD0) + ".fits"
  print, "File: ",filename

  pfile= Pacman_binfile(MJD0)
  ;;
  ;; PRIMARY header
  ;;
  prihead= pfile.arrdesc->prihead()
  prihead->addPar,'EXPTIME',exptime,Comment= " (seconds)"

  standard_primary_header, prihead, dita,ditb, SIM_CODE='SD'
  ;;
  ;; Tables in DICD-Order
  ;;
  Pacman_binfile_create_arrdesc, pfile, filename             ;; Array description: empty
  Pacman_binfile_create_arrgeom, pfile                       ;; Array geometry: empty
  Pacman_binfile_create_optrain, pfile                       ;; Optical train: empty
  Pacman_binfile_create_MDL, pfile                           ;; Main Delay: non existant
  ;;
  ;; Img_detector_FSUA: not empty
  ;;
  head= pfile.det_A->head()
  standard_img_detector_header, head, 'Romeo', 8.9d
  if dita gt 0 then skybg_sim_header, head, bias, flux, noise

  Pacman_binfile_create_DetA, pfile
  if dita gt 0 then standard_img_detector_table, pfile.det_A
  ;;
  ;; imaging data FSUA: not empty
  ;;
  skybg_img_data_header, pfile.dataA->head()

  Pacman_binfile_create_DataA, pfile
  if dita gt 0 then skybg_write_imaging_data, pfile.dataA, exptime, dita, bias, flux, noise
  ;;
  ;; Imaging detector FSUB: not empty
  ;;
  head= pfile.det_B->head()
  standard_img_detector_header, head, 'Juliet', 8.9d
  if ditb gt 0 then skybg_sim_header, head, bias, flux, noise

  Pacman_binfile_create_DetB, pfile
  if ditb gt 0 then standard_img_detector_table, pfile.det_B
  ;;
  ;; imaging data FSUB: not empty
  ;;
  skybg_img_data_header, pfile.dataB->head()

  Pacman_binfile_create_DataB, pfile
  if ditb gt 0 then skybg_write_imaging_data, pfile.dataB, exptime, ditb, bias, flux, noise
  ;;
  ;; more empty Tables
  ;;
  Pacman_binfile_create_metro, pfile	;; PRIMET: empty
  Pacman_binfile_create_metroB,pfile    ;; PRIMETB: empty
  Pacman_binfile_create_DDL,   pfile    ;; DDL: empty
  Pacman_binfile_create_OPDC,  pfile
  Pacman_binfile_create_DOPDC, pfile
  ;;
  ;; close the door and cleanup before you leave
  ;;
  Pacman_binfile_close,  pfile
  Pacman_binfile_cleanup, pfile
end

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

PRO skybackground, MJD=MJD, DITA=dita, DITB=ditb, BIAS=bias, FLUX=flux, NOISE=noise

  Common PACSIM_DEFAULTS

  print,"===== skyback template ====="

  if not keyword_set(MJD)   then MJD  = MJulDay(2008, 4, 1, 1,0,0)
  if N_elements(DITA) le 0  then dita = 1.
  if N_elements(DITB) le 0  then ditb = 1.
  if N_elements(bias)  lt 1 then bias = ld_bias
  if N_elements(flux)  lt 1 then flux = sb_flux
  if N_elements(noise) lt 1 then noise= sqrt(flux)


  print,"SKYBACKGROUND NOISE:",noise

  ;;openw,unit,"SkyBackground.sof",/get_lun
  print,"DitA",dita,", DitB",ditb
  skybg_file, MJD, 120., dita, ditb, bias, flux, noise
  ;;printf,unit,'PACMA.' + MJD_to_ESO_string(MJD) + ".fits  SKY_BACK_RAW"
  ;;close,unit
  ;;free_lun,unit
  print,"===== skyback finished ====="
end

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
