;
; utilities.pro
; Created:     Thu May 29 14:43:38 2008 by Koehler@Six
; Last change: Fri May 13 16:28:59 2011
;
; Copyright 2008 Rainer Koehler
;
; This file is part of Pacmart.
;
; Pacmart is free software; you can redistribute it and/or modify
; it under the terms of the GNU General Public License as published by
; the Free Software Foundation; either version 2 of the License, or
; (at your option) any later version.
;
; Pacmart is distributed in the hope that it will be useful,
; but WITHOUT ANY WARRANTY; without even the implied warranty of
; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
; GNU General Public License for more details.
;
; You should have received a copy of the GNU General Public License
; along with Pacmart; if not, write to the Free Software
; Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
;
;;;;;
;
; search_keys is an array of structs { key: "string", pattern: "string" }
;
Function fbt_search, dir_spec, PATTERN=pattern, USE_TPL_START=use_tpl_start,$
                     FIRST=first, LAST=last,  SEARCH_KEYS=search_keys,$
                     RETURN_KEYS=return_keys, RETURN_VALUES=return_values, VERBOSE=verbose

  if keyword_set(pattern) then begin
      if N_params() lt 1 then dir_spec= "."
      files_in= file_search(dir_spec,pattern,COUNT=nFiles,/Test_Read,/Test_Regular)
  endif else begin
      if N_params() lt 1 then dir_spec= "MIDI.*.fits"
      files_in= file_search(dir_spec,COUNT=nFiles,/Test_Read,/Test_Regular)
  endelse
  print,nFiles," files total"
  if nFiles le 0 then return,""

  files_out= strarr(nFiles)
  if keyword_set(return_keys) then begin
     return_tags = return_keys
     for i=0,N_elements(return_tags)-1 do begin
        tag= return_tags[i]
        repeat begin
           idx = stregex(tag, '[^0-9A-Za-z_]')
           if idx gt -1 then strput, tag, '_', idx
        endrep until (idx lt 0)
        return_tags[i]= tag
        if i eq 0 then cutie= create_struct(tag,'') $
        else cutie= create_struct(cutie,tag,'')
     endfor
     ;;help,cutie,/str
     return_values= replicate(cutie,nFiles)
  endif

  iIn = 0
  iOut= -1
  ntpl= 0
  TplStart= ''
  newTplStart= ''
  FileNo  = 9999
  key = ''

  while (iIn lt nFiles) do begin
      fname = files_in[iIn]
      if keyword_set(verbose) then print,iIn," = ",fname
      iIn++	;; in case we want to use 'continue'

      if keyword_set(first) or keyword_set(last) then begin
          bname = file_basename(fname)
          if keyword_set(first) then  if bname lt first then continue
          if keyword_set(last) then   if bname gt last then continue
      endif

      newFits = OBJ_NEW('fitsfile',fname)
      if not obj_valid(newFits) then begin
          if keyword_set(verbose) then print,"Cannot read file"
          continue
      endif
      newHead = newFits->head()
      if not obj_valid(newHead) then begin
          if keyword_set(verbose) then print,"Cannot read file header"
          obj_destroy,newFits
          continue
      endif
      if keyword_set(use_tpl_start) then newTplStart= string(newHead->getPar('TPL START',ntpl))

      if keyword_set(search_keys) then begin
          for i=0,N_elements(search_keys)-1 do begin
              value = strcompress(newHead->getpar(search_keys[i].key),/remove_all)
              if not strmatch(value,search_keys[i].pattern,/Fold_Case) then begin
                  obj_destroy,newFits
                  obj_destroy,newHead
                  break
              endif
          endfor
      endif
      if not obj_valid(newHead) then continue	;; obj destroyed, continue with next file
      ;;
      ;; we want this file, add filename to list
      ;;
      if (keyword_set(use_tpl_start) and (ntpl gt 0) and (TplStart eq newTplStart)) then begin
          ;; this is a continuation file
          files_out[iOut] = files_out[iOut] + ' ' + fname
      endif else begin
          ;; this is a new file, make a new entry in output list
          iOut++
          files_out[iOut] = fname
          ;; store header information
          if keyword_set(return_keys) then begin
              for iKey=0,N_elements(return_keys)-1 do begin
                  v= newHead->getpar(return_keys[iKey],cnt)
                  return_values[iOut].(iKey)= (cnt gt 0)? strtrim(v,2) : ''
              endfor
          endif
      endelse
      if keyword_set(use_tpl_start) then TplStart= newTplStart
      obj_destroy,newFits
      obj_destroy,newHead
  endwhile
  if iOut lt 0 then begin
      print,"no datasets matching criteria"
      return,""
  endif
  print,iOut+1L," datasets match criteria"
  if keyword_set(return_keys) then return_values= return_values[0:iOut,*]
  return, files_out[0:iOut]
end

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;
; pacmafs.pro
; Created:     Thu Dec  7 17:35:02 2006 by Koehler@rommie
; Last change: Mon Sep 17 16:50:38 2007
;
; PURPOSE:
;	find files for PACMA
;
; CALLING SEQUENCE:
;	files = pacmafs([dir])
;
; INPUT:
;	dir = directory where to start the recursive search for MIDI-files
;	      deafult is current dir
;
; OUTPUT:
;	array of names of selected MIDI-files
;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;Pro pacmafs_cleanup, wid
;  print,"========== Pacmafs cleanup",wid
;  widget_control, wid, get_uvalue=data
;  ptr_free,data.uni_keys
;end


Function pacmafs_selection_flags, widget, uni_strings, all_strings

  Widget_control, widget, Get_value=sid

  sel_flag = intarr(N_elements(all_strings))

  for i=0,N_elements(sid)-1 do begin
      if sid[i] gt 0 then begin
         str= (*uni_strings)[i]
         if str eq '(empty)' then str= ''
         w = where(all_strings eq str)
         if w[0] gt -1 then sel_flag[w] = 1
      endif
  endfor

  ;print,"uniq_strings ",(*uni_strings)
  ;print,"all_strings  ", all_strings
  ;print,total(sel_flag)," set to one"

  return, sel_flag
end


Pro pacmafs_event, ev
  Common Pacmafs, selected_files

  ev_name = tag_names(ev,/Structure_name)

  ;;help,ev,/str
  widget_control, ev.top, get_uvalue=data
  ;;help,data,/str

  cnt= 0
  for i=0,N_elements(data.key_pdmn_IDs)-1 do begin
     if ev.ID eq data.key_pdmn_IDs[i] then begin
        ;help,ev,/str
        cnt++
        nIt = N_elements(*data.uni_keys[i])
        flags= intarr(nIt)	;; all 0
        ;; ev.Value=1: all on, 2: all off, 3...N: only n-3
        if ev.Value eq 1 then flags= replicate(1,nIt) $
        else if ev.Value gt 2 then flags[ev.Value-3]= 1
        ;print,"Flags:",flags
        help,data.key_menu_IDs
        print,i
        widget_control, data.key_menu_IDs[i], set_value=flags
     endif
  endfor
  if cnt eq 0 then idx= where(ev.id eq data.key_menu_IDs,cnt)

  if cnt gt 0 then begin
     select_flag= replicate(1,N_elements(data.keywords))
     for t=0,N_elements(data.key_menu_IDs)-1 do $
        select_flag *= pacmafs_selection_flags(data.key_menu_IDs[t], data.uni_keys[t], data.keywords.(t+1))
     ;; first keyword is MJD-OBS, but there is no menu for it

     sel_idx = where(select_flag,sel_cnt)	;;print, data.files[sel_idx]

     widget_control, data.fnum_label, Set_Value=$
                     Strtrim(N_Elements(data.files),2)+" files, "+strtrim(sel_cnt,2)+" match criteria"

     if sel_cnt le 0 then begin
        table_stuff = [ "No matching file" ]
     endif else begin
        table_stuff = strarr(data.Ncols+1,sel_cnt)
        table_stuff[0,*]= data.display_files[sel_idx]
        for i=0,data.Ncols-1 do $
           table_stuff[i+1,*]= data.keywords[sel_idx].(i)
        selected_files = data.files[sel_idx]
     endelse
     widget_control, data.file_table, Set_Value= table_stuff, Table_Ysize=sel_cnt

  endif $
  else if ev.id eq data.base_widg  and  ev_name eq "WIDGET_BASE" then begin
     tbl_geom = Widget_info(data.file_table,/Geometry)
     col_wids = Widget_info(data.file_table,/column_widths)
     table_w = ev.x - 7
     ;; this is too complicated:
     ;;key_geom = Widget_info(data.key_menu_IDs[0], /GEometry)
     ;;but_geom = Widget_info(data.okay_but, /GEometry)
     ;;table_h = ev.y -(key_geom.scr_ysize + 2*key_geom.margin) -(but_geom.scr_ysize + 2*but_geom.margin) - 24
     ;; maybe we should ask the base for its size after we created everything,
     ;; to figure out what the diff between table- and base-height is
     table_h = ev.y - 260
     col_wids[0] += table_w - tbl_geom.scr_xsize
     scrsz= get_screen_size()
     widget_control, data.file_table, scr_xsize=table_w, scr_ysize=(table_h < (scrsz[1]-280)), Column_widths=col_wids
  endif $
  else if ev.id eq data.file_table  and  ev_name eq 'WIDGET_CONTEXT' then begin
     print,"Right click on ",ev.row,", file ",data.files[ev.row]

     ffile = obj_new('FITSFILE',data.files[ev.row],iErr=ierr)
     if ierr eq 0 then begin
        fbtheaderview, "Primary Header of "+data.files[ev.row], ffile->prihead()
        obj_destroy,ffile
     endif
  endif

  if ev.id eq data.okay_but then begin
     select= widget_info(data.file_table, /Table_Select)
     select= select[1,*]
     ;;print,"selected rows =",transpose(select)
     select= select[uniq(select)]
     ;;print,"selected file-idx: ",select
     selected_files = selected_files[select]
     print,"Selected files:"
     for i=0,N_elements(selected_files)-1 do print, i,": ",selected_files[i]
     Widget_Control, ev.top, /destroy ;; activate self-destruct
     return
  endif $
  else if ev.id eq data.cancel_but then begin
     selected_files = ''
     Widget_Control, ev.top, /destroy ;; activate self-destruct
     return
  endif $
  else if ev.id eq data.chdir_but then begin
     selected_files = '--chdir--'	;; secret message to main routine
     Widget_Control, ev.top, /destroy ;; activate self-destruct
     return
  endif
end


Function pacmafs, dir, FONT=font, EXTRA_KEYS=extra_keys
  Common Pacmafs, selected_files

  if N_params() lt 1 then cd, current=dir	;; get current dir

  ;;if not keyword_set(font) then font= "-Misc-Fixed-Medium-R-SemiCondensed--13-*"

  Return_Keys= ["MJD-OBS", "TPL NAME", "INS MODE", "DPR TYPE", "PRO CATG",$
                "PRI FSU1 DIT", "PRI FSU2 DIT", "OBJECT", "OBS TARG NAME" ]
  menu_label = ["MJD-OBS", "Template","INS MODE", "DPR TYPE", "PRO CATG","DIT 1","DIT 2","Object","Target"]

  if N_elements(extra_keys) gt 0 then begin
     Return_Keys= [ Return_Keys, extra_keys ]
     menu_label = [ menu_label,  extra_keys ]
  endif
  Ncols = N_elements(menu_label)

  print, Return_Keys
  print, menu_label

  repeat begin
     selected_files= fbt_search(dir, PATTERN="*.fits", verbose=0, $
                                Return_Keys= Return_Keys, Return_Values= keywords )

     if selected_files[0] eq '' then begin
        print,"No FITS-file found!"
        return,''
     endif

     sortidx = sort(keywords.MJD_OBS)

     selected_files = selected_files[sortidx]
     keywords = keywords[sortidx]

     keywords.PRI_FSU1_DIT = strtrim(keywords.PRI_FSU1_DIT * 1d3,2)
     keywords.PRI_FSU2_DIT = strtrim(keywords.PRI_FSU2_DIT * 1d3,2)

     ;;help,keywords,/str

     base = widget_base(Title="PACMA File Selector, "+dir,/Column,/TLB_SIZE_EVENTS)
     selbase= widget_base(base, /Row, Frame=4)


     uni_keys= ptrarr(Ncols-1)	;; skip MJD-OBS
     key_pdmn_IDs= ulonarr(Ncols)
     key_menu_IDs= ulonarr(Ncols)

     for i=1,Ncols-1 do begin
        keys = keywords[uniq(keywords.(i), sort(keywords.(i)))].(i)
        idx= where( keys eq '')
        if idx[0] gt -1 then keys[idx]= '(empty)'
        uni_keys[i-1]= ptr_new(keys)

        ones= Replicate(1,N_elements(keys))
        mlen= max(strlen(keys),midx)	;; max len in chars

        bbase= widget_base(selbase,/column)
        plen = widget_info(bbase,STRING_SIZE=keys[midx])
        plen = plen[0]	;; use only xsize

        mitems= [ '1\'+menu_label[i], '0\All on', '0\All off']
        for k=0,N_elements(keys)-1 do mitems= [ mitems, '0\only '+keys[k] ]
        ;;print,'mitmes:',mitems
        key_pdmn_IDs[i] = cw_pdmenu(bbase,mitems,/return_index,FONT=font)

        if N_elements(ones) le 5 then begin
           key_menu_IDs[i]= cw_bgroup(bbase,keys,FONT=font,$ ;Label_Top=menu_label[i],$
                                      Set_value= ones,/Column,/Nonexclusive,/frame, XSIZE=100)
        endif else begin
           key_menu_IDs[i]= cw_bgroup(bbase,keys,FONT=font,$ ;Label_Top=menu_label[i],$
                                      Set_value= ones,/Column,/Nonexclusive,/frame, XSize=plen+10,$
                                   /Scroll,X_scroll_size=plen+20 < 130,Y_Scroll_Size=120 )
        endelse
     endfor
     key_pdmn_IDs = key_pdmn_IDs[1:*]	;; no menu for MJD-OBS
     key_menu_IDs = key_menu_IDs[1:*]	;; no menu for MJD-OBS


     dinfo = file_info(dir)	;; this gets rid of leading "./"
     dirlen= strlen(dinfo.name)+1	;; 1 more for the '/'
     ;;print,"dir is ",dir," strlen is",dirlen
     ;;print,"F. file is ",selected_files[0]
     display_files= strmid( selected_files, dirlen)
     display_lens = transpose(strpos(display_files,".fits")+5)
     display_files= strmid(display_files,0,display_lens)

     table_stuff = strarr(Ncols+1, N_elements(selected_files))
     table_stuff[0,*]= display_files
     for i=0,Ncols-1 do table_stuff[i+1,*]= keywords.(i)

     colLabels= ['File Name', menu_label ]

     scrsize= get_screen_size()
     file_table= widget_table(base,UNAME="FILES",Alignment=0,SCR_XSIZE=scrsize[0]-78,SCR_YSIZE=scrsize[1]-380,$
                              Column_Labels= colLabels, Value= table_stuff, FONT=font, $
                              /Disjoint_select, /Resizeable_Columns, /Context_events )

     xsize= scrsize[0]-100
     bbase = widget_base(base, /Row, Frame=2)
     nfiles= Strtrim(N_Elements(selected_files),2)
     ;fnum_label = widget_text(bbase, Value= [ nfiles+" files", nfiles+" match criteria"],$
     ;                          YSize=2, FONT=font, FRAME=1)
     fnum_label = widget_label(bbase, Value= nfiles+" files, "+ nfiles+" match criteria",$
                               /ALIGN_LEFT, FONT=font,XSIZE=xsize*0.4)
     chdir_but  = widget_button(bbase,Value= "Change directory",FONT=font,XSIZE=xsize*0.2)
     fill_label = widget_label(bbase, Value= ' ',     FONT=font, XSIZE=xsize*0.1)
     okay_but   = widget_button(bbase,Value= "Okay",  FONT=font, XSIZE=xsize*0.15)
     cancel_but = widget_button(bbase,Value= "Cancel",FONT=font, XSIZE=xsize*0.15)

     ;action_buts= cw_bgroup(bbase,[" Okay ","Cancel"],/Row,/Return_Name,FONT=font,XSIZE=420,frame=1)


     Widget_Control, base, /REALIZE

     ;; find column widths
     ;; (this works only *after* the widget has been created...)
     colwids = intarr(Ncols+1)	;; one more for filename
     for i=0,Ncols do begin
        mlen= max(strlen(table_stuff[i,*]),midx)	;; max len in chars
        ;;print,"longest entry: ",table_stuff[i,midx],"|"

        hlen = widget_info(file_table,STRING_SIZE=colLabels[i])
        plen = widget_info(file_table,STRING_SIZE=table_stuff[i,midx])
        colwids[i] = hlen[0] > plen[0]	;; use only xsize, max of header and content
     endfor
     ;; [ 360,        60, 200, 60, 60, 60, 60, 60 ]

     Widget_control, file_table, Column_Widths= colwids+8
     Widget_Control, base, Set_Uvalue= $
                     { Ncols: Ncols, keywords: keywords, uni_keys: uni_keys, $
                       key_pdmn_IDs: key_pdmn_IDs, key_menu_IDs: key_menu_IDs,$
                       chdir_but: chdir_but, okay_but: okay_but, cancel_but: cancel_but,$
                       fnum_label: fnum_label, base_widg: base, file_table: file_table,$
                       files: selected_files, display_files: display_files }

     xmanager, "pacmafs", base	;now done locally:, Cleanup="pacmafs_cleanup"

     print,"========== Pacmafs cleanup"
     ptr_free, uni_keys

     if (selected_files[0] eq '--chdir--') then begin
        dir= Dialog_Pickfile(Title="Select Directory",/Directory)
        if dir eq '' then return,""
        print,"searching in ",dir
     endif
  endrep until (selected_files[0] ne '--chdir--')

  return, selected_files
end
