;
; test_FSUresponse.pro
; Created:     Wed Nov  7 15:40:58 2007 by Rkoehler@lx40
; Last change: Wed May  4 13:09:09 2011
;
; Copyright 2008 Rainer Koehler
;
; This file is part of Pacmart.
;
; Pacmart is free software; you can redistribute it and/or modify
; it under the terms of the GNU General Public License as published by
; the Free Software Foundation; either version 2 of the License, or
; (at your option) any later version.
;
; Pacmart is distributed in the hope that it will be useful,
; but WITHOUT ANY WARRANTY; without even the implied warranty of
; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
; GNU General Public License for more details.
;
; You should have received a copy of the GNU General Public License
; along with Pacmart; if not, write to the Free Software
; Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
;
;
PRO test_FSUresponse, basename, FILE=outfile

  if not keyword_set(outfile) then outfile="FSUresponse_testresults"

  ;;doesn't work - spawn,"make "+basename+'_FSURESP.fits'

  file = file_search(basename+'*FSURESP.fits')
  if file[0] eq '' then begin
      print,"No file found matching "+basename+'*FSURESP.fits'
      return
  end

  print,"Reading ",file[0]
  FSUr = fbt_open(file[0])

  prihead= FSUr.fileobj->prihead()
  keywords= prihead->sthead()

  openw,outunit,outfile+'.tex',/get_lun
  printf,outunit,'%% '+outfile+'.tex'
  printf,outunit,"%% FSUresponse testresults"
  printf,outunit,""
  printf,outunit,'{\bf Input data}:'
  printf,outunit,'\begin{verbatim}'
  printf,outunit,'Size   Creation date        Filename'
  close,outunit & free_lun,outunit

  spawn,'ls -l '+basename+".fits | sed -e 's/^.*users //'"
  spawn,'ls -l '+basename+".fits | sed -e 's/^.*users //' >> "+outfile+'.tex'

  openw,outunit,outfile+'.tex',/get_lun,/APPEND
  printf,outunit,'\end{verbatim}'
  printf,outunit,''
  printf,outunit,'{\bf Set of Frames}:\\'
  printf,outunit,'The set of frames contains the names of the input files and their DO\_CATEGORIES:'
  printf,outunit,'\verbatiminput{../spectra/'+basename+'.sof}'
  printf,outunit,''
  printf,outunit,''
  printf,outunit,'{\bf Simulation Parameters}:'
  printf,outunit,'\begin{longtable}{ll}'
  printf,outunit,'Parameter & \quad Value \\'
  printf,outunit,'\hline\endhead'
  printf,outunit,'\hline\endfoot'

  printf,outunit, 'Number of slews	& ',fix(prihead->getpar('HIERARCH ESO INS OPDSCAN NSLEW')),'\\'
  printf,outunit, 'MARCEL temperature	& ',float(prihead->getpar('HIERARCH ESO SIM MARCEL TEMP')),' K\\'
  printf,outunit, 'Metrology noise	& ',float(prihead->getpar('HIERARCH ESO SIM MET NOISE'  )),' m\\'
  printf,outunit, 'Photometric noise	& ',float(prihead->getpar('HIERARCH ESO SIM FSU NOISE'  )),' \%\\'
  printf,outunit, 'Timestamp noise	& ',float(prihead->getpar('HIERARCH ESO SIM TIME NOISE' )),' $\mu$s\\'
  printf,outunit, 'Delay Jitter		& ',float(prihead->getpar('HIERARCH ESO SIM DELAY JITTER')),' $\mu$m\\'

  printf,outunit,'\hline'
  printf,outunit,'\end{longtable}'
  printf,outunit,'%\bigskip'

  printf,outunit,'Delay jitter is a random shift of the mean delay of the slews.'
  printf,outunit,'The delay error of individual points within one slew is parameterized by the metrology noise.'

  print_cmd_stuff, outunit, 'fsuresponse', '../spectra/'+basename+'.out', CMDSEARCH=basename
  list_fbt_extensions,outunit,FSUr

  printf,outunit,'\smallskip'
  printf,outunit,''
  printf,outunit,'{\bf Output Data Contents}:\\'
  printf,outunit,'%'
  printf,outunit,'Primary Header: The following tables contain'
  printf,outunit,' the recipe parameters and the QC-keywords in the primary header.'
  printf,outunit,''
  printf,outunit,'\centerline{\hsize=0.5\hsize\vbox{%'
  printf,outunit,'\begin{longtable}{lccc}'
  printf,outunit,'Parameter & Value \\'
  printf,outunit,'\hline\endhead'
  printf,outunit,'\hline\endfoot'

  for k=1,9 do begin
     key = 'HIERARCH ESO PRO REC1 PARAM'+strtrim(k,2)
     name= prihead->getpar(key+' NAME')
     if size(name,/TNAME) eq 'STRING' then begin
        val = prihead->getpar(key+' VALUE')
        ;;print,"HEADER ",key,': ',name,' = ',val
        printf,outunit, name,'	& ',val,'	\\'
     endif
  end

  printf,outunit,'\hline'
  printf,outunit,'\end{longtable}}'
  printf,outunit,'\hfill\vbox{%'

  printf,outunit,'\begin{longtable}{lccc}'
  printf,outunit,'Keyword & Value \\'
  printf,outunit,'\hline\endhead'
  printf,outunit,'\hline\endfoot'

  for k=0,N_elements(keywords)-1 do begin
      ;;print,k,keywords[k]
      key = stregex(keywords[k],'^HIERARCH ESO QC [A-Z0-9_ ]+[A-Z0-9_]',/Extract)
      if key ne '' then begin
          ;;print,"key ",key
          val = prihead->getpar(key)
          key = strmid(key,13)
          key = strjoin( strsplit(key,'_',/Extract),'\_')
          key = strjoin( strsplit(key,' ',/Extract),'.')

          if strmatch(key,'QC.EFFWAVE.*') then begin
              ch   = stregex(key,'[0-4]$',/Extract)
              waven= 1./ ((2.1 + ch/10.) * 1d-6)
              diff = val-waven
              color = (abs(diff/waven) lt 1d-5) ? 'green' : 'red'
              ;;print,"channel ",ch,waven,diff
              printf,outunit, key,'	& ',val,'	& ',waven,' & \color{',color,'}',diff,' \\'
          endif else begin
              printf,outunit, key,'	& ',val,'	\\'
          endelse
      endif
  end

  printf,outunit,'\hline'
  printf,outunit,'\end{longtable}}}'
  printf,outunit,'\bigskip'

  test_FSUresp, FSUr.response_fsua->readrows(), outunit, outfile, 'A'
  test_FSUresp, FSUr.response_fsub->readrows(), outunit, outfile, 'B'


  close,outunit & free_lun,outunit
  fbt_close,FSUr
end

pro test_FSUresp, FSUAtab, outunit, outfile, FSU

  print,"FSU ",FSU
  if size(FSUAtab,/TYPE) ne 8 then begin
      print,"Unstructured data, probably an empty table"
      return
  endif
  if FSU eq 'A' then begin
     printf,outunit,'The response tables have this structure:\\'
     printf,outunit,'\begin{center}'
     dump_table_structure, outunit, FSUAtab
     printf,outunit,'\end{center}'
  endif
  restore,'throughput_FSUA.sav'

  if !D.name eq 'X'  then device,decomposed=0

  !P.multi=[0,4,6]
  !Y.range=[-1.,1.]
  tek_color
  if !D.name eq 'PS' then device,file=outfile+'_real'+FSU+'.ps',/landscape,/color

  for ch=0,5 do begin
     ch1 = '['+strtrim(ch,2)+']'
     plot_response_real,"A"+ch1, kappas[ch,*], white[ch,*],$
                        fsuatab.wavenumber[ch,*],fsuatab.real_a[ch,*],fsuatab.imag_a[ch,*]

     plot_response_real,"B"+ch1, kappas[ch,*], white[ch,*],$
                        fsuatab.wavenumber[ch,*],fsuatab.real_b[ch,*],fsuatab.imag_b[ch,*]

     plot_response_real,"C"+ch1, kappas[ch,*], white[ch,*],$
                        fsuatab.wavenumber[ch,*],fsuatab.real_c[ch,*],fsuatab.imag_c[ch,*]

     plot_response_real,"D"+ch1, kappas[ch,*], white[ch,*],$
                        fsuatab.wavenumber[ch,*],fsuatab.real_d[ch,*],fsuatab.imag_d[ch,*]
  endfor
  junk=''
  if !D.name eq 'X' then read,Prompt='Hit return',junk
  if !D.name eq 'PS' then device,/close,file=outfile+'_imag'+FSU+'.ps',/landscape,/color

  for ch=0,5 do begin
     ch1 = '['+strtrim(ch,2)+']'
     plot_response_imag,"A"+ch1, kappas[ch,*], white[ch,*],$
                        fsuatab.wavenumber[ch,*],fsuatab.real_a[ch,*],fsuatab.imag_a[ch,*]

     plot_response_imag,"B"+ch1, kappas[ch,*], white[ch,*],$
                        fsuatab.wavenumber[ch,*],fsuatab.real_b[ch,*],fsuatab.imag_b[ch,*]

     plot_response_imag,"C"+ch1, kappas[ch,*], white[ch,*],$
                        fsuatab.wavenumber[ch,*],fsuatab.real_c[ch,*],fsuatab.imag_c[ch,*]

     plot_response_imag,"D"+ch1, kappas[ch,*], white[ch,*],$
                        fsuatab.wavenumber[ch,*],fsuatab.real_d[ch,*],fsuatab.imag_d[ch,*]
  endfor
  !Y.range=0
  ;;plot_response,"A Pixels",kappas,white,fsuatab.wavenumber,fsuatab.real_a,fsuatab.imag_a
  ;;plot_response,"B Pixels",kappas,white,fsuatab.wavenumber,fsuatab.real_b,fsuatab.imag_b
  ;;plot_response,"C Pixels",kappas,white,fsuatab.wavenumber,fsuatab.real_b,fsuatab.imag_b
  ;;plot_response,"D Pixels",kappas,white,fsuatab.wavenumber,fsuatab.real_d,fsuatab.imag_d

  printf,outunit,'\newpage'
  printf,outunit,'\vbox{\centerline{Response functions of FSU '+FSU+' (Real part)}\vspace{-6mm}'
  printf,outunit,'\centerline{\includegraphics[angle=180,width=0.9\textwidth]{../spectra/'+outfile+'_real'+FSU+'.pdf}}}'
  printf,outunit,'\vbox{\centerline{Response functions of FSU '+FSU+' (Imaginary part)}\vspace{-6mm}'
  printf,outunit,'\centerline{\includegraphics[angle=180,width=0.9\textwidth]{../spectra/'+outfile+'_imag'+FSU+'.pdf}}}'
  printf,outunit,'The expected values are plotted in red, the output of the recipe in green.'
  printf,outunit,'If the curves are identical, then the results are consistent with the inputs.'
  printf,outunit,''

  if !D.name eq 'PS' then begin
      device,/close
      spawn,'ps2pdf '+outfile+'_real'+FSU+'.ps'
      spawn,'ps2pdf '+outfile+'_imag'+FSU+'.ps'
      ;device,file=outfile+'_phase'+FSU+'.ps',/landscape,/color
  endif
  junk='' & if !D.name eq 'X' then read,Prompt='Hit return',junk

  !P.multi=0

  ;;kappa_cs = 1d6/[2.5,2.4,2.3,2.2,2.1]
  ;;
  ;;plot, [min(fsuatab.wavenumber),max(fsuatab.wavenumber)], [-30,+360],/xsty,/ysty,$
  ;;  title=title, xtitle='kappa [m!u-1!n]', ytitle='Phase Difference [rad]', /nodata
  ;;
  ;;nCh= N_elements(fsuatab[0].wavenumber)
  ;;
  ;;for ch=0,nCh-1 do begin
  ;;    c = ch+1
  ;;    if !D.name eq 'PS' and ch eq 0 then c=0
  ;;
  ;;    idx = where(fsuatab.wavenumber[ch] gt kappa_cs[ch]-15000. and $
  ;;                fsuatab.wavenumber[ch] lt kappa_cs[ch]+15000. )
  ;;    tab = fsuatab[idx]
  ;;
  ;;    phaseA = 180./!pi*atan(tab.imag_a[ch],tab.real_a[ch])
  ;;    phaseB = 180./!pi*atan(tab.imag_b[ch],tab.real_b[ch])
  ;;    phaseC =(180./!pi*atan(tab.imag_c[ch],tab.real_c[ch])+360.)
  ;;    phaseD =(180./!pi*atan(tab.imag_d[ch],tab.real_d[ch])+360.) mod 360.
  ;;
  ;;    oplot, tab.wavenumber[ch], phaseA-phaseA,color=c
  ;;    oplot, tab.wavenumber[ch], phaseB-phaseA,color=c
  ;;    oplot, tab.wavenumber[ch], phaseC-phaseA,color=c
  ;;    oplot, tab.wavenumber[ch], phaseD-phaseA,color=c
  ;;
  ;;    if ch eq 0 then begin
  ;;        XYouts, tab[0].wavenumber[ch], 0.                 -4., 'Pixel A', align=1.1
  ;;        XYouts, tab[0].wavenumber[ch], phaseB[0]-phaseA[0]-4., 'Pixel B', align=1.1
  ;;        XYouts, tab[0].wavenumber[ch], phaseC[0]-phaseA[0]-4., 'Pixel C', align=1.1
  ;;        XYouts, tab[0].wavenumber[ch], phaseD[0]-phaseA[0]-4., 'Pixel D', align=1.1
  ;;    endif
  ;;endfor
  ;;
  ;;printf,outunit,'\vbox{\centerline{Phase differences of FSU '+FSU+'}\vspace{-5mm}'
  ;;printf,outunit,'\includegraphics[angle=90,height=0.48\textheight]{../spectra/'+outfile+'_phase'+FSU+'.pdf}}'
  ;;
  ;;if !D.name eq 'PS' then begin
  ;;    device,/close
  ;;    spawn,'ps2pdf '+outfile+'_phase'+FSU+'.ps'
  ;;endif
end

pro plot_response, title, kappas,white,wavenum, re, im

  color= indgen(8)
  if !D.name eq 'PS' then begin
      color[1]= 0
      color[0]= 1
  end

  plot, kappas[0,*], white[0,*], xrange=[min(kappas),max(kappas)],/xsty, yrange=[0,1.1],/ysty,$
    title=title, xtitle='kappa [m!u-1!n]', ytitle='Response'
  for ch=1,4 do oplot, kappas[ch,*], white[ch,*], color=color[ch+1]

  nCh= (size(wavenum))[1]

  print,"max A real",max(re),", max imag",max(im)

  for ch=0,nCh-1 do begin
      ;junk='' & read,junk
      mag= sqrt(re[ch,*]*re[ch,*]+im[ch,*]*im[ch,*])
      oplot, wavenum[ch,*], mag, color=color[ch+1]
  end
end

pro plot_response_real, title, kappa, white, wavenum, re, im
  f= re/sqrt(re*re+im*im)

  plot, kappa, white*f, title="Real "+title
  oplot,kappa, white*f, color=2
  oplot,wavenum, re, color=3
end

pro plot_response_imag, title, kappa, white, wavenum, re, im
  f= im/sqrt(re*re+im*im)

  plot, kappa, white*f, title="Imaginary "+title
  oplot,kappa, white*f, color=2
  oplot,wavenum, im, color=3
end

;%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

pro test_all_FSUresps
  print,"Device is ",!D.name

  test_FSUresponse,'PACMA.2008-04-01T01:00:00.000',FILE='FSUresp_A_nonoi'
  test_FSUresponse,'PACMA.2008-04-01T01:10:00.000',FILE='FSUresp_B_nonoi'
  test_FSUresponse,'PACMA.2008-04-01T01:20:00.000',FILE='FSUresp_AB_nonoi'
  test_FSUresponse,'PACMA.2008-04-01T01:30:00.000',FILE='FSUresp_A_noise'
  test_FSUresponse,'PACMA.2008-04-01T01:40:00.000',FILE='FSUresp_B_noise'
  test_FSUresponse,'PACMA.2008-04-01T01:50:00.000',FILE='FSUresp_AB_noise'
end
