;
; test_VLTIresponse.pro
; Created:     Wed Nov  7 15:40:58 2007 by Rkoehler@lx40
; Last change: Tue Feb  9 16:31:05 2010
;
; Copyright 2008 Rainer Koehler
;
; This file is part of Pacmart.
;
; Pacmart is free software; you can redistribute it and/or modify
; it under the terms of the GNU General Public License as published by
; the Free Software Foundation; either version 2 of the License, or
; (at your option) any later version.
;
; Pacmart is distributed in the hope that it will be useful,
; but WITHOUT ANY WARRANTY; without even the implied warranty of
; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
; GNU General Public License for more details.
;
; You should have received a copy of the GNU General Public License
; along with Pacmart; if not, write to the Free Software
; Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
;
;
PRO test_VLTIresponse, basename, FILE=outfile, TEX=tex

  if not keyword_set(outfile) then outfile="VLTIresponse_testresults"
  if N_elements(basename) lt 1 then basename= 'PACMA*T02'

  file = file_search(basename+'*_VLTIRESP.fits')
  if file[0] eq '' then begin
      print,"No file found matching "+basename+'*VLTIRESP.fits'
      return
  end

  print,"Reading ",file[0]
  VLTIr = fbt_open(file[0])

  openw,outunit,outfile+'.tex',/get_lun
  printf,outunit,'%% '+outfile+'.tex'
  printf,outunit,"%% VLTIresponse testresults"
  printf,outunit,""
  printf,outunit,'{\bf Input data}:'
  printf,outunit,'\begin{verbatim}'
  printf,outunit,'Size   Creation date        Filename'
  close,outunit & free_lun,outunit

  spawn,'ls -l '+basename+"*[25]?:00.000.fits | sed -e 's/^.*users //'"
  spawn,'ls -l '+basename+"*[25]?:00.000.fits | sed -e 's/^.*users //' >> "+outfile+'.tex'

  openw,outunit,outfile+'.tex',/get_lun,/APPEND
  printf,outunit,'\end{verbatim}'
  printf,outunit,'In the simulated data, the VLTI transmission is flat (constant 1.0 for all frequencies).'
  printf,outunit,''

  sof = strmid(file[0],0, strlen(file[0])-14)
  sof = sof[0]
  printf,outunit,'{\bf Set of Frames}:'
  printf,outunit,'\verbatiminput{../spectra/'+sof+'.sof}'

  print_cmd_stuff, outunit, 'VLTIresponse', '../spectra/'+sof+'.out', CMDSEARCH=sof
  list_fbt_extensions,outunit,VLTIr

  printf,outunit,'\smallskip'
  printf,outunit,''
  printf,outunit,'{\bf Output Data Contents}:\\'
  printf,outunit,'%'
  printf,outunit,'Primary Header: The following table contains the QC-keywords in the primary header.'
  printf,outunit,'\begin{longtable}{lccc}'
  printf,outunit,'Keyword & Value \\'
  printf,outunit,'\hline\endhead'
  printf,outunit,'\hline\endfoot'

  prihead= VLTIr.fileobj->prihead()
  keywords= prihead->sthead()

  for k=0,N_elements(keywords)-1 do begin
      ;;print,k,keywords[k]
      key = stregex(keywords[k],'^HIERARCH ESO QC [A-Z0-9_ ]+[A-Z0-9_]',/Extract)
      if key ne '' then begin
          ;;print,"key ",key
          val = prihead->getpar(key)
          key = strmid(key,13)
          key = strjoin( strsplit(key,'_',/Extract),'\_')
          key = strjoin( strsplit(key,' ',/Extract),'.')

          if strmatch(key,'QC.EFFWAVE.*') then begin
              ch   = stregex(key,'[0-4]$',/Extract)
              waven= 1./ ((2.1 + ch/10.) * 1d-6)
              diff = val-waven
              color = (abs(diff/waven) lt 1d-5) ? 'green' : 'red'
              ;;print,"channel ",ch,waven,diff
              printf,outunit, key,'	& ',val,'	& ',waven,' & \color{',color,'}',diff,' \\'
          endif else begin
              printf,outunit, key,'	& ',val,'	\\'
          endelse
      endif
  end

  printf,outunit,'\hline'
  printf,outunit,'\end{longtable}'
  printf,outunit,'\bigskip'

  test_VLTI, VLTIr.response->readrows(), outunit, outfile

  close,outunit & free_lun,outunit
  fbt_close,VLTIr

  if keyword_set(tex) then spawn,"cd /home/rkoehler/PRIMA/Pacma_test_report; pdflatex Pacmap_test_report.tex"
end

pro test_VLTI, VLTItab, outunit, outfile

  if size(VLTItab,/TYPE) ne 8 then begin
      print,"Unstructured data, probably an empty table"
      return
  endif

  printf,outunit,'\vbox{The {\tt RESPONSE} table has this structure:'
  printf,outunit,'\smallskip'
  printf,outunit,'\begin{center}'
  dump_table_structure, outunit, VLTItab
  printf,outunit,'\end{center}'
  printf,outunit,'}'

  restore,'throughput_FSUA.sav'

  if !D.name eq 'PS' then device,file=outfile+'_gronk.ps',/landscape,/color

  tek_color
  plot_response,kappas,white,Vltitab

  printf,outunit,'\vbox{The figure shows the computed VLTI response functions.'
  printf,outunit,'  The solid line is the real part, the dashed line is the imaginary part.'
  printf,outunit,'  Only every tenth errorbar is plotted to reduce clutter.'
  printf,outunit,'  The dotted lines indicate the FSUA response functions for comparison.'
  printf,outunit,'  The edges of the VLTI response are a bit ragged because of the low S/N at these wavenumbers.%\vspace{-7mm}\par'
  printf,outunit,''
  printf,outunit,'\centerline{\hss\includegraphics[angle=180,width=1.2\textwidth]{../spectra/'+outfile+'_gronk.pdf}}}'
  printf,outunit,''
  printf,outunit,'The plots show that the responses are nicely normalized so that the highest point is one.'
  ;;printf,outunit,'The highest point is in general the largest outlier.'

  if !D.name eq 'PS' then begin
      device,/close
      spawn,'ps2pdf '+outfile+'_gronk.ps'
  endif
end

pro plot_response, kappas,white,tab

  wavenum= tab.wavenumber
  re = tab.real & reerr= tab.real_err
  im = tab.imag & imerr= tab.imag_err


  color= indgen(8)
  if !D.name eq 'PS' then begin
      color[1]= 0
      color[0]= 1
  end

  print,"max re",max(re),", max im",max(im)

  !P.multi= [0,2,3]

  ;;plot, kappas[0,*], white[0,*], xrange=[min(kappas),max(kappas)],/xsty, yrange=[-0.1,1.1],/ysty,$
  ;;  title=title, xtitle='kappa [m!u-1!n]', ytitle='Response', linestyle=1
  ;;for ch=1,4 do oplot, kappas[ch,*], white[ch,*], color=color[ch+1], linestyle=1

  sparse = indgen(N_elements(wavenum[0,*])/10)*10

  for ch=0,5 do begin
     plot, kappas[ch,*], white[ch,*], xrange=[min(kappas),max(kappas)],/xsty, yrange=[-0.1,1.1],/ysty,$
           title="Channel "+strtrim(ch,2), xtitle='kappa [m!u-1!n]', ytitle='Response', linestyle=1
     ;;junk='' & read,junk
     ;mag= sqrt(re[ch,*]*re[ch,*]+im[ch,*]*im[ch,*])
     ;oplot, wavenum[ch,*], mag, color=color[ch+1]
     oplot, wavenum[ch,*], re[ch,*], color=color[ch+1]
     oplot, wavenum[ch,*], im[ch,*], color=color[ch+1], linestyle=3

     errplot, wavenum[ch,sparse], re[ch,sparse]-reerr[ch,sparse], re[ch,sparse]+reerr[ch,sparse], color=color[ch+1]
  end
  ;;junk='' & read,junk

  !P.multi= [0]
end
