;
; test_adrian.pro
; Created:     Tue Apr 14 19:32:15 2009 by Koehler@Six
; Last change: Tue Apr 14 19:37:48 2009
;
; PURPOSE:
;	none
;
; WARNING:
;	This program may contain strong violence, adult content, and
;	language.  Parental guidance is advised.
;
PRO test_adrian1

  Starpos__Define	;; make sure starpos is defined with the right data types

  RA0_A = 0.d		 & Dec0_A = 0.d
  RA0_B = 7.d/15.d/3600. & Dec0_B = 7.d/3600.

  pmRA_A= 0.d		& pmDec_A= 0.d
  pmRA_B= -86.43d-3	& pmDec_B= 56.05d-3	;; mas/yr in arcsec/yr

  pos_A={ starpos, Name: "Prinda", Epoch: 2008.0, RA: RA0_A, Dec: Dec0_A, Parallax:  0.5, pmRA: pmRA_A, pmDec: pmDec_A, v_rad:-400.}
  pos_B={ starpos, Name: "Secuma", Epoch: 2008.0, RA: RA0_B, Dec: Dec0_B, Parallax: 250., pmRA: pmRA_B, pmDec: pmDec_B, v_rad: 400.}

  ;; lie about p.m.:
  ;pos_A= { starpos, Name: "Prinda", RA: RA0_A, Dec: Dec0_A, pmRA: 0., pmDec: 0., Epoch: 2008.0 }
  ;pos_B= { starpos, Name: "Secuma", RA: RA0_B, Dec: Dec0_B, pmRA: 0., pmDec: 0., Epoch: 2008.0 }

  MJD2008 = MJulday(2008,1,1,0,0,0)

  starspectrum_one, 'STARSPECTRUM_Prinda.fits', pos_A, MJD= MJD2008
  starspectrum_one, 'STARSPECTRUM_Secuma.fits', pos_B, MJD= MJD2008+1./24.

  a = obj_new("astrometry", POS_A=pos_A, Pos_B=pos_B)

  a->set_stations, 'A2', 'A8'

  MJDs= [ 54253.d, 54618.d, 54983d, 57903d ]

  ;; 3 years = 36 months
  for iMJD= 0,N_elements(MJDs)-1 do begin

     MJD0= MJDs[iMJD]
     environment, MJD=MJD0-0.5

     a->set_rates, FSUA=4., FSUB=10.
     a->set_n_phonoise,0
     a->set_primet_noise, 0.
     a->set_primet0, [ 0., 0.]

     ;; alternate between E-W and N-S baselines
     ;;a->set_stations, 'A2', (Month mod 2 eq 0)? 'Q7' : 'A8'

     tstr= MJD_to_ESO_string(MJD0)
     print,">>>>>>>>>> ",tstr," <<<<<<<<<<"

     a->set_startMJD, MJD0
     a->simulate

  endfor
  obj_destroy,a
end
