;
; test_baseline.pro
; Created:     Wed Nov  7 15:40:58 2007 by Rkoehler@lx40
; Last change: Tue Jul  7 14:59:46 2009
;
; Copyright 2008 Rainer Koehler
;
; This file is part of Pacmart.
;
; Pacmart is free software; you can redistribute it and/or modify
; it under the terms of the GNU General Public License as published by
; the Free Software Foundation; either version 2 of the License, or
; (at your option) any later version.
;
; Pacmart is distributed in the hope that it will be useful,
; but WITHOUT ANY WARRANTY; without even the implied warranty of
; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
; GNU General Public License for more details.
;
; You should have received a copy of the GNU General Public License
; along with Pacmart; if not, write to the Free Software
; Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
;
;
PRO test_baseline, basename, FILE=outfile, TEX=tex

  if N_elements(basename) lt 1 then basename= 'PACMA.2000'
  if not keyword_set(outfile) then outfile="Baseline_testresults"

  ;file = file_search(basename+'*STARSED.fits')
  ;if file[0] eq '' then begin
  ;    print,"No file found matching "+basename+'*STARSED.fits'
  ;    return
  ;end
  ;
  ;print,"Reading ",file[0]
  ;StSpec = fbt_open(file[0])
  ;
  ;prihead= StSpec.fileobj->prihead()
  ;startemp= prihead->getpar("SIM STAR TEMP")
  ;keywords= prihead->sthead()

  openw,outunit,outfile+'.tex',/get_lun
  printf,outunit,'%% '+outfile+'.tex'
  printf,outunit,"%% Baseline testresults"
  printf,outunit,""
  printf,outunit,'{\bf Input data}:'
  printf,outunit,''
  printf,outunit,'We simulated observations of 10 baseline calibrator stars at the following coordinates:'
  printf,outunit,''

  bcat = fitstable_openr('BASELINE_CALIBRATOR_CATALOG.fits','BASELINE_CATALOG',iErr=iErr)
  if iErr then begin
      print,"PRIMA! Could not read BASELINE_CALIBRATOR_CATALOG.fits!"
      return
  endif
  bdat = bcat->readrows()
  obj_destroy,bcat

  printf,outunit,'\begin{longtable}{clccc}'
  printf,outunit,'No. & ID & RA (2000.0) & Dec (2000.0) \\'
  printf,outunit,'\hline\endhead'
  printf,outunit,'\hline\endfoot'

  ;;help,bdat,/str
  for i=0,N_elements(bdat)-1 do begin
      ra= bdat[i].ra_si
      rah= floor(ra)
      ram= floor((ra-rah)*60.)
      ras= round(((ra-rah)*60.-ram)*60.)
      printf,outunit, Format="(I,' & ',A,' & ', I2,':',I02,':',I02, ' & ',F5.1,'\qquad\\')",$
        i, bdat[i].id, rah,ram,ras, bdat[i].dec_si
  endfor

  printf,outunit,'\hline'
  printf,outunit,'\end{longtable}'
  printf,outunit,'\bigskip'
  printf,outunit,'Other parameters (proper motion, parallax etc.) were set to zero.'
  printf,outunit,'Fifty observations during the night of January 1., 2000 were simulated.'
  printf,outunit,'On this particular date, the corrections for precession are zero,'
  printf,outunit,'hence no computation of these corrections was needed in the simulations.'
  printf,outunit,'The simulated baseline was 100\,m in East-West direction.'
  printf,outunit,'A simple algorithm picked stars that were within $\pm3$\,hours from'
  printf,outunit,'the meridian at the time of the observation, leading to the distribution'
  printf,outunit,'of observations on the sky depicted in the following figure.'
  printf,outunit,'The numbers correspond to the number of the star in the catalog.'
  printf,outunit,''

  spawn,'ps2pdf sky_distrib.ps'
  printf,outunit,'\centerline{\includegraphics[angle=180,width=\textwidth]{../baseline/sky_distrib.pdf}}'

  printf,outunit,''
  printf,outunit,'The raw data files should be reduced by pacma\_sciave to LEVEL1 and by pacma\_scired1'
  printf,outunit,'to LEVEL2 files.  The latter are used as input to the pacma\_baseline recipe.'
  ;printf,outunit,'\begin{verbatim}'
  ;printf,outunit,'Size     Creation date        Filename'
  ;close,outunit & free_lun,outunit
  ;
  ;spawn,'ls -l '+basename+"*.000.fits | sed -e 's/^.*users //'"
  ;spawn,'ls -l '+basename+"*.000.fits | sed -e 's/^.*users //' >> "+outfile+'.tex'
  ;
  ;openw,outunit,outfile+'.tex',/get_lun,/APPEND
  ;printf,outunit,'\end{verbatim}'
  printf,outunit,''
  printf,outunit,'{\bf Set of Frames}:'
  printf,outunit,'\verbatiminput{../baseline/Baseline.sof}'

  print_cmd_stuff, outunit, 'baseline', '../baseline/Baseline.out'

  printf,outunit,'{\bf Result:} The recipe produced the file \verb|WBASE.fits|,'
  printf,outunit,'which contains the following tables:'
  printf,outunit,'\begin{verbatim}'
  printf,outunit,'        STARINFO'
  printf,outunit,'        WIDE_BASELINE'
  printf,outunit,'\end{verbatim}'
  printf,outunit,'\smallskip'
  printf,outunit,''
  printf,outunit,'{\bf Output Data Contents}:\\'
  printf,outunit,'%'
  ;printf,outunit,'Primary Header: The following table contains the QC-keywords in the primary header.'
  ;printf,outunit,'\begin{longtable}{lccc}'
  ;printf,outunit,'Keyword & Value \\'
  ;printf,outunit,'\hline\endhead'
  ;printf,outunit,'\hline\endfoot'

  ;for k=0,N_elements(keywords)-1 do begin
  ;    ;;print,k,keywords[k]
  ;    key = stregex(keywords[k],'^HIERARCH ESO QC [A-Z0-9_ ]+[A-Z0-9_]',/Extract)
  ;    if key ne '' then begin
  ;        ;;print,"key ",key
  ;        val = prihead->getpar(key)
  ;        key = strmid(key,13)
  ;        key = strjoin( strsplit(key,'_',/Extract),'\_')
  ;        key = strjoin( strsplit(key,' ',/Extract),'.')
  ;
  ;        if strmatch(key,'QC.EFFWAVE.*') then begin
  ;            ch   = stregex(key,'[0-4]$',/Extract)
  ;            waven= 1./ ((2.1 + ch/10.) * 1d-6)
  ;            diff = val-waven
  ;            color = (abs(diff/waven) lt 1d-5) ? 'green' : 'red'
  ;            ;;print,"channel ",ch,waven,diff
  ;            printf,outunit, key,'	& ',val,'	& ',waven,' & \color{',color,'}',diff,' \\'
  ;        endif else begin
  ;            printf,outunit, key,'	& ',val,'	\\'
  ;        endelse
  ;    endif
  ;end

  ;printf,outunit,'\hline'
  ;printf,outunit,'\end{longtable}'
  ;printf,outunit,'\bigskip'

  wbfns = file_search('*WBASE.fits')
  if wbfns[0] eq '' then begin
     print,"No file matching *WBASE.fits found"
     printf,outunit,"The recipe did not produce a file matching *WBASE.fits."
     close,outunit & free_lun,outunit
     return
  endif
  wbase = fitstable_openr(wbfns[0],'WIDE_BASELINE')
  if iErr then begin
      print,"Crap! Could not read ",wbfns[0],"!"
      printf,outunit,"The recipe did produce the file ",wbfns[0],", but I cannot read it."
      close,outunit & free_lun,outunit
      return
  endif
  bline = wbase->readrows()
  obj_destroy,bcat
  help,bline,/str

  printf,outunit,'The recipe uses the iphase program by P.\ T.\ Wallace to fit for'
  printf,outunit,'the baseline parameters.' ;; The output file created by iphase contains:'
  ;;printf,outunit,'\verbatiminput{../baseline/BASELINE.dat}'

  printf,outunit,''
  printf,outunit,'\begin{longtable}{lr}'
  printf,outunit,'Parameter & \omit\hfill Value\hfill \\'
  printf,outunit,'\hline\endhead'
  printf,outunit,'\hline\endfoot'

  printf,outunit,Format='("Baseline length in $x$ & $",F10.6,"\pm",F8.6,"$ m\\")', bline.bx, bline.bx_err
  printf,outunit,Format='("Baseline length in $y$ & $",F10.6,"\pm",F8.6,"$ m\\")', bline.by, bline.by_err
  printf,outunit,Format='("Baseline length in $z$ & $",F10.6,"\pm",F8.6,"$ m\\")', bline.bz, bline.bz_err

  printf,outunit,'\hline'
  printf,outunit,'\end{longtable}'
  printf,outunit,'\bigskip'

  printf,outunit,''
  printf,outunit,'The discrepancies between the simulated baseline and the iphase result'
  printf,outunit,'are probably caused by our neglect of abberation and other effects.'
  printf,outunit,"The maximum effect caused by annual abberation due to the Earth's"
  printf,outunit,"orbital motion is of the order $30\rm\,km/s / 300000\,km/s = 10^{-4}$."
  printf,outunit,"For a baseline of 100\,m in $x$ direction, this results in a systematic"
  printf,outunit,"error perpendicular to $x$ of 0.01\,m.  The discrepancy of the iphase"
  printf,outunit,"result is about 0.0029\,m, well within the expected error."

  ;printf,outunit,'I will investigate this later.'

  ;test_stspec, StSpec.starspectrum_Ave->readrows(), outunit, outfile, startemp

  close,outunit & free_lun,outunit
  ;fbt_close,StSpec

  if keyword_set(tex) then spawn,"cd /home/rkoehler/PRIMA/Pacma_test_report; pdflatex Pacmap_test_report.tex"
end
