;
; test_env.pro
; Created:     Fri Jul  6 14:30:34 2007 by Rkoehler@lx40
; Last change: Sun Jun 28 19:29:49 2009
;
; Copyright 2008 Rainer Koehler
;
; This file is part of Pacmart.
;
; Pacmart is free software; you can redistribute it and/or modify
; it under the terms of the GNU General Public License as published by
; the Free Software Foundation; either version 2 of the License, or
; (at your option) any later version.
;
; Pacmart is distributed in the hope that it will be useful,
; but WITHOUT ANY WARRANTY; without even the implied warranty of
; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
; GNU General Public License for more details.
;
; You should have received a copy of the GNU General Public License
; along with Pacmart; if not, write to the Free Software
; Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
;
;
PRO test_env_real, basename, FILE=outfile, SENSOR=sensor

  if N_elements(basename) lt 1 then basename= 'PACMA.2007-12-0[56]T'
  if not keyword_set(outfile) then outfile="environment_"
  if not keyword_set(sensor) then sensor=[1,7,9,12,14,16,19,26,31,49,73,77,98,99,100,101,183,186]

  file = file_search(basename+"*_LEVEL1E.fits")
  if file[0] eq '' then begin
     print,"No file found matching "+basename+'*_LEVEL1E.fits'
     infile= file_search(basename+"*12:00:00.000.fits")
     infile= infile[0]
     if infile eq '' then begin
        print,"No raw environment file found - out of sense error."
        return
     endif
  endif else begin
     print,"files: ",file

     print,"Reading ",file[0]
     e  = fbt_open(file[0])	;; LEVEL1E environment file

     prihead= e.fileobj->prihead()
     infile = prihead->getpar('PRO REC1 RAW1 NAME')
  endelse
  print, "(raw) infile is ",infile

  er = fbt_open(infile)		;; environment raw file

  openw,outunit,outfile+'testresults.tex',/get_lun
  printf,outunit,'%% '+outfile+'testresults.tex'
  printf,outunit,"%% environment testresults"
  printf,outunit,""
  printf,outunit,'{\bf Input data}:'
  printf,outunit,'\begin{verbatim}'
  printf,outunit,'Size     Creation date        Filename'
  close,outunit & free_lun,outunit

  spawn,'ls -l '+basename+"*000.fits | sed -e 's/^.*users //'"
  spawn,'ls -l '+basename+"*000.fits | sed -e 's/^.*users //' >> "+outfile+'testresults.tex'

  openw,outunit,outfile+'testresults.tex',/get_lun,/APPEND
  printf,outunit,'\end{verbatim}'
  printf,outunit,''
  printf,outunit,'The data was provided by Jeroen de Jong and converted to a DICD-complaint file by a small IDL script.'
  printf,outunit,''

  sof = strmid(infile,0, strlen(infile)-strlen(".fits"))
  sof = sof[0]
  printf,outunit,'{\bf Set of Frames}:'
  printf,outunit,'\verbatiminput{../env_real/'+sof+'.sof}'
  printf,outunit,''
  printf,outunit,'The LEVEL1 files contain only the primary header, since all the information required by the environment recipe is stored there.'
  printf,outunit,''
  printf,outunit,'{\bf Sensors}:'
  printf,outunit,'\begin{longtable}{lll}'
  printf,outunit,'Sensor Name & Sensor ID & Value\\'
  printf,outunit,'\hline\endhead'
  printf,outunit,'\hline\endfoot'

  edsc= er.environment_description->readrows()
  for i=0,N_elements(edsc)-1 do begin
     name= strjoin( strsplit(edsc[i].name,'_',/Extract),'\_')
     printf,outunit,Format='(A32," & ",I3," & ",A," \\")',$
            name, edsc[i].ID[0], strtrim(edsc[i].comment,2)
  endfor

  printf,outunit,'\hline'
  printf,outunit,'\end{longtable}'
  printf,outunit,'%\bigskip'

  print_cmd_stuff, outunit, 'environment', '../env_real/'+sof+'.out'

  if keyword_set(e) then begin
     list_fbt_extensions,outunit,e
     printf,outunit,'\smallskip'
     printf,outunit,''
     printf,outunit,'%\clearpage'
     printf,outunit,'{\bf Output Data Contents}:\smallskip'
     printf,outunit,''
     printf,outunit,'The following plots show the raw and processed (interpolated) data for'
     printf,outunit,'a number of interesting sensors.  The asterisks mark the raw input data points,'
     printf,outunit,'the green lines are the points interpolated by the recipe.'
     printf,outunit,'The large plot shows the full 24 hours of the data,'
     printf,outunit,'while the inset covers only the 5 minutes of the processed data.'
     printf,outunit,''
     printf,outunit,'\begin{center}'


     MJD_robs = (er.fileobj->prihead())->getpar('MJD-OBS')
     MJD_start= double(prihead->getpar('MJD START'))
     MJD_end  = double(prihead->getpar('MJD END'))
     sec_start= floor((mjd_start-mjd_robs)*86400.d )
     sec_end  = ceil( (mjd_end  -mjd_robs)*86400.d + 300.d)

     print, "raw Ob=",MJD_rOBS
     print, "Start =",MJD_start,", diff =",sec_start," =",floor(sec_start/3600.),"h ",(sec_start/60.)mod 60.,"m"
     print, "End   =",MJD_end  ,", diff =",sec_end  ," =",floor(sec_end  /3600.),"h ",(sec_end/60.)mod 60.,"m"

     ed  = e.environment->readrows()
     erd = er.environment->readrows()
     ;;erd = erd[where(erd.time ge sec_start and erd.time le sec_end)]
     edsc= e.environment_description->readrows()

     tek_color

     for iSens=0,N_elements(sensor)-1 do begin
        idx = where( ed.sensor eq sensor[iSens])
        if idx[0] lt 0 then continue
        eds  =  ed[idx]
        erdx = erd[where(erd.sensor eq sensor[iSens])]
        edesc= edsc[where(edsc.id eq sensor[iSens])]

        plotfile= outfile+"sensor"+strtrim(sensor[iSens],2)
        if !d.name eq "PS" then device,/lands,/color,file=plotfile+".ps"

        ymin = min( [reform(eds.value), reform(erdx.value)], max=ymax )
        ;;;;;print,reform(erdx.value)
        ;;;;print,"ymin =",ymin,", ymax =",ymax
        ;;plot, eds.time_ave, eds.value, title=fname,/xstyle,ystyle=16,$
        ;;      xrange=[-30,330], yrange=[ymin*0.999,ymax*1.001], xtitle="Time [sec]",$
        ;;      ytitle="Sensor "+strtrim(sensor[iSens],2)+" = "+strtrim(edesc.name,2)+' ['+strtrim(edesc.unit,2)+']'
        ;;oplot, erdx.time-sec_start, erdx.value, psym=2
        plot, erdx.time/3600., erdx.value, title=fname,/xstyle,ystyle=16, psym=3,$
              xrange=[0,24], yrange=[ymin*0.999,ymax*1.001], xtitle="Time [hours]",$
              ytitle="Sensor "+strtrim(sensor[iSens],2)+" = "+strtrim(edesc.name,2)+' ['+strtrim(edesc.unit,2)+']'
        oplot, (eds.time_ave+sec_start)/3600., eds.value, color=3

        erdx = erdx[where(erdx.time ge sec_start and erdx.time le sec_end)]
        ymin = min( [reform(eds.value), reform(erdx.value)], max=ymax )
        plot, erdx.time-sec_start, erdx.value, /xstyle,ystyle=16,/noerase,position=[0.17,0.17,0.47,0.52],$
              xrange=[-30,330], yrange=[ymin*0.999,ymax*1.001], xtitle="Time [sec]", psym=2
        oplot, eds.time_ave, eds.value, color=3

        if !d.name eq "PS" then device,/close

        junk=""
        if !d.name eq "X" and iSens lt N_elements(sensor)-1 then $
           read,'Sensor '+strtrim(sensor[iSens],2)+', hit return for next sensor',junk

        if !D.name eq 'PS' then begin
           device,/close
           print,'ps2pdf '+plotfile+".ps"
           spawn,'ps2pdf '+plotfile+".ps"
        endif
        printf,outunit,'\includegraphics[angle=180,width=0.3\textwidth]{../env_real/'+plotfile+'.pdf}'
        ;;printf,outunit,''

     endfor
     printf,outunit,'\end{center}'
     fbt_close, e
  endif else begin
     ;; no LEVEL1E-file, recipe performed prima

     printf,outunit,'{\bf Results}:\\'
     printf,outunit,'The recipe produced the following output:'
     printf,outunit,'\begin{verbatim}'
     close,outunit & free_lun,outunit

     spawn,'esorex --suppress-prefix pacma_environment '+sof[0]+'.sof >> '+outfile+'testresults.tex 2>&1',$
           result,errRes
     help,result,errRes
     print,"Result: ",result,"//"
     print,"ErrResult: ",errres,"//"

     openw,outunit,outfile+'testresults.tex',/get_lun,/APPEND
     printf,outunit,Result,errRes
     printf,outunit,'\end{verbatim}'
  endelse

  close,outunit & free_lun,outunit
  fbt_close, er
end
