;
; test_labdark.pro
; Created:     Mon Jul  9 11:58:16 2007 by Rkoehler@lx40
; Last change: Wed Feb 25 11:20:58 2009
;
; Copyright 2008 Rainer Koehler
;
; This file is part of Pacmart.
;
; Pacmart is free software; you can redistribute it and/or modify
; it under the terms of the GNU General Public License as published by
; the Free Software Foundation; either version 2 of the License, or
; (at your option) any later version.
;
; Pacmart is distributed in the hope that it will be useful,
; but WITHOUT ANY WARRANTY; without even the implied warranty of
; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
; GNU General Public License for more details.
;
; You should have received a copy of the GNU General Public License
; along with Pacmart; if not, write to the Free Software
; Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
;
;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

PRO test_labdark, basename, FILE=outfile

  if N_elements(basename) lt 1 then basename= 'PACMA.2008-04-01T00:0'
  if not keyword_set(outfile) then outfile="labdark_testresults"

  file = file_search(basename+"*_LABDARK.fits")
  if file[0] eq '' then begin
      print,"No file found matching "+basename+'*_LABDARK.fits'
      return
  end
  print,"files: ",file

  print,"Reading ",file[0]
  ld = fbt_open(file[0])

  openw,outunit,outfile+'.tex',/get_lun
  printf,outunit,'%% '+outfile+'.tex'
  printf,outunit,"%% Labdark testresults"
  printf,outunit,""
  printf,outunit,'{\bf Input data}:'
  printf,outunit,'\begin{verbatim}'
  printf,outunit,'Size  Creation date        Filename'
  close,outunit & free_lun,outunit

  spawn,'ls -l '+basename+"*0.fits | sed -e 's/^.*users //'"
  spawn,'ls -l '+basename+"*0.fits | sed -e 's/^.*users //' >> "+outfile+'.tex'

  openw,outunit,outfile+'.tex',/get_lun,/APPEND
  printf,outunit,'\end{verbatim}'
  printf,outunit,''

  sof = strmid(file[0],0, strlen(file[0])-strlen("_LABDARK.fits"))
  printf,outunit,'{\bf Set of Frames}:'
  printf,outunit,'\verbatiminput{../lab/'+sof+'.sof}'
  printf,outunit,''
  printf,outunit,''
  printf,outunit,'{\bf Simulation Parameters}:'
  printf,outunit,'\begin{longtable}{lll}'
  printf,outunit,'Parameter & Value & Comment\\'
  printf,outunit,'\hline\endhead'
  printf,outunit,'\hline\endfoot'

  head= ld.imAging_deTector_fsuA->head()
  keywords= head->sthead()

  for k=0,N_elements(keywords)-1 do begin
     ;;print,k,keywords[k]
     key = stregex(keywords[k],'^HIERARCH ESO SIM [A-Z0-9_ ]+[A-Z0-9_]',/Extract)
     if key ne '' then begin
        ;;print,"key ",key
        val = head->getpar(key,COMM=comment)
        key = strmid(key,17)	;; get rid of HIERARSCH ESO SIM
        key = strjoin( strsplit(key,'_',/Extract),'\_')
        key = strjoin( strsplit(key,' ',/Extract),'.')

        if strmatch(key,'QC.EFFWAVE.*') then begin
           ch   = stregex(key,'[0-4]$',/Extract)
           waven= 1./ ((2.1 + ch/10.) * 1d-6)
           diff = val-waven
           color = (abs(diff/waven) lt 1d-5) ? 'green' : 'red'
           ;;print,"channel ",ch,waven,diff
           printf,outunit, key,'	& ',val,'	& ',waven,' & \color{',color,'}',diff,' \\'
        endif else begin
           printf,outunit, key,'	& ',val,'	& ',comment,'	\\'
        endelse
     endif
  end

  printf,outunit,'\hline'
  printf,outunit,'\end{longtable}'
  printf,outunit,'\bigskip'
  printf,outunit,''
  printf,outunit,'The simulated pixel values are normally distributed with a mean of'
  printf,outunit,'(BIASnn + DARKnn $\times$ DIT) and a standard deviation of NOISE.'
  printf,outunit,'BIAS and DARK are set independently for each wavenumber bin,'
  printf,outunit,'but are the same for the ABCD pixels within one wavenumber bin.'
  printf,outunit,'NOISE is the same for all 20 pixels.'
  printf,outunit,'Four files with DITs of 0.125, 0.25, 0.5, and 1.0 are simulated.'
  printf,outunit,'\bigskip'

  print_cmd_stuff, outunit, 'labdark', '../lab/'+sof+'.out'
  list_fbt_extensions, outunit, ld

  printf,outunit,'\bigskip'
  printf,outunit,''
  printf,outunit,'%\clearpage'
  printf,outunit,'{\bf Output Data Contents}:\\'
  printf,outunit,'The important results are in table \verb|DARK_FSUA_FIT|, which has this structure:'
  printf,outunit,''
  printf,outunit,'\begin{center}'

  df = ld.DARK_FSUA_fit->readrows()
  dump_table_structure, outunit, df
  printf,outunit,'\end{center}'

  bias = fltarr(6)
  good = fltarr(6)
  printf,outunit,'The results of the test are shown in these tables:'
  printf,outunit,''
  printf,outunit,'\begin{tabular}{lllllll}'
  printf,outunit,'\hline\noalign{\vspace{2pt}}'
  printf,outunit,'\span\span\span\bf Bias \span\span\\'
  printf,outunit,'\hline'
  printf,outunit,'Waveno.\\'
  printf,outunit,'Channel & 1 & 2 & 3 & 4 & 5 & 6\\'
  ;;printf,outunit,'\hline'
  printf,outunit,Format='("Truth",$)'
  for c=0,5 do begin
      key = string(format='("SIM BIAS",I1)',c+1)
      bias[c]= head->getpar(key)
      printf,outunit,Format='(" &",F5.2,$)',bias[c]
  endfor
  printf,outunit,'\\'

  Nch = N_elements(df[1].data1)	;; we assume all DATAs are equally wide

  tags = tag_names(df[1])
  for t=0,3 do begin
      dtag = string(format='("DATA",I1)',t+1)
      tag = where(tags eq dtag)
      printf,outunit,format='(A-10,$)',dtag
      for c=0,Nch-1 do begin
          b = (df[1].(tag))[c]
          be= (df[3].(tag))[c]
          printf,outunit,Format='(" & $",F5.2,"\pm",F4.2,"$",$)',b,be
          sig = abs(bias[c]-b)/be
          if (sig gt good[c]) then good[c] = sig
      endfor
      printf,outunit,"\\"
  endfor
  printf,outunit,'\reportonly{Result'
  for c=0,Nch-1 do $
    printf,outunit,Format='(" &",A0,$)',$
    ((good[c] le 3.) ? "{\color{green}within errors}" : string(Format='(F5.2,"$\sigma$")',good[c]))
  printf,outunit,'\\}'

  dark = fltarr(6)
  good = fltarr(6)
  printf,outunit,'\hline\\\hline\noalign{\vspace{2pt}}'
  printf,outunit,'\span\span\span\bf Dark current \span\span\\'
  printf,outunit,'\hline'
  printf,outunit,'Waveno.\\'
  printf,outunit,'Channel & 1 & 2 & 3 & 4 & 5 & 6\\'
  ;;printf,outunit,'\hline'
  printf,outunit,Format='("Truth",$)'
  for c=0,5 do begin
      key = string(format='("SIM DARK",I1)',c+1)
      dark[c]= head->getpar(key)
      printf,outunit,Format='(" &",F5.2,$)',dark[c]
  endfor
  printf,outunit,'\\'

  tags = tag_names(df[2])
  for t=0,3 do begin
      dtag = string(format='("DATA",I1)',t+1)
      tag = where(tags eq dtag)
      printf,outunit,format='(A-10,$)',dtag
      for c=0,Nch-1 do begin
          b = (df[2].(tag))[c]
          be= (df[4].(tag))[c]
          printf,outunit,Format='(" & $",F5.2,"\pm",F4.2,"$",$)',b,be
          sig = abs(dark[c]-b)/be
          if (sig gt good[c]) then good[c] = sig
      endfor
      printf,outunit,"\\"
  endfor
  printf,outunit,'\reportonly{Result'
  for c=0,Nch-1 do $
    printf,outunit,Format='(" &",A0,$)',$
    ((good[c] le 3.) ? "{\color{green}within errors}" : string(Format='(F5.2,"$\sigma$")',good[c]))
  printf,outunit,'\\}'

  printf,outunit,'\hline'
  printf,outunit,'\end{tabular}'
  printf,outunit,''

  if Nch lt 6 then printf,outunit,'The recipe does not process all 6 spectral channels.'

  close,outunit & free_lun,outunit
  fbt_close, ld
end
