;
; test_labflat.pro
; Created:     Mon Jul  9 11:58:16 2007 by Rkoehler@lx40
; Last change: Thu May 12 14:48:40 2011
;
; Copyright 2008 Rainer Koehler
;
; This file is part of Pacmart.
;
; Pacmart is free software; you can redistribute it and/or modify
; it under the terms of the GNU General Public License as published by
; the Free Software Foundation; either version 2 of the License, or
; (at your option) any later version.
;
; Pacmart is distributed in the hope that it will be useful,
; but WITHOUT ANY WARRANTY; without even the implied warranty of
; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
; GNU General Public License for more details.
;
; You should have received a copy of the GNU General Public License
; along with Pacmart; if not, write to the Free Software
; Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
;
;
PRO test_labflat, basename, FILE=outfile, TYPE=type

  if N_elements(basename) lt 1 then basename= 'PACMA.20??-04-01T00?1'
  if not keyword_set(type) then type= 'LAB'	;; LAB or STAR
  type = strupcase(type)

  if not keyword_set(outfile) then $
     outfile= (type eq 'LAB'? "lab":"star") + "flat_testresults"

  openw,outunit,outfile+'.tex',/get_lun
  printf,outunit,'%% '+outfile+'.tex'
  printf,outunit,"%% "+type+"flat testresults"
  printf,outunit,""
  printf,outunit,'{\bf Input data}:'
  printf,outunit,'\begin{verbatim}'
  printf,outunit,'Size  Creation date        Filename'
  close,outunit & free_lun,outunit

  spawn,'ls -l '+basename+"*0.fits | sed -e 's/^.*users //'"
  spawn,'ls -l '+basename+"*0.fits | sed -e 's/^.*users //' >> "+outfile+'.tex'

  openw,outunit,outfile+'.tex',/get_lun,/APPEND
  printf,outunit,'\end{verbatim}'
  printf,outunit,''

  ;;file = file_search(basename+"*_LABFLAT.fits")
  file = file_search(basename+"*_"+type+"FLAT.fits")
  if file[0] eq '' then begin
      print,"No file found matching "+basename+'*_'+type+'FLAT.fits'
      printf,outunit,'No file found matching \verb|'+basename+'*_'+type+'FLAT.fits|'
      close,outunit & free_lun,outunit
      return
  end
  print,"files: ",file

  print,"Reading ",file[0]
  ld = fbt_open(file[0])

  sof = strmid(file[0],0, strlen(file[0])-strlen(type)-strlen('_FLAT.fits'))
  bnm = (type eq 'LAB'? '../lab/':'../sky/')+sof[0]
  printf,outunit,'{\bf Set of Frames}:'
  printf,outunit,'\verbatiminput{'+bnm+'.sof}'
  printf,outunit,''
  printf,outunit,''
  printf,outunit,'{\bf Simulation Parameters}:'
  printf,outunit,'\begin{longtable}{lll}'
  printf,outunit,'Parameter & Value & Comment\\'
  printf,outunit,'\hline\endhead'
  printf,outunit,'\hline\endfoot'

  head= ld.imAging_deTector_fsuA->head()
  keywords= head->sthead()

  for k=0,N_elements(keywords)-1 do begin
     ;;print,k,keywords[k]
     key = stregex(keywords[k],'^HIERARCH ESO SIM [A-Z0-9_ ]+[A-Z0-9_]',/Extract)
     if key ne '' then begin
        ;;print,"key ",key
        val = head->getpar(key,COMM=comment)
        key = strmid(key,17)	;; get rid of HIERARSCH ESO SIM
        key = strjoin( strsplit(key,'_',/Extract),'\_')
        key = strjoin( strsplit(key,' ',/Extract),'.')

        if strmatch(key,'QC.EFFWAVE.*') then begin
           ch   = stregex(key,'[0-4]$',/Extract)
           waven= 1./ ((2.1 + ch/10.) * 1d-6)
           diff = val-waven
           color = (abs(diff/waven) lt 1d-5) ? 'green' : 'red'
           ;;print,"channel ",ch,waven,diff
           printf,outunit, key,'	& ',val,'	& ',waven,' & \color{',color,'}',diff,' \\'
        endif else begin
           printf,outunit, key,'	& ',val,'	& ',comment,'	\\'
        endelse
     endif
  end

  printf,outunit,'\hline'
  printf,outunit,'\end{longtable}'
  printf,outunit,'%\bigskip'
  if type eq 'STAR' then begin
     printf,outunit,''
     printf,outunit,'The parameter values used for the simulation are completely arbitrary.'
     printf,outunit,'Any similarity to real data is purely coincidental.'
  endif
  printf,outunit,''
  printf,outunit,'The simulated pixel values are normally distributed with a mean of'
  printf,outunit,'(BIASn + FLUXn $\times$ DIT) and a standard deviation of NOISE.'
  printf,outunit,'BIAS is set independently for each wavenumber channel'
  printf,outunit,'but are the same for DATA1--4 within one wavenumber channel.'
  ;;printf,outunit,'This means that the alignment of the fibers was perfect in the simulation.'
  printf,outunit,'FLUX and NOISE are set independently for each wavenumber channel and DATA1--4.'
  printf,outunit,'\bigskip'

  print_cmd_stuff, outunit, strlowcase(type)+'flat', bnm+'.out'
  list_fbt_extensions, outunit, ld

  printf,outunit,'\bigskip'
  printf,outunit,''
  printf,outunit,'%\clearpage'
  printf,outunit,'{\bf Output Data Contents}:\\[5pt]'
  printf,outunit,'The important results are in tables'
  printf,outunit,'\verb|'+type+'_FLAT_FSUA| and \verb|'+type+'_FLAT_FSUB|, which have this structure:'
  ;;printf,outunit,''
  printf,outunit,'\begin{center}'

  df = (type eq 'LAB'? ld.lab_flat_fsuB : ld.Star_Flat_fsuB)->readrows()
  dump_table_structure, outunit, df
  printf,outunit,'\end{center}'

  ;;printf,outunit,'The expected result of the test is that MEAN1--4 for each channel are the same within the errors.'
  ;;printf,outunit,'The actual results are:'

  printf,outunit,'\clearpage'
  printf,outunit,'The following table shows, for each pixel, the expected and computed value.'
  printf,outunit,'They are printed in green if both agree within the errors.'
  printf,outunit,''
  printf,outunit,'\begin{tabular}{llllll}'

  simflux = fltarr(6,4)
  simnoise= fltarr(6,4)
  for ch=0,5 do begin
     for i=0,3 do begin
        pixnm = string(byte('A')+byte(i)) + string(ch+1,format="(I1)")
        simflux[ch,i] = head->getpar('SIM FLUX' +pixnm)
        simnoise[ch,i]= head->getpar('SIM NOISE'+pixnm)
        print,"Flux ",pixnm,simflux[ch,i],simnoise[ch,i]
     endfor
  endfor
  ;;print,"simfluxnoise:",simflux[0,*],simnoise[0,*]

  simnoise/= max(simflux)	;; normalize before max(simflux) == 1
  simflux /= max(simflux)	;; normalize to max(simflux) = 1

  for fsu=0,1 do begin
     printf,outunit,'\hline\noalign{\vskip2pt}'
     printf,outunit,'\span\span\span FSU '+(fsu eq 0 ? 'A':'B')+'\span\span\\'
     printf,outunit,'\hline\noalign{\vskip2pt}'
     printf,outunit,'Column & MEAN1$\pm$STDEV1 & MEAN2$\pm$STDEV2 & MEAN3$\pm$STDEV3 & MEAN4$\pm$STDEV4\\'

     if fsu eq 0 then begin
        if type eq 'LAB' then begin
           df = ld.LAB_FLAT_FSUA->readrows()
        endif else begin
           df = ld.STAR_FLAT_FSUA->readrows()
        endelse
     endif else begin
        df = (type eq 'LAB'? ld.lab_flat_fsuB : ld.Star_Flat_fsuB)->readrows()
     endelse
     df = df[N_elements(df)-1]	;; the interesting part is in the last row

     m = dblarr(4)
     s = dblarr(4)

     if size(df,/tname) eq 'STRUCT' then begin
        Nch= N_elements(df[0].mean1)

        tags = tag_names(df[0])
        for c=0,Nch-1 do begin
           simf = simflux[c,*]
           simn = simnoise[c,*] / max(simf) * sqrt(2.)	;; result is computed from 2 beams
           simf /= max(simf)

           printf,outunit,format='("Channel ",I1,$)',c+1
           for t=0,3 do $
              printf,outunit,Format='(" & $",F7.5,"\pm",F7.5,"$")',simf[t],simn[t]
           printf,outunit,"\\"

           printf,outunit,format='("computed ",$)'
           for t=0,3 do begin
              mtag = where(tags eq string(format='("MEAN", I1)',t+1))
              stag = where(tags eq string(format='("STDEV",I1)',t+1))

              m[t] = (df[0].(mtag))[c]
              s[t] = (df[0].(stag))[c]

              err = sqrt( s[t]*s[t] + simn[t]*simn[t])
              res= (abs(m[t]-simf[t]) lt 3.*err) ? "\color{green}" : ""
              printf,outunit,Format='(" & {",A0,"$",F0.5,"\pm ",F0.5,"$}",$)',res,m[t],s[t]
           endfor
           ma = max(m,maxid) & sa = s[maxid]
           mi = min(m,minid) & si = s[minid]
           e = sqrt(sa*sa+si*si)
           res = "" ;;((ma-mi) lt 4.*e) ? "{\color{green}ok}" : string(Format='(F5.2,"$\sigma$")',(ma-mi)/e)
           ;;print, "channel",c+1,': ',res
           printf,outunit," & \reportonly{\color{green}",res,"}\\"
        endfor
     endif
     printf,outunit,'\hline\\'
  endfor
  printf,outunit,'\end{tabular}'

  close,outunit & free_lun,outunit
  fbt_close, ld
end
