;
; test_sciave.pro
; Created:     Mon Jul  9 11:58:16 2007 by Rkoehler@lx40
; Last change: Wed May 25 11:36:04 2011
;
; Copyright 2008 Rainer Koehler
;
; This file is part of Pacmart.
;
; Pacmart is free software; you can redistribute it and/or modify
; it under the terms of the GNU General Public License as published by
; the Free Software Foundation; either version 2 of the License, or
; (at your option) any later version.
;
; Pacmart is distributed in the hope that it will be useful,
; but WITHOUT ANY WARRANTY; without even the implied warranty of
; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
; GNU General Public License for more details.
;
; You should have received a copy of the GNU General Public License
; along with Pacmart; if not, write to the Free Software
; Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

PRO sciave_datatables__define
 s= { sciave_datatables,$
      imaging_data_FSUA_raw: ptr_new(),$
      imaging_data_FSUB_raw: ptr_new(),$
      main_delay:    ptr_new(),$
      imaging_data_FSUA: ptr_new(),$
      imaging_data_FSUB: ptr_new(),$
      imaging_data_FSUAB: ptr_new(),$
      primet:     ptr_new(),$
      primet_FSUB: ptr_new()$
    }
end


PRO print_mean_row, outunit, text, fmt, colarr
  printf,outunit,Format='(A,$)',text
  for c=0,4 do printf,outunit,Format='(" & ",'+fmt+',$)', mean(colarr[c])
  printf,outunit,'\\'
end

PRO test_fsu, outunit, FSU, data
  if N_elements(data) le 1 then return

  printf,outunit,'\hline'
  printf,outunit,'IMAGING\_DATA\_',FSU,'\span\span\span\\'
  printf,outunit,'\hline'
  ;print,Format='("True value",$)'
  ;for c=0,4 do $
  ;  print,Format='(" &",I5,$)',wahr
  ;print,'\\'

  printf,outunit,'Column name          	   & Channel 1 & Channel 2 & Channel 3 & Channel 4 & Channel 5\\'
  ;;print_mean_row,-1,'Phases (rad)		  ',	'F', data.phase
  print_mean_row,outunit,'PHASE',	'F8.5', data.phase	;; 'Phases (rad)		  '
  print_mean_row,outunit,'VIS\_SQR',	'F7.5', data.vis_sqr    ;; 'Squared Visibility	  '
  print_mean_row,outunit,'PHOTON\_NUM',	'I7',	data.photon_num ;; 'Photon numbers	  '
  print_mean_row,outunit,'FLUX\_REAL',	'I7',	data.flux_real  ;; 'Real part of flux	  '
  print_mean_row,outunit,'FLUX\_IMAG',	'I7',	data.flux_imag  ;; 'Imag.\ part of flux	  '
  ;print_mean_row,outunit,'Real part of visibility	  ',	'F7.4', data.vis_real
  ;print_mean_row,outunit,'Imag.\ part of visibility ',		'F7.4', data.vis_imag

  printf,outunit,'\hline'
end

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; head is the prihead

Function nickave, head, tabs, keyarr, ch

  XA= (*tabs.imaging_data_Fsua).flux_Real[ch]
  XB= (*tabs.imaging_data_Fsub).flux_Real[ch]
  YA= (*tabs.imaging_data_Fsua).flux_imAg[ch]
  YB= (*tabs.imaging_data_Fsub).flux_imaG[ch]

  FXre= ( XA*XB + YA*YB) * 4.
  FXim= (-XA*YB + XB*YA) * 4.

  PhotA= (*tabs.imaging_data_Fsua).photon_num[ch]
  PhotB= (*tabs.imaging_data_Fsub).photon_num[ch]

  good = where(PhotA gt 0. and PhotB gt 0)
  if good[0] gt -1 then begin
     PhotA= PhotA[good]
     PhotB= PhotB[good]
     FXre = FXre[good]
     FXim = FXim[good]
  endif
  FXre= total(FXre)
  FXim= total(FXim)

  Astate= strtrim(head->getpar('HIERARCH ESO ISS FSU2 STATE'),2)
  Bstate= strtrim(head->getpar('HIERARCH ESO ISS FSU1 STATE'),2)
  ;;print,"nickave: >",Astate,"|",Bstate,"<"
  if Astate eq 'ONLINE' then begin
     ;;print,"A was nicked"
     NAB = total(PhotB * PhotB) * total(PhotA) / total(PhotB)
  endif else if Bstate eq 'ONLINE' then begin
     ;;print,"B was nicked"
     NAB = total(PhotA * PhotA) * total(PhotB) / total(PhotA)
  endif else $
     NAB = total(PhotA * PhotB)

  if keyarr[2] eq 'CROSS_VIS_REAL' then return, total(FXre / NAB)
  if keyarr[2] eq 'CROSS_VIS_IMAG' then return, total(FXim / NAB)
  if keyarr[2] eq 'DIFF_PHASE' then return, atan( total(FXim/NAB), total(FXre/NAB))

  print,"What's ",keyarr[2]
  return,-1.
end

PRO test_keyword, outunit, head, key, tabs

  keyarr= strsplit(key,'.',/Extract)
  hkey= key
  if strpos(key,'.') gt -1 then hkey= 'HIERARCH ESO ' + strjoin(keyarr,' ')

  tags = tag_names(tabs)

  if keyarr[0] eq 'QC' && N_elements(keyarr) gt 2 && keyarr[1] ne 'OBS' then begin
      case keyarr[1] of
          'MDL':   tabname= 'MAIN_DELAY'
          'FSUA':  tabname= 'IMAGING_DATA_FSUA'
          'FSUB':  tabname= 'IMAGING_DATA_FSUB'
          'FSUAB': tabname= 'IMAGING_DATA_FSUAB'
          'PRIMET': tabname = 'PRIMET'
          'PRIMETB': tabname= 'PRIMET_FSUB'	;; Ave caesar, metrology te salutant!
          else: tabname = keyarr[1]
      endcase
      tabnum= where(tags eq tabname)
      if tabnum lt 0 then begin
          myval = 'table \verb|'+tabname+'| not present'
      endif else begin
          table= *(tabs.(tabnum))
          if size(table,/TYPE) ne 8 then begin
             return	;; table empty -> keyword irrelevant
          endif else begin
             charr= stregex(keyarr[2],'^(.*)([0-5])$',/extra,/sube)
             if charr[0] ne '' then begin
                keyarr[2]= charr[1]
                ch= charr[2]
             endif else ch=0
             ttag = where(tag_names(table) eq keyarr[2])
             if ttag lt 0 then begin
                myval= 'column \verb|'+keyarr[2]+'| not found'
             endif else begin
                column= (table.(ttag))[ch,*]
                case keyarr[3] of
                   'MIN': myval= min( column)
                   'MAX': myval= max( column)
                   'AVE': if keyarr[1] eq 'FSUAB' then $
                      myval= '' $ ;nickave(head,tabs,keyarr,ch) $
                   else myval= mean(column)
                   'ERR': myval= stddev(column) / sqrt(N_elements(column))
                   'SNG': myval= stddev(column)
                   else: myval= "what's "+strjoin( strsplit(keyarr[3],'_',/Extract),'\_')
                endcase
             endelse
          endelse ;; empty table
       endelse ;; table not present
  endif else begin
      tabname= '---'
      tabnum = -1
      myval = '' ;'no table'
  endelse

  value= head->getpar(hkey,match)
  if match eq 0 then begin
     value = '\bf NOT PRESENT'
     myval = ''
     ;; print nothing to avoid confusing the reader even more than usual
  endif else begin
     vtype= size(value,/tname)
     if size(myval,/tname) eq vtype and (vtype eq 'DOUBLE' or vtype eq 'FLOAT') then begin
        if abs(myval-value) le abs(myval)*1d-6 then myval= '\color{green}ok'
        ;;myval = ":"+string(myval)
     endif else begin
        if (myval ne '') and (string(myval) eq string(value)) then myval = "\color{green}ok"
        ;;myval = size(value,/tname)+" "+string(myval)
        value= strjoin( strsplit(value,'_',/Extract),'\_') ;; quote underscores
     endelse
     hkey = strjoin( strsplit(key  ,'_',/Extract),'\_')	;; quote underscores
     printf,outunit, hkey, "	& ", value, " & ", myval,'\\'
  endelse
end

PRO test_waven_keyword, outunit, head, key, tabs
  npos= strpos(key,'n')
  if npos le -1 then begin
      test_keyword, outunit, head, key, tabs
  endif else $
    for ch=0,5 do test_keyword,outunit,head, strmid(key,0,npos)+strtrim(ch,2)+strmid(key,npos+1), tabs
end


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

PRO test_sciave_file, basename, FILE=outfile

  if N_elements(basename) lt 1 then basename= 'PACMA.2008-04-01T0'
  if not keyword_set(outfile) then outfile="sciave_"

  openw,outunit,outfile+'testresults.tex',/get_lun
  printf,outunit,'%% '+outfile+'testresults.tex'
  printf,outunit,"%% sciave testresults"
  printf,outunit,""
  printf,outunit,'{\bf Input data}:'
  printf,outunit,'\begin{verbatim}'
  printf,outunit,'Size     Creation date        Filename'
  close,outunit & free_lun,outunit

  spawn,'ls -l '+basename+"*000.fits | sed -e 's/^.*users //'"
  spawn,'ls -l '+basename+"*000.fits | sed -e 's/^.*users //' >> "+outfile+'testresults.tex'

  openw,outunit,outfile+'testresults.tex',/get_lun,/APPEND
  printf,outunit,'\end{verbatim}'
  printf,outunit,''

  file = file_search(basename+"*_LEVEL1.fits")
  if file[0] eq '' then begin
      print,"No file found matching "+basename+'*_LEVEL1.fits'

      file= file_search(basename+"*.000.fits")
      if file[0] eq '' then begin
          print,"No input file found, I give up"
          close,outunit & free_lun,outunit
          return
      endif
      infile = file[0]
  end else begin
      print,"files: ",file
      print,"Reading ",file[0]
      lvl1= fbt_open(file[0])

      prihead= lvl1.fileobj->prihead()
      infile = prihead->getpar('PRO REC1 RAW1 NAME')
  endelse

  print, "infile is ",infile
  lvl0= fbt_open(infile)

  sof = strmid(infile,0, strlen(infile)-strlen(".fits"))
  sof = sof[0]
  printf,outunit,'{\bf Set of Frames}:'
  printf,outunit,'\verbatiminput{../sciave/'+sof+'.sof}'
  printf,outunit,''
  printf,outunit,''
  printf,outunit,'{\bf Simulation Parameters}:'
  printf,outunit,'\begin{longtable}{lll}'
  printf,outunit,'Parameter & Value & Comment\\'
  printf,outunit,'\hline\endhead'
  printf,outunit,'\hline\endfoot'


  prihead= lvl0.fileobj->prihead()
  keywords= prihead->sthead()
  for k=0,N_elements(keywords)-1 do begin
     ;;print,k,keywords[k]
     key = stregex(keywords[k],'^HIERARCH ESO ISS FSU[1-4] STATE',/Extract)
     if key ne '' then begin
        val = prihead->getpar(key,COMM=comment)
        key = strmid(key,17)	;; get rid of HIERARSCH ESO SIM
        key = strjoin( strsplit(key,'_',/Extract),'\_')
        key = strjoin( strsplit(key,' ',/Extract),'.')
        printf,outunit, key,'	& ',val,'	& ',comment,'	\\'
     endif
  endfor

  if prihead->getpar('HIERARCH ESO ISS FSU2 DIT') ne 0 then begin
     print,"FSU2 is on, using FSUA"
     head= lvl0.imaging_data_fsuA->head()
  endif else begin
     print,"FSU2 is off, using FSUB"
     head= lvl0.imaging_data_fsuB->head()
  endelse
  keywords= head->sthead()

  for k=0,N_elements(keywords)-1 do begin
     ;;print,k,keywords[k]
     key = stregex(keywords[k],'^HIERARCH ESO SIM [A-Z0-9_ ]+[A-Z0-9_]',/Extract)
     if key ne '' then begin
        ;print,"key ",key
        val = head->getpar(key,COMM=comment)
        key = strmid(key,17)	;; get rid of HIERARSCH ESO SIM
        key = strjoin( strsplit(key,'_',/Extract),'\_')
        key = strjoin( strsplit(key,' ',/Extract),'.')
        printf,outunit, key,'	& ',val,'	& ',comment,'	\\'
     endif
  end

  ;;head= lvl1.primet->head()
  head= lvl0.metrology_data->head()
  keywords= head->sthead()

  for k=0,N_elements(keywords)-1 do begin
     ;;print,k,keywords[k]
     key = stregex(keywords[k],'^HIERARCH ESO SIM [A-Z0-9_ ]+[A-Z0-9_]',/Extract)
     if key ne '' then begin
        ;print,"key ",key
        val = head->getpar(key,COMM=comment)
        key = strmid(key,17)	;; get rid of HIERARSCH ESO SIM
        key = strjoin( strsplit(key,'_',/Extract),'\_')
        key = strjoin( strsplit(key,' ',/Extract),'.')
        printf,outunit, key,'	& ',val,'	& ',comment,'	\\'
     endif
  end

  printf,outunit,'\hline'
  printf,outunit,'\end{longtable}'
  printf,outunit,'\bigskip'
  printf,outunit,''

  printf,outunit,'The simulation parameters corresponds to the following magnitudes in the five wavelength channels:'

  hdr = lvl0.imaging_data_fsua->head()
  img = lvl0.imaging_data_fsua->readrows()
  if size(img,/TYPE) eq 8 then begin
     counts = (long(img.data1) + long(img.data2) + long(img.data3) + long(img.data4))/4.
     mags = fct_magnitude( counts,$
                           [ hdr->getpar('HIERARCH ESO SIM WAVENO0'),$
                             hdr->getpar('HIERARCH ESO SIM WAVENO1'),$
                             hdr->getpar('HIERARCH ESO SIM WAVENO2'),$
                             hdr->getpar('HIERARCH ESO SIM WAVENO3'),$
                             hdr->getpar('HIERARCH ESO SIM WAVENO4') ], $
                           hdr->getpar('HIERARCH ESO SIM FSU TIME'),$
                           hdr->getpar('HIERARCH ESO SIM FSU THROUGHPUT'),$
                           hdr->getpar('HIERARCH ESO SIM FSU TEL_DIAM') )
     ;;print, mean(counts)
     ;;print, hdr->getpar('HIERARCH ESO SIM FSU WAVE0')
     ;;print, hdr->getpar('HIERARCH ESO SIM FSU WAVE1')
     ;;print, hdr->getpar('HIERARCH ESO SIM FSU WAVE2')
     ;;print, hdr->getpar('HIERARCH ESO SIM FSU WAVE3')
     ;;print, hdr->getpar('HIERARCH ESO SIM FSU WAVE4')
     ;;print, hdr->getpar('HIERARCH ESO SIM FSU TIME')
     ;;print, hdr->getpar('HIERARCH ESO SIM FSU THROUGHPUT')
     ;;print, hdr->getpar('HIERARCH ESO SIM FSU TEL_DIAM')

     printf,outunit,Format='("FSU A: ", 4(F5.2,", "), F5.2," mag, ")',mags
  endif

  hdr = lvl0.imaging_data_fsuB->head()
  img = lvl0.imaging_data_fsuB->readrows()
  if size(img,/TYPE) eq 8 then begin
     mags = fct_magnitude( (img.data1 + img.data2 + img.data3 + img.data4)/4.,$
                           [ hdr->getpar('HIERARCH ESO SIM WAVENO0'),$
                             hdr->getpar('HIERARCH ESO SIM WAVENO1'),$
                             hdr->getpar('HIERARCH ESO SIM WAVENO2'),$
                             hdr->getpar('HIERARCH ESO SIM WAVENO3'),$
                             hdr->getpar('HIERARCH ESO SIM WAVENO4') ], $
                           hdr->getpar('HIERARCH ESO SIM FSU TIME'),$
                           hdr->getpar('HIERARCH ESO SIM FSU THROUGHPUT'),$
                           hdr->getpar('HIERARCH ESO SIM FSU TEL_DIAM') )
     printf,outunit,Format='("FSU B: ", 4(F5.2,", "), F5.2," mag.")',mags
  endif

  print_cmd_stuff, outunit, 'sciave', '../sciave/'+sof+'.out', CMDSEARCH=sof+'.sof'
  ;;
  ;; check if there's an output file that we can test
  ;;
  if N_elements(lvl1) le 0 then begin
     printf,outunit,'The recipe did not produce an output file.'
     close,outunit & free_lun,outunit
     fbt_close, lvl0
     return
  endif

  list_fbt_extensions,outunit,lvl1
  printf,outunit,'\smallskip'
  printf,outunit,''
  printf,outunit,'%\clearpage'
  printf,outunit,'{\bf Output Data Contents}:\\'
  printf,outunit,'\medskip'


  exts= tag_names(lvl1)

  tabs= { sciave_datatables }
  tags= tag_names(tabs)
  for t=0,N_elements(tags)-1 do begin
      if (tags[t] eq 'IMAGING_DATA_FSUA_RAW') then begin
          print,"Not reading Level0 FSUA"
          ;;tabs.(t)= ptr_new(lvl0.imaging_data_FSUA->readrows(),/no_copy)
      endif else if (tags[t] eq 'IMAGING_DATA_FSUB_RAW') then begin
          print,"Not reading Level0 FSUB"
          ;;tabs.(t)= ptr_new(lvl0.imaging_data_FSUB->readrows(),/no_copy)
      endif else begin
          t1= where(exts eq tags[t])
          if (t1[0] ne -1) then tabs.(t)= ptr_new(lvl1.(t1)->readrows(),/no_copy)
          print,Format='("Reading ",A-24,"-> Extension #",I2)',tags[t],t1
          ;; longest is 'METROLOGY_DATA_FSUB'
      endelse
  endfor

  ;;;;; PRIMARY HEADER KEYWRODS

  printf,outunit,'The following table contains important keywords from the primary header and their values.'
  printf,outunit,'The value of the header keyword is compared to the data in the corresponding column'
  printf,outunit,"and marked ``{\color{green}OK}'' if they agree."
  printf,outunit,'The averages of the cross visibilities and the differential phases are'
  printf,outunit,'{\em not} computed from the table data, but by a special formula which'
  printf,outunit,'computes an unbiased estimate from the raw data.'
  printf,outunit,'The formula was checked during the code review.'
  printf,outunit,''
  printf,outunit,'\begin{longtable}{lcc}'
  printf,outunit,'Keyword & Value & \reportonly{Result}\\'
  printf,outunit,'\hline\endhead'
  printf,outunit,'\hline\endfoot'

  openr,keyunit,"test_sciave_keywords.txt",/get_lun
  prihead= lvl1.fileobj->prihead()
  while not eof(keyunit) do begin
      line = ""
      readf,keyunit,line
      ;print,line
      key = stregex(line,'^[A-Z][^ ]+',/Extract)
      if key ne '' then begin
          abpos= strpos(key,'<A|B>')
          ipos = strpos(key,'i')
          if abpos ge 0 then begin
              test_waven_keyword, outunit,prihead, strmid(key,0,abpos) + 'A' + strmid(key,abpos+5),tabs
              test_waven_keyword, outunit,prihead, strmid(key,0,abpos) + 'B' + strmid(key,abpos+5),tabs
          endif else if ipos ge 0 then begin
              test_waven_keyword, outunit,prihead, strmid(key,0,ipos) + '1' + strmid(key,ipos+1),tabs
              test_waven_keyword, outunit,prihead, strmid(key,0,ipos) + '2' + strmid(key,ipos+1),tabs
          endif else begin
              test_waven_keyword, outunit,prihead, key, tabs
          endelse
      endif
  endwhile
  close,keyunit & free_lun,keyunit

  printf,outunit,'\hline'
  printf,outunit,'\end{longtable}'

  ;;;;; IMAGING_DATA

  printf,outunit,''
  printf,outunit,'The following table contains averaged columns from the'
  printf,outunit,'IMAGING\_DATA\_FSUA, IMAGING\_DATA\_FSUB and/or IMAGING\_DATA\_FSUAB tables:'
  printf,outunit,''
  printf,outunit,'\begin{tabular}{lrrrrr}'
  if (where(exts eq 'IMAGING_DATA_FSUA'))[0] le -1 then begin
     printf,outunit,'\noalign{Table IMAGING\_DATA\_FSUA does not exist.}'
     printf,outunit,''
  endif else $
     test_fsu, outunit, 'FSUA', lvl1.imaging_data_FSUA->readrows()

  if (where(exts eq 'IMAGING_DATA_FSUB'))[0] le -1 then begin
     printf,outunit,'\noalign{Table IMAGING\_DATA\_FSUB does not exist.}'
     printf,outunit,''
  endif else $
      test_fsu, outunit, 'FSUB', lvl1.imaging_data_FSUB->readrows()

  if (where(exts eq 'IMAGING_DATA_FSUAB'))[0] le -1 then begin
     printf,outunit,'\noalign{Table IMAGING\_DATA\_FSUAB does not exist.}'
     printf,outunit,''
  endif else begin
     data = lvl1.imaging_data_FSUAB->readrows()
     if N_elements(data) gt 1 then begin
        printf,outunit,'\hline'
        printf,outunit,'IMAGING\_DATA\_FSUAB\span\span\span\\'
        printf,outunit,'\hline'
        printf,outunit,'	             	   & Channel 1 & Channel 2 & Channel 3 & Channel 4 & Channel 5\\'
        print_mean_row,outunit,'Real part of cross visib.  ','F7.5', data.cross_vis_real
        print_mean_row,outunit,'Imag.\ part of cross visib.','E8.1', data.cross_vis_imag
        print_mean_row,outunit,'Differential phase         ','E8.1', data.diff_phase
        printf,outunit,'\hline'
     endif
  endelse
  printf,outunit,'\end{tabular}'
  printf,outunit,''

  ;; check whether MAIN_DELAY table exists
  if ((where(tag_names(lvl0) eq 'MAIN_DELAY'))[0] gt -1) then begin

     data0= lvl0.main_delay->readrows()
     data1= *tabs.main_delay

     if !d.name eq "PS" then device,/color,/lands,file=outfile+'main_delay.ps'

     tek_color
     plot, data0.time/1d6, data0.delay2, xrange=[0,20], xtitle="Time [seconds]", ytitle="Main Delay [m]"
     oplot,data1.time_ave, data1.fit, psym=1, color=3 ;, symsize=3

     ymax= !Y.crange[1]
     oplot, [15,15.8], [ymax-0.02,ymax-0.02]	& xyouts,16,ymax-0.022, "level 0 data"
     oplot, [15.4],    [ymax-0.03], psym=1,color=3 & xyouts,16,ymax-0.032, "level 1 data"

     if !d.name eq "PS" then begin
        device,/close
        print,'ps2pdf '+outfile+'main_delay.ps'
        spawn,'ps2pdf '+outfile+'main_delay.ps'
     endif
     ;;printf,outunit,'If this page is empty, then it was unintenionally left blank.'
     printf,outunit,'\newpage'
     printf,outunit,'Table MAIN\_DELAY'
     printf,outunit,'\begin{center}'
     printf,outunit,'\includegraphics[angle=180,width=0.9\textwidth]{../sciave/'+outfile+'main_delay.pdf}'
     printf,outunit,'\end{center}'
  endif else begin
     printf,outunit,'Table MAIN\_DELAY does not exist.'
     printf,outunit,''
  endelse

  data0= lvl0.metrology_data->readrows()
  data1= *tabs.primet

  if !d.name eq "PS" then device,/color,/lands,file=outfile+'metrology.ps'

  tek_color
  plot, data0.time/1d6, data0.deltal*1d6, xrange=[0,20], ystyle=16,$
    xtitle="Time [seconds]", ytitle="Metrology Delta L [micron]", psym=3
  oplot,data1.time_ave, data1.fit*1d6, color=3, thick=3
  oplot,data1.time_ave, data1.fit*1d6, color=3, psym=1, symsize=2

  ymax= !Y.crange[1]
  h   = !Y.crange[1]-!Y.crange[0]
  ;;print,"ymax=",ymax,"h=",h
  oplot,[1.2,1.8],ymax-h*[0.05,0.05]		 & xyouts,2.,ymax-h*0.06, "level 0 data"
  oplot, [1.5],   ymax-h*[0.09], psym=1, color=3 & xyouts,2.,ymax-h*0.10, "level 1 data"

  if !d.name eq "PS" then begin
     device,/close
     print,'ps2pdf '+outfile+'metrology.ps'
     spawn,'ps2pdf '+outfile+'metrology.ps'
  endif
  printf,outunit,'Table METROLOGY\_DELAY'
  printf,outunit,'\begin{center}'
  printf,outunit,'\includegraphics[angle=180,width=0.9\textwidth]{../sciave/'+outfile+'metrology.pdf}'
  printf,outunit,'\end{center}'

  close,outunit & free_lun,outunit
  for t=0,N_elements(tags)-1 do ptr_free,tabs.(t)

  fbt_close, lvl0
  fbt_close, lvl1
end

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

PRO prima_sciave

  file = file_search('PACMA.2008-04-01T04:1*_LEVEL1.fits')
  if N_elements(file) lt 3 then begin
     print,"Not enough files:",file
     return
  endif

  ;print,"Reading ",file[0] & lvl1a= fbt_open(file[0])
  ;print,"Reading ",file[1] & lvl1b= fbt_open(file[1])
  ;print,"Reading ",file[2] & lvl1c= fbt_open(file[2])

  priheads= objarr(3)

  for i=0,2 do begin
     print,format='("File ",I1," = ",A)',i+1,file[i]
     openr,lun,file[i],/get_lun
     priheads[i]= obj_new('fitsheader',lun)
     close,lun
     free_lun,lun
  endfor

  ;;print,file[0],file[1],file[2]

  for ch=1,5 do begin
     real= string(format="('FSUAB CROSS_VIS_REAL',I1,' AVE')",ch)
     print,format='(A,":",$)',real
     for i=0,2 do print,format='(" ",F15.12,$)',priheads[i]->getpar(real)
     print
     imag= string(format="('FSUAB CROSS_VIS_IMAG',I1,' AVE')",ch)
     print,format='(A,":",$)',imag
     for i=0,2 do print,format='(" ",F15.12,$)',priheads[i]->getpar(imag)
     print
  endfor

  ;; offset crapection

  file = file_search('PACMA.2008-04-01T04:1*_LEVEL2.fits')
  if N_elements(file) lt 3 then begin
     print,"Not enough files:",file
     return
  endif
  for i=0,2 do begin
     obj_destroy,priheads[i]
     ;;print,format='("File ",I1," = ",A)',i,file[i]
     openr,lun,file[i],/get_lun
     priheads[i]= obj_new('fitsheader',lun)
     close,lun
     free_lun,lun
  endfor
  offs= 'QC DD OFFSET_CORR'
  print,format='(A25,":",$)',offs
  for i=0,2 do print,format='(" ",G15.9,$)',priheads[i]->getpar(offs)
  print

  ;;fsu= lvl1.iMaging_dAta_fSuA->readrows()
  ;;phaseA= total(fsu.phase,2) / N_elements(fsu)
  ;;
  ;;fsu= lvl1.iMaging_dAta_fSuB->readrows()
  ;;phaseB= total(fsu.phase,2) / N_elements(fsu)
  ;;
  ;;   print,"Phase A:",phasea
  ;;   print,"Phase B:",phaseB
  ;;   fbt_close, lvl1

end

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

PRO test_sciave
  test_sciave_file, 'PACMA.2008-04-01T04:26', FILE="bothtrack_"
  test_sciave_file, 'PACMA.2008-04-01T05:26', FILE="onetrack_"
  test_sciave_file, 'PACMA.2008-04-01T06:2', FILE="FSUA_"
  test_sciave_file, 'PACMA.2008-04-01T07:2', FILE="FSUB_"
end
