;
; test_scired1.pro
; Created:     Fri Sep 21 00:07:51 2007 by Koehler@Six
; Last change: Mon May  2 11:50:07 2011
;
; Copyright 2008 Rainer Koehler
;
; This file is part of Pacmart.
;
; Pacmart is free software; you can redistribute it and/or modify
; it under the terms of the GNU General Public License as published by
; the Free Software Foundation; either version 2 of the License, or
; (at your option) any later version.
;
; Pacmart is distributed in the hope that it will be useful,
; but WITHOUT ANY WARRANTY; without even the implied warranty of
; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
; GNU General Public License for more details.
;
; You should have received a copy of the GNU General Public License
; along with Pacmart; if not, write to the Free Software
; Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
;
;
pro test_envcorr, outunit, tabname, expect, comput

  color = (abs((expect-comput)/expect) lt 1d-5) ? 'green' : 'red'
  printf,outunit,FORMAT='(A,"	& ",F0,"	& \reportonly{",F0,"	& \color{",A,"}",F0,"}\\")',$
    tabname, expect, comput, color, expect-comput
end


PRO test_scired1, basename, FILE=outfile

  common PACSIM_DEFAULTS	;; kappa_center

  if N_elements(basename) lt 1 then basename= 'PACMA.2008-04-01T0'
  if not keyword_set(outfile) then outfile="scired1_testresults.tex"

  file = file_search(basename+'*LEVEL2.fits')
  if file[0] eq '' then begin
      print,"No file found matching "+basename+'*_LEVEL2.fits'
      return
  end
  print,"files: ",file

  print,"Reading ",file[0]
  lvl2 = fbt_open(file[0])

  openw,outunit,outfile,/get_lun
  printf,outunit,"%% scired1 testresults"
  printf,outunit,""
  printf,outunit,'{\bf Input data}:'
  printf,outunit,'\begin{verbatim}'
  printf,outunit,'Size     Creation date        Filename'
  close,outunit & free_lun,outunit

  infile= file_search(basename+'*LEVEL1.fits')
  infile= infile[0]
  spawn,'ls -l '+infile+" | sed -e 's/^.*users //'"
  spawn,'ls -l '+infile+" | sed -e 's/^.*users //' >> "+outfile

  openw,outunit,outfile,/get_lun,/APPEND
  printf,outunit,'\end{verbatim}'
  printf,outunit,''
  printf,outunit,'The environment trend corrections are currently set to zero to avoid'
  printf,outunit,'problems in the test of {\tt pacma\_scired2} to {\tt 42}.'
  printf,outunit,''

  sof = strmid(file[0],0, strlen(file[0])-strlen("L2.fits"))+'L1'
  sof = sof[0]
  printf,outunit,'{\bf Set of Frames}:'
  printf,outunit,'\verbatiminput{../sciave/'+sof+'.sof}'
  printf,outunit,''
  printf,outunit,'The {\tt STARSPEC} files were not created by the \verb|pacma_starspewctrum| recipe.'
  printf,outunit,'They contain a flat star spectrum to make the effective wavenumbers identical to'
  printf,outunit,'the central wavenumbers of the FSU channels.'

  print_cmd_stuff, outunit, 'scired1', '../sciave/'+sof+'.out', CMDSEARCH=sof
  list_fbt_extensions,outunit,lvl2

  printf,outunit,'\smallskip'
  printf,outunit,''
  printf,outunit,'%\clearpage'
  printf,outunit,'{\bf Output Data Contents}:\\'
  printf,outunit,''
  printf,outunit,'{\bf Primary Header}: The following table contains the QC-keywords in the primary header.'
  printf,outunit,'\reportonly{For the keywords containing effective wavenumbers, the expected value and the difference'
  printf,outunit,'are also computed.  Differences within acceptable limits are printed in {\color{green}green}.}'
  printf,outunit,'\begin{longtable}{lccc}'
  printf,outunit,'Keyword & Value & \reportonly{Expected & Difference}\\'
  printf,outunit,'\hline\endhead'
  printf,outunit,'\hline\endfoot'

  prihead= lvl2.fileobj->prihead()
  keywords= prihead->sthead()

  for k=0,N_elements(keywords)-1 do begin
      ;;print,k,keywords[k]
      key = stregex(keywords[k],'^HIERARCH ESO QC [A-Z0-9_ ]+[A-Z0-9_]',/Extract)
      if key ne '' then begin
          ;;print,"key ",key
          val = prihead->getpar(key)
          key = strmid(key,13)
          key = strjoin( strsplit(key,'_',/Extract),'\_')
          key = strjoin( strsplit(key,' ',/Extract),'.')

          if strmatch(key,'QC.EFFWAVE.*[0-5]') then begin
              ch   = stregex(key,'[0-5]$',/Extract)
              waven= kappa_center[ch]	;; 1./ ((2.5 - ch/10.) * 1d-6)
              diff = val-waven
              color = (abs(diff/waven) lt 1d-3) ? 'green' : 'red'
              ;;print,"channel ",ch,waven,diff
              ;;printf,outunit, key,'	& ',val,'	& ',waven,' & \color{',color,'}',diff,' \\'
              printf,outunit, key,val,waven,color,diff,$
                Format= "(A,'	& ',F8.1,' & \reportonly{',F8.1,' & \color{',A,'}',F7.1,'}\\')"
           endif else if strmatch(key,'QC.ENV_CORR.*') then begin
              color = (abs(val) lt 1d-6) ? 'green' : 'red'
              printf,outunit, key,val,0.,color,val,$
                Format= "(A,'	& ',F8.1,' & \reportonly{',F8.1,' & \color{',A,'}',F6.1,'}\\')"
          endif else begin
              printf,outunit, key,'	& ',val,'	\\'
          endelse
      endif
  end

  printf,outunit,'\hline'
  printf,outunit,'\end{longtable}'
  printf,outunit,'\bigskip'

  file = file_search(basename+'*LEVEL1E.fits')

  print,"Reading ",file[0]
  lvl1e = fbt_open(file[0])

  mdltab = lvl2.main_delay->readrows()
  ddltab = lvl2.diff_delay->readrows()
  mettab = lvl2.delay_fsub->readrows()
  envtab = lvl1e.environment->readrows()
  envtab = envtab[where(envtab.sensor eq 41)]	;; params should be loaded from the parrot-file

  printf,outunit,'{\bf Data tables:}\\'
  printf,outunit,'\reportonly{\vbox{Dispersion corrections:\\'
  printf,outunit,'\smallskip'
  printf,outunit,'\begin{tabular}{lcc}'
  printf,outunit,'	& Expected & Maximum\\'
  printf,outunit,'\hline'

  if tag_exists(mdltab,'disp_corr') then $
     printf,outunit,'LEVEL2\_Main\_Delay	& ',0.0,'	& ',max(mdltab.disp_corr),'\\'
  if tag_exists(ddltab,'offset') then $
     printf,outunit,'LEVEL2\_Diff\_Delay	& ',0.0,'	& ',max(ddltab.offset)   ,'\\'
  if tag_exists(mettab,'disp_corr') then $
     printf,outunit,'LEVEL2\_PRIMET\_FSUB	& ',0.0,'	& ',max(mettab.disp_corr),'\\'

  printf,outunit,'\hline'
  printf,outunit,'\end{tabular}}}'
  printf,outunit,'\bigskip'
  printf,outunit,''

  printf,outunit,'\vbox{Environment (trend) corrections:\\'
  printf,outunit,'\smallskip'
  printf,outunit,'\begin{tabular}{lccc}'
  printf,outunit,'	& Expected & \reportonly{Computed & Difference}\\'
  printf,outunit,'\hline'

  printf,outunit,'Start of observation:\\'
  test_envcorr, outunit, "Main\_Delay", (envtab[0].value-10.)*0.001, mdltab[0].env_corr
  test_envcorr, outunit, "Diff\_Delay", (envtab[0].value-10.)*2.d-4, ddltab[0].env_corr
  test_envcorr, outunit, "PRIMET\_FSUB",(envtab[0].value-10.)*5.d-4, mettab[0].env_corr

  printf,outunit,'\hline'
  printf,outunit,'End of observation:\\'
  idx= N_elements(mdltab)-1

  test_envcorr, outunit, "Main\_Delay", (envtab[idx].value-10.)*0.001, mdltab[idx].env_corr
  test_envcorr, outunit, "Diff\_Delay", (envtab[idx].value-10.)*2.d-4, ddltab[idx].env_corr
  test_envcorr, outunit, "PRIMET\_FSUB",(envtab[idx].value-10.)*5.d-4, mettab[idx].env_corr

  printf,outunit,'\hline'
  printf,outunit,'\end{tabular}}'


  close,outunit & free_lun,outunit

  fbt_close,lvl1e
  fbt_close,lvl2
end

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

pro old_test_scired1_offset, basename

  file0 = file_search(basename+'*0.fits')
  if file0[0] eq '' then begin
      print,"No file found matching "+basename+'*0.fits'
      return
  end
  print,"Reading ",file0[0]
  lvl0 = fbt_open(file0[0])
  fsua = lvl0.imaging_data_fsua->readrows()
  fsub = lvl0.imaging_data_fsub->readrows()
  fsub = fsub[ indgen(N_elements(fsua))*N_elements(fsub)/N_elements(fsua)]

  print,"Raw data, Mean Phase FsuA / FsuB"
  phase= fltarr(10,N_elements(fsua))
  for ch=0,4 do begin
     phase[ch  ,*]= atan( float(fsua.data2[ch]-fsua.data4[ch]), float(fsua.data1[ch]-fsua.data3[ch]))*180./!pi
     phase[ch+5,*]= atan( float(fsub.data2[ch]-fsub.data4[ch]), float(fsub.data1[ch]-fsub.data3[ch]))*180./!pi
     print, ch, mean(phase[ch,*]), mean(phase[ch+5,*])
  endfor

  tek_color
  plot, fsua.time, phase[0,*], yrange=[min(phase,max=max)-2.,max+2.], $
        xtitle="Time [PRIMA units]", ytitle="Phase [deg]", /yst
  for ch=1,9 do oplot, fsua.time, phase[ch,*], color=ch+1

  fbt_close, lvl0
  ;;
  ;;
  file1 = file_search(basename+'*L1.fits')
  if file1[0] eq '' then begin
      print,"No file found matching "+basename+'*L1.fits'
      return
  end
  print,"Reading ",file1[0]
  lvl1 = fbt_open(file1[0])
  prihead= lvl1.fileobj->prihead()
  fsua = lvl1.imaging_data_fsua_aVe->readrows()
  fsub = lvl1.imaging_data_fsub_aVe->readrows()

  ;;help,fsua[0],/str

  print,"Level 1, mean phase fusa / fsub"
  kappa = 1./[2.5, 2.4, 2.3, 2.2, 2.1]	;; double 1/microns, wavenumber VECTOR

  plot, kappa, replicate(1,5), xrange=[0,0.5], yrange=[-10,36],/nodata

  for ch=0,4 do begin
     real= prihead->getpar('HIERARCH ESO QC FSUAB CROSS_VIS_REAL'+strtrim(ch+1,2)+' AVE')
     imag= prihead->getpar('HIERARCH ESO QC FSUAB CROSS_VIS_IMAG'+strtrim(ch+1,2)+' AVE')
     phase= atan(imag,real) * 180./!dpi

     ph_A= mean(fsua.phase[ch])*180./!pi
     ph_B= mean(fsub.phase[ch])*180./!pi
     oplot, [0,kappa[ch]], [0,ph_A], color=ch+1
     oplot, [0,kappa[ch]], [0,ph_B], color=ch+6
     print, ch, ph_A/360./kappa[ch], ph_B/360./kappa[ch], phase
  endfor
  fbt_close, lvl1
  ;;
  ;;
  file2 = file_search(basename+'*L2.fits')
  if file2[0] eq '' then begin
      print,"No file found matching "+basename+'*L2.fits'
      return
  end
  print,"Reading ",file2[0]
  lvl2 = fbt_open(file2[0])
  l2dd = lvl2.level2_diff_delay->readrows()

  ;;help,l2dd,/str

  ;;print, l2dd.offset*360./2.1d-6
  oplot, l2dd.time_ave*1d6, l2dd.offset*360./2.1d-6, psym=2, color=6
  moffs= mean(l2dd.offset)
  print, "Mean offset: ",moffs,' m =',moffs*360./2.1d-6, " deg for wavelength 2.1 micron"

  fbt_close, lvl1
end


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

pro test_scired1_dispersion, basename

  if !d.name eq "PS" then device,/color,/lands,file='dispcorr_metroB.ps'

  file = file_search(basename+'*L2.fits')
  if file[0] eq '' then begin
      print,"No file found matching "+basename+'*L2.fits'
      return
  end
  print,"Reading ",file[0]
  lvl2 = fbt_open( file[0])
  MJD0 = (lvl2.fileobj->prihead())->getpar('MJD-OBS')
  pmtb = lvl2.delay_fsuB->readrows()
  fbt_close, lvl2

  tek_color

  plot, pmtb.time_ave, pmtb.disp_corr, /yst, xtitle='Time [sec]', ytitle='Dispersion Correction [m]'
  oplot,pmtb.time_ave, pmtb.disp_corr, psym=1, color=2

  dispf = disperse_metroB(MJD0,pmtb.time_ave)
  dispco_exp = pmtb.fit * (1.d - 1.d/dispf)

  oplot, pmtb.time_ave, dispco_exp, color=3
  ;;print, pmtb[0].disp_corr, dispco_exp[0]

  if !d.name eq "PS" then begin
     device,/close
     print,'ps2pdf dispcorr_metroB.ps'
     spawn,'ps2pdf dispcorr_metroB.ps'
  endif
end

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

pro test_scired1_offset, basename

  if N_elements(basename) le 0 then basename= 'PACMA.2008-04-01T0' ;;'[67]'

  if !D.name eq 'PS' then device,/lands,file='scired1_phases.ps'

  outfile= 'scired1_offset_test.tex'

  files= file_search(basename+'*L2.fits')
  if files[0] eq '' then begin
      print,"PRO test_scired1_offset: No file found matching "+basename+'*L2.fits'
      return
  end

  openw,outunit,outfile,/get_lun
  printf,outunit,"%% scired1 offset testresults"
  printf,outunit,""
  printf,outunit,'\begin{tabular}{lccc}'
  printf,outunit,'Filename	& Expected [$\mu$m] & Computed [$\mu$m] & Difference [$\mu$m]\\'
  printf,outunit,'\hline'

  mu = string("265B)	;; octal constant starts with "

  plot, [0.36, 0.52], [-90,90], /nodata, xtitle='Wavenumber ['+mu+'m!u-1!d]', ytitle='DIFF_PHASE [deg]'
  kappa = fltarr(6)
  phases= fltarr(6)
  offs_expect= dblarr(N_elements(files))
  offs_cooked= dblarr(N_elements(files))

  for iFile= 0,N_elements(files)-1 do begin
     ;;print,"Reading ",files[iFile]
     lvl2 = fbt_open( files[iFile])
     ddlay= lvl2.diff_delay->readrows()

     prihead= lvl2.fileobj->prihead()
     file1= prihead->getpar('HIERARCH ESO PRO REC1 CAL1 NAME')

     lvl1 = fbt_open(file1)
     head= lvl1.imaging_data_fsua->head()

     deloff= head->getpar('HIERARCH ESO SIM DELOFF FSUA')
     for ch=0,5 do begin
        kappa[ch]= head->getpar('HIERARCH ESO SIM WAVENO'+strtrim(ch,2))/1e6	;; 1/mu
     end

     offset_expect= deloff/360./kappa[0]	;; mircon
     offset_cooked= mean(ddlay.offset)*1d6	;; micron
     offset_diff = abs(offset_expect)-abs(offset_cooked)

     offs_expect[iFile]= offset_expect
     offs_cooked[iFile]= offset_cooked

     print, files[iFile], offset_expect, offset_expect,' [micron]'
     printf,outunit,'\verb|',files[iFile],'| & '
     printf,outunit,offset_expect,' & ',offset_cooked,' & \color{',(abs(offset_diff) le 1e-2? 'green':'red'),'}',offset_diff,'\\'

     for ch=0,5 do begin
        name= string(format='("HIERARCH ESO QC FSUAB DIFF PHASE",I1," AVE")',ch)
        phases[ch]= (lvl1.fileobj->prihead())->getpar(name) * 180/!pi
        print,name
     endfor
     print,phases
     oplot, kappa, phases, psym=1
     oplot, kappa[1:5], phases[1:5], linestyle=1
     XYouts, kappa[5], phases[5], 'Offset = '+string(format='(F6.4)',offset_expect)+mu+'m  ', align=1.

     fbt_close, lvl2
     fbt_close, lvl1
  endfor
  printf,outunit,'\hline'
  printf,outunit,'\end{tabular}'
  printf,outunit,'\bigskip'
  printf,outunit,''

  if !D.name eq 'PS' then begin
     device,/close
     print,'ps2pdf scired1_phases.ps'
     spawn,'ps2pdf scired1_phases.ps'
     if !D.name eq 'PS' then device,/lands,file='scired1_offset.ps'
  endif
  plot, abs(offs_cooked),psym=1, ytitle='Offset ['+mu+'m]'
  oplot,offs_expect
  if !D.name eq 'PS' then begin
     device,/close
     print,'ps2pdf scired1_offset.ps'
     spawn,'ps2pdf scired1_offset.ps'
  endif

  printf,outunit,'The figure shows the expected and computed offsets.'
  printf,outunit,'The expected offsets are marked by the line, while the computed offsets are denoted by plus symbols.'
  printf,outunit,'Note that the absolute values are shown to avoid the unavoidable confusion about signs.'
  printf,outunit,''
  printf,outunit,'\includegraphics[angle=180,width=0.9\textwidth]{../scired1/scired1_offset.pdf}'
  printf,outunit,''
  printf,outunit,'The next figure shows the DIFF\_PHASEs as a function of wavelength.'
  printf,outunit,'They show the behaviour expected for the offsets in the simulated data.'
  printf,outunit,'Note that the sign of the differential phase changes when primary and secondary star are swapped.'
  printf,outunit,''
  printf,outunit,'\includegraphics[angle=180,width=0.9\textwidth]{../scired1/scired1_phases.pdf}'

  close,outunit & free_lun,outunit
end
