;
; test_scired3.pro
; Created:     Mon Jul  9 11:58:16 2007 by Rkoehler@lx40
; Last change: Wed Jul  1 10:55:57 2009
;
; Copyright 2008 Rainer Koehler
;
; This file is part of Pacmart.
;
; Pacmart is free software; you can redistribute it and/or modify
; it under the terms of the GNU General Public License as published by
; the Free Software Foundation; either version 2 of the License, or
; (at your option) any later version.
;
; Pacmart is distributed in the hope that it will be useful,
; but WITHOUT ANY WARRANTY; without even the implied warranty of
; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
; GNU General Public License for more details.
;
; You should have received a copy of the GNU General Public License
; along with Pacmart; if not, write to the Free Software
; Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

PRO test_scired3, basename, FILE=outfile

  if N_elements(basename) lt 1 then basename= 'PACMA.2008-04-*T00:1'
  if not keyword_set(outfile) then outfile="scired3_"

  openw,outunit,outfile+'testresults.tex',/get_lun
  printf,outunit,'%% '+outfile+'testresults.tex'
  printf,outunit,"%% scired3 testresults"
  printf,outunit,""
  printf,outunit,'{\bf Input data}:'
  printf,outunit,'\begin{verbatim}'
  printf,outunit,'Size     Creation date        Filename'
  close,outunit & free_lun,outunit

  spawn,"ls -l "+basename+"*LEVEL3.fits | sed -e 's/^.*users //'"
  spawn,"ls -l "+basename+"*LEVEL3.fits | sed -e 's/^.*users //' >> "+outfile+'testresults.tex'

  openw,outunit,outfile+'testresults.tex',/get_lun,/APPEND
  printf,outunit,'\end{verbatim}'
  printf,outunit,''

  file = file_search('PACMA_COCO_DIFFCAT.fits')
  if file[0] eq '' then begin
      print,"PACMA_COCO_DIFFCAT.fits not found"

      file= file_search(basename+"*.000.fits")
      if file[0] eq '' then begin
          print,"No input file found, I give up"
          close,outunit & free_lun,outunit
          return
      endif
      infile = file[0]
  end else begin
     ;; currently unlikely
     print,"files: ",file
     print,"Reading ",file[0]
     dcat= fbt_open(file[0])

     prihead= dcat.fileobj->prihead()
     infile = prihead->getpar('PRO REC1 CAL1 NAME')
     infile = strmid(infile,0, strlen(infile)-strlen("_LEVEL3.fits"))+'.fits'
  endelse

  print, "infile is ",infile
  lvl0= fbt_open(infile)

  sof = strmid(infile,0, strlen(infile)-strlen(".fits"))
  sof = sof[0]
  printf,outunit,'{\bf Set of Frames}:'
  printf,outunit,'\verbatiminput{../scired3/'+sof+'_LEVEL3.sof}'
  printf,outunit,''
  printf,outunit,'The simulation consists of two stars.'
  ;printf,outunit,"The first one (``Prima'') is located at RA 0, Dec 0,"
  ;printf,outunit,'and has a proper motion of (as of 11-Nov-08) 0.0 arcsec/year in RA.'
  ;printf,outunit,"The second one (``Secunda'') is at RA 0, Dec 0 arcsec,"
  ;printf,outunit,'and has a proper motion of $0.0$ arcsec/yr in Dec.'
  ;printf,outunit,'The parallax of both stars is zero.'
  printf,outunit,'The positions, proper motions, and parallaxes of the two stars are stored'
  printf,outunit,'in the FITS header and listed in the following table.'
  printf,outunit,'The positions are known perfectly, there is no difference between the positions'
  printf,outunit,'listed in the FITS header and the positions used to simulate the OPD and DOPD.'
  printf,outunit,''
  printf,outunit,'%\includegraphics[width=\textwidth]{../scired3/coordinates.jpg}'
  printf,outunit,''
  printf,outunit,'{\bf Simulation Parameters}:'
  printf,outunit,'\begin{longtable}{lll}'
  printf,outunit,'Parameter & Value & Comment\\'
  printf,outunit,'\hline\endhead'
  printf,outunit,'\hline\endfoot'

  prihead= lvl0.fileobj->prihead()
  print_header_keywords, outunit, prihead, '^HIERARCH ESO ISS PRI FSU[1-4] STATE'
  print_header_keywords, outunit, prihead, '^HIERARCH ESO OCS TARG[1-4] [A-Z0-9]+', SKIP=13

  if prihead->getpar('HIERARCH ESO ISS PRI FSU2 DIT') ne 0 then begin
     print,"FSU2 is on, using FSUA"
     head= lvl0.imaging_data_fsuA->head()
  endif else begin
     print,"FSU2 is off, using FSUB"
     head= lvl0.imaging_data_fsuB->head()
  endelse

  print_header_keywords, outunit, head, '^HIERARCH ESO SIM [A-Z0-9_ ]+[A-Z0-9_]'
  print_header_keywords, outunit,lvl0.metrology_data->head(),'^HIERARCH ESO SIM [A-Z0-9_ ]+[A-Z0-9_]'

  printf,outunit,'\hline'
  printf,outunit,'\end{longtable}'
  printf,outunit,'\bigskip'

  print_cmd_stuff, outunit, 'scired3', '../scired3/'+sof+'_LEVEL3.out'
  ;;
  ;; check if there's an output file that we can test
  ;;
  if N_elements(dcat) le 0 then begin
     printf,outunit,'The recipe did not produce an output file.'
     close,outunit & free_lun,outunit
     fbt_close, lvl0
     return
  endif

  list_fbt_extensions,outunit,dcat
  printf,outunit,'\smallskip'
  printf,outunit,''
  printf,outunit,'%\clearpage'
  printf,outunit,''
  printf,outunit,'{\bf Intermediate Results (LEVEL3 files)}:\\'

  files3 = file_search('PAC*LEVEL3.fits')
  for iFile=0,N_elements(files3)-1 do begin
     fname= files3[iFile]
     print,'File ',iFile,': ',fname
     printf,outunit,'\vbox{File ',iFile+1,': \verb|',fname,'|'

     fname= strjoin( strsplit( strmid(fname,0,strlen(fname)-5), '.',/Extract),'_')

     if !D.name eq 'PS' then device,/color,/lands,file=fname+'.ps'
     lvl3 = fbt_open(files3[iFile])
     l3sr = lvl3.science_result->readrows()
     l3sr = l3sr[indgen(N_elements(l3sr)/50-1)*50]	;; every 10th point

     ymax= max([ l3sr.total_lvl2,l3sr.dopd_model, l3sr.diff_delay], min= ymin)
     xmax= max( l3sr.time_ave, min= xmin)
     xr= (xmax-xmin)/10	 &  xmin -= xr  & xmax += xr

     tek_color
     plot, l3sr.time_ave[0], l3sr.total_lvl2[0], xtitle='TIME_AVE [sec]',/xstyle,$
           yrange=[ymin,ymax], xrange=[xmin,xmax], psym=4
     oplot,l3sr.time_ave[0], l3sr.dopd_Model,	   psym=1, color=2
     oplot,l3sr.time_ave[0], l3sr.no_instr_calc,   psym=5, color=3
     oplot,l3sr.time_ave[0], l3sr.with_instr_calc, psym=6, color=4
     oplot,l3sr.time_ave[0], l3sr.diff_delay,	   psym=7, color=5
     fbt_close,lvl3

     xx = xmin+xr/2
     ystep = (ymax-ymin)/20.
     plots, xx,ymax-ystep  , psym=4		& XYouts, xx+10,ymax-ystep,  "TOTAL_LVL2"
     plots, xx,ymax-ystep*2, psym=1,color=2	& XYouts, xx+10,ymax-ystep*2,"DOPD_MODEL",color=2
     plots, xx,ymax-ystep*3, psym=5,color=3	& XYouts, xx+10,ymax-ystep*3,"NO_INSTR_CALC",color=3
     plots, xx,ymax-ystep*4, psym=6,color=4	& XYouts, xx+10,ymax-ystep*4,"WITH_INSTR_CALC",color=4
     plots, xx,ymax-ystep*5, psym=7,color=5	& XYouts, xx+10,ymax-ystep*5,"DIFF_DELAY",color=5

     if !d.name eq "PS" then begin
        device,/close
        print,'ps2pdf '+fname+'.ps'
        spawn,'ps2pdf '+fname+'.ps'
     endif
     printf,outunit,'\begin{center}'
     printf,outunit,'\includegraphics[angle=180,width=0.8\textwidth]{../scired3/'+fname+'.pdf}'
     printf,outunit,'\end{center}}'
     printf,outunit,'\bigskip'
  endfor

  printf,outunit,''
  printf,outunit,'\clearpage'
  printf,outunit,'{\bf Output Data Contents}:\\'
  printf,outunit,'\medskip'

  head= dcat.differential_catalog->head()
  tab = dcat.differential_catalog->readrows()

  ;; this is (un)like dump_table_structure

  printf,outunit,'\begin{tabular}{lcll}'
  printf,outunit,'\hline\noalign{\vspace{2pt}}'
  printf,outunit,'Column Name & Data Type & Value & Unit \\'
  printf,outunit,'\hline\noalign{\vspace{2pt}}'
  tnames= tag_names(tab)
  for i=0,N_Tags(tab)-1 do begin
     N = N_elements(tab[0].(i))
     Nstr= N gt 1 ? strtrim(N,2) : ''
     tname= strjoin( strsplit(tnames[i],'_',/Extract),'\_')
     tunit= head->getpar('TUNIT'+strtrim(i+1,2))
     print,"unit of ",tname,': ',tunit,'.'
     if size(tunit,/TName) eq 'INT' then tunit=''

     printf,outunit,'        '+tname+'	& '+Nstr+' '+strlowcase(size(tab[0].(i),/tname))+$
            '	& '+string(tab[0].(i))+'	& $\rm '+tunit+'$\\'
  endfor
  printf,outunit,'\hline'
  printf,outunit,'\end{tabular}'
  printf,outunit,''

  close,outunit & free_lun,outunit

  fbt_close, lvl0
  fbt_close, dcat
end

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
