;
; test_skyback.pro
; Created:     Mon Jul  9 11:58:16 2007 by Rkoehler@lx40
; Last change: Thu Jun 25 17:05:43 2009
;
; Copyright 2008 Rainer Koehler
;
; This file is part of Pacmart.
;
; Pacmart is free software; you can redistribute it and/or modify
; it under the terms of the GNU General Public License as published by
; the Free Software Foundation; either version 2 of the License, or
; (at your option) any later version.
;
; Pacmart is distributed in the hope that it will be useful,
; but WITHOUT ANY WARRANTY; without even the implied warranty of
; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
; GNU General Public License for more details.
;
; You should have received a copy of the GNU General Public License
; along with Pacmart; if not, write to the Free Software
; Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

PRO test_skyback, basename, FILE=outfile

  if N_elements(basename) lt 1 then basename= 'PACMA.2008-04-01T01:0'
  if not keyword_set(outfile) then outfile="skyback_testresults"

  file = file_search(basename+"*_SKYBACK.fits")
  if file[0] eq '' then begin
      print,"No file found matching "+basename+'*_SKYBARK.fits'
      return
  end
  print,"files: ",file

  print,"Reading ",file[0]
  sb = fbt_open(file[0])

  openw,outunit,outfile+'.tex',/get_lun
  printf,outunit,'%% '+outfile+'.tex'
  printf,outunit,"%% Skybackground testresults"
  printf,outunit,""
  printf,outunit,'{\bf Input data}:'
  printf,outunit,'\begin{verbatim}'
  printf,outunit,'Size  Creation date        Filename'
  close,outunit & free_lun,outunit

  spawn,'ls -l '+basename+"*0.fits | sed -e 's/^.*users //'"
  spawn,'ls -l '+basename+"*0.fits | sed -e 's/^.*users //' >> "+outfile+'.tex'

  openw,outunit,outfile+'.tex',/get_lun,/APPEND
  printf,outunit,'\end{verbatim}'
  printf,outunit,''

  sof = strmid(file[0],0, strlen(file[0])-strlen('_SKYBACK.fits'))
  sof = sof[0]
  printf,outunit,'{\bf Set of Frames}:'
  printf,outunit,'\verbatiminput{../sky/'+sof+'.sof}'
  printf,outunit,''
  printf,outunit,''
  printf,outunit,'{\bf Simulation Parameters}:'
  printf,outunit,'\begin{longtable}{lll}'
  printf,outunit,'Parameter & Value & Comment\\'
  printf,outunit,'\hline\endhead'
  printf,outunit,'\hline\endfoot'

  head= sb.imAging_deTector_fsuA->head()
  keywords= head->sthead()

  for k=0,N_elements(keywords)-1 do begin
     ;;print,k,keywords[k]
     key = stregex(keywords[k],'^HIERARCH ESO SIM [A-Z0-9_ ]+[A-Z0-9_]',/Extract)
     if key ne '' then begin
        ;;print,"key ",key
        val = head->getpar(key,COMM=comment)
        key = strmid(key,17)	;; get rid of HIERARSCH ESO SIM
        key = strjoin( strsplit(key,'_',/Extract),'\_')
        key = strjoin( strsplit(key,' ',/Extract),'.')

        if strmatch(key,'QC.EFFWAVE.*') then begin
           ch   = stregex(key,'[0-4]$',/Extract)
           waven= 1./ ((2.1 + ch/10.) * 1d-6)
           diff = val-waven
           color = (abs(diff/waven) lt 1d-5) ? 'green' : 'red'
           ;;print,"channel ",ch,waven,diff
           printf,outunit, key,'	& ',val,'	& ',waven,' & \color{',color,'}',diff,' \\'
        endif else begin
           printf,outunit, key,'	& ',val,'	& ',comment,'	\\'
        endelse
     endif
  end

  printf,outunit,'\hline'
  printf,outunit,'\end{longtable}'
  printf,outunit,'%\bigskip'
  printf,outunit,''
  printf,outunit,'The parameter values used for the simulation are completely arbitrary.'
  printf,outunit,'Any similarity to real data is purely coincidental.'
  printf,outunit,''
  printf,outunit,'The simulated pixel values are normally distributed with a mean of'
  printf,outunit,'(BIASn + FLUXn $\times$ DIT) and a standard deviation of NOISEn.'
  printf,outunit,'BIAS and FLUX are set independently for each wavenumber channel,'
  printf,outunit,'but are the same for DATA1--4 within one wavenumber channel.'
  printf,outunit,'NOISE is the square root of FLUX for each pixel.'
  printf,outunit,'DIT is 1.0 seconds, 120 exposures are simulated.'
  printf,outunit,'\bigskip'

  print_cmd_stuff, outunit, 'skybackground', '../sky/'+sof+'.out'
  list_fbt_extensions, outunit, sb

  printf,outunit,'\bigskip'
  printf,outunit,''
  printf,outunit,'%\clearpage'
  printf,outunit,'{\bf Output Data Contents}:\\[5pt]'
  printf,outunit,'The important results are in tables'
  printf,outunit,'\verb|SKY_FSUA| and \verb|SKY_FSUB|, which have this structure:'
  printf,outunit,'\begin{center}'

  saa= sb.sky_FSUA->readrows()
  dump_table_structure, outunit, saa
  printf,outunit,'\end{center}'

  Nch = N_elements(saa[0].mean1)

  bias = fltarr(Nch)
  flux = fltarr(Nch)
  good = fltarr(Nch)

  dit  = (sb.sky_FSUA->prihead())->getpar('ISS PRI FSU1 DIT')
  for c=0,Nch-1 do begin
     bias[c] = head->getpar(string(format='("SIM BIAS",I1)',c+1))
     flux[c] = head->getpar(string(format='("SIM FLUX",I1)',c+1))
  endfor
  wahr = bias + flux*dit

  printf,outunit,'The results of the test are shown in these tables:'
  printf,outunit,''
  printf,outunit,'\begin{tabular}{lllllll}'
  printf,outunit,'\hline\noalign{\vspace{2pt}}'
  printf,outunit,'\span\span\span Background Flux per DIT in FSU A\span\span\\'
  printf,outunit,'\hline'
  printf,outunit,'Waveno.~Channel & 1 & 2 & 3 & 4 & 5 & 6\\'
  printf,outunit,Format='("True value",$)'
  for c=0,Nch-1 do $
     printf,outunit,Format='(" &",I5,$)',wahr[c]
  printf,outunit,'\\'

  tags = tag_names(saa[0])
  for t=0,3 do begin
      mtag = where(tags eq string(format='("MEAN" ,I1)',t+1))
      etag = where(tags eq string(format='("STDEV",I1)',t+1))

      printf,outunit,format='("MEAN",I1,"$\pm$STDEV",I1,$)',t+1,t+1
      for c=0,Nch-1 do begin
          b = (saa[0].(mtag))[c]
          be= (saa[0].(etag))[c]
          printf,outunit,Format='(" & $",F6.1,"\pm",F4.1,"$",$)',b,be
          sig = abs(wahr[c]-b)/be
          if (sig gt good[c]) then good[c] = sig
      endfor
      printf,outunit,"\\"
  endfor
  printf,outunit,'\reportonly{Result'
  for c=0,Nch-1 do $
    printf,outunit,Format='(" &",A0,$)',$
    ((good[c] le 4.) ? "\color{green}within err." : string(Format='(F7.2,"\,$\sigma$")',good[c]))
  printf,outunit,'\\}'

  sab= sb.sky_FSUB->readrows()

  dit  = (sb.sky_FSUB->prihead())->getpar('ISS PRI FSU2 DIT')
  for c=0,Nch-1 do begin
     bias[c]= (sb.imaging_detector_FSUB->head())->getpar(string(format='("SIM BIAS",I1)',c+1))
     flux[c]= (sb.imaging_detector_FSUB->head())->getpar(string(format='("SIM FLUX",I1)',c+1))
  endfor
  wahr = bias + flux*dit

  good = fltarr(Nch)	;; clear array

  printf,outunit,'\hline\hline\noalign{\vspace{2pt}}'
  printf,outunit,'\span\span\span Background Flux per DIT in FSU B\span\span\\'
  printf,outunit,'\hline'
  printf,outunit,'Waveno.~Channel & 1 & 2 & 3 & 4 & 5 & 6\\'
  printf,outunit,Format='("True value",$)'
  for c=0,Nch-1 do $
     printf,outunit,Format='(" &",I5,$)',wahr[c]
  printf,outunit,'\\'

  tags = tag_names(sab[0])
  for t=0,3 do begin
      mtag = where(tags eq string(format='("MEAN" ,I1)',t+1))
      etag = where(tags eq string(format='("STDEV",I1)',t+1))

      printf,outunit,format='("MEAN",I1,"$\pm$STDEV",I1,$)',t+1,t+1
      for c=0,Nch-1 do begin
          b = (sab[0].(mtag))[c]
          be= (sab[0].(etag))[c]
          printf,outunit,Format='(" & $",F6.1,"\pm",F4.1,"$",$)',b,be
          sig = abs(wahr[c]-b)/be
          if (sig gt good[c]) then good[c] = sig
      endfor
      printf,outunit,"\\"
  endfor
  printf,outunit,'\reportonly{Result'
  for c=0,Nch-1 do $
    printf,outunit,Format='(" &",A0,$)',$
    ((good[c] le 4.) ? "\color{green}within err." : string(Format='(F7.2,"\,$\sigma$")',good[c]))
  printf,outunit,'\\}'

  printf,outunit,'\hline'
  printf,outunit,'\end{tabular}'

  close,outunit & free_lun,outunit
  fbt_close, sb
end
