;
; test_starspectrum.pro
; Created:     Wed Nov  7 15:40:58 2007 by Rkoehler@lx40
; Last change: Tue Feb  9 16:31:33 2010
;
; Copyright 2008 Rainer Koehler
;
; This file is part of Pacmart.
;
; Pacmart is free software; you can redistribute it and/or modify
; it under the terms of the GNU General Public License as published by
; the Free Software Foundation; either version 2 of the License, or
; (at your option) any later version.
;
; Pacmart is distributed in the hope that it will be useful,
; but WITHOUT ANY WARRANTY; without even the implied warranty of
; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
; GNU General Public License for more details.
;
; You should have received a copy of the GNU General Public License
; along with Pacmart; if not, write to the Free Software
; Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

PRO test_starspectrum, basename, FILE=outfile, TEX=tex

  if not keyword_set(outfile) then outfile="Starspectrum_testresults"
  if N_elements(basename) lt 1 then basename= 'PACMA.*T03'

  file = file_search(basename+'*_STARSED.fits')
  if file[0] eq '' then begin
      print,"No file found matching "+basename+'*STARSED.fits'
      return
  end

  print,"Reading ",file[0]
  StSpec = fbt_open(file[0])

  prihead= StSpec.fileobj->prihead()
  startemp= prihead->getpar("SIM STAR TEMP")
  keywords= prihead->sthead()

  openw,outunit,outfile+'.tex',/get_lun
  printf,outunit,'%% '+outfile+'.tex'
  printf,outunit,"%% Starspectrum testresults"
  printf,outunit,""
  printf,outunit,'{\bf Input data}:'
  printf,outunit,'\begin{verbatim}'
  printf,outunit,'Size     Creation date        Filename'
  close,outunit & free_lun,outunit

  spawn,'ls -l '+basename+"*0.fits | sed -e 's/^.*users //'"
  spawn,'ls -l '+basename+"*0.fits | sed -e 's/^.*users //' >> "+outfile+'.tex'

  openw,outunit,outfile+'.tex',/get_lun,/APPEND
  printf,outunit,'\end{verbatim}'
  printf,outunit,''
  printf,outunit,'The file contains simulated data for the spectrum of a blackbody'
  printf,outunit,'with a temperature of ',fix(startemp),'\,K.'
  printf,outunit,''

  sof = strmid(file[0],0, strlen(file[0])-13)
  printf,outunit,'{\bf Set of Frames}:'
  printf,outunit,'\verbatiminput{../spectra/'+sof+'.sof}'

  print_cmd_stuff, outunit, 'starspectrum', '../spectra/'+sof+'.out'
  list_fbt_extensions,outunit,StSpec

  printf,outunit,'\smallskip'
  printf,outunit,''
  printf,outunit,'{\bf Output Data Contents}:\\'
  printf,outunit,'%'
  printf,outunit,'Primary Header: The following table contains the QC-keywords in the primary header.'
  printf,outunit,'\begin{longtable}{lccc}'
  printf,outunit,'Keyword & Value \\'
  printf,outunit,'\hline\endhead'
  printf,outunit,'\hline\endfoot'

  for k=0,N_elements(keywords)-1 do begin
      ;;print,k,keywords[k]
      key = stregex(keywords[k],'^HIERARCH ESO QC [A-Z0-9_ ]+[A-Z0-9_]',/Extract)
      if key ne '' then begin
          ;;print,"key ",key
          val = prihead->getpar(key)
          key = strmid(key,13)
          key = strjoin( strsplit(key,'_',/Extract),'\_')
          key = strjoin( strsplit(key,' ',/Extract),'.')

          if strmatch(key,'QC.EFFWAVE.*') then begin
              ch   = stregex(key,'[0-4]$',/Extract)
              waven= 1./ ((2.1 + ch/10.) * 1d-6)
              diff = val-waven
              color = (abs(diff/waven) lt 1d-5) ? 'green' : 'red'
              ;;print,"channel ",ch,waven,diff
              printf,outunit, key,'	& ',val,'	& ',waven,' & \color{',color,'}',diff,' \\'
          endif else begin
              printf,outunit, key,'	& ',val,'	\\'
          endelse
      endif
  end

  printf,outunit,'\hline'
  printf,outunit,'\end{longtable}'
  printf,outunit,'\bigskip'

  test_stspec, StSpec.spectrum->readrows(), outunit, outfile, startemp

  close,outunit & free_lun,outunit
  fbt_close,StSpec

  if keyword_set(tex) then spawn,"cd /home/rkoehler/PRIMA/Pacma_test_report; pdflatex Pacmap_test_report.tex"
end

pro test_stspec, StSptab, outunit, outfile, startemp

  common PACSIM_DEFAULTS	;; contains kappa_center, kappa_width

  if size(StSptab,/TYPE) ne 8 then begin
      print,"Unstructured data, probably an empty table"
      return
  endif

  printf,outunit,'\vbox{The {\tt SPECTRUM} table has this structure:'
  printf,outunit,'\smallskip'
  printf,outunit,'\begin{center}'
  dump_table_structure, outunit, StSptab
  printf,outunit,'\end{center}'
  printf,outunit,'}'

  restore,'throughput_FSUA.sav'
  print,"Star temperature:",startemp

  color= indgen(8)
  if !D.name eq 'PS' then begin
      device,file=outfile+'_gronk.ps',/landscape,/color
      color[1]= 0
      color[0]= 1
  end
  tek_color

  ;;plot, kappas[0,*], white[0,*], xrange=[min(kappas),max(kappas)],/xsty, yrange=[0,1.1],/ysty,$
  ;;  xtitle='kappa [m!u-1!n]', ytitle='Spectrum', linestyle=1, /nodata
  ;for ch=1,4 do oplot, kappas[ch,*], white[ch,*], color=color[ch+1], linestyle=1

  idx= where(StSptab.spectrum[0,*] gt 0.)
  wave0 = reform(StSptab.wavenumber[0,*])
  minkap= min( wave0[idx])	;; first kappa with signal
  print,"min kapp",minkap/1d6,"*1e6"

  kstep = kappas[0,1]-kappas[0,0]
  black = blackbody(kappas,kstep,startemp)

  ;idx = where(kappas gt minkap-kstep/2 and kappas lt minkap+kstep/2)
  ;print,"idx = ",idx
  ;print,"black= ",black[idx]
  ;if idx[0] gt -1 then black /= black[idx[0]]

  !P.multi= [0,2,3]

  scale = max(StSptab.spectrum)
  for ch=0,5 do begin
      ;junk='' & read,junk
      wave = reform(StSptab.wavenumber[ch,*])
      resp = reform(StSptab.spectrum[ch,*])
      ;;scale= median(resp[where(resp gt 0.)])
      idx = where(abs(wave-kappa_center[ch]) lt 444.)
      if idx[0] lt 0 then begin
         print,"Can't scale!"
         scale= 1.
      endif else scale= resp[idx[0]]
      ;;;print,"Channel",ch,", scale =",scale

      plot, wave, resp, xrange=[min(kappas),max(kappas)],/xsty, yrange=[-0.1,1.1],/ysty,$
            title="Channel "+strtrim(ch,2), xtitle='kappa [m!u-1!n]', ytitle='Spectrum',/nodata
      oplot, wave, resp, color=color[ch+1]

      ;;mink= min( wave[where(resp gt 0.)], max=maxk)
      ;;idx = where(kappas[ch,*] gt mink-kstep/2 and kappas[ch,*] lt maxk+kstep/2)
      ;;print,"idx = ",idx
      bscale = 1.
      bl = reform(black[ch,*])
      idx = where(abs(kappas[ch,*]-kappa_center[ch]) lt 444.)
      if idx[0] gt -1 then bscale= bl[idx[0]]

      oplot, reform(kappas[ch,*]), bl/bscale*scale, linest=2, color=color[ch+1]
  end

  !P.multi= [0]

  printf,outunit,'\vbox{\reportonly{The recipe did not crash.} The figure shows the computed stellar spectrum.'
  printf,outunit,'  The dashed lines are the spectrum of a blackbody with a temperature of '+string(startemp)+'\,K,'
  printf,outunit,'  normalized to match the computed spectrum at the central wavelength in each channel.'
  printf,outunit,'  The edges of the star spectrum are a bit ragged because of the low S/N at these wavenumbers.\vspace{-7mm}\par'
  printf,outunit,''
  printf,outunit,'\centerline{\hss\includegraphics[angle=180,width=1.2\textwidth]{../spectra/'+outfile+'_gronk.pdf}}}'
  printf,outunit,''
  printf,outunit,'As with the pacma\_vltiresponse recipe, the responses are nicely normalized so that the highest point is one.'
  ;;printf,outunit,'The highest point is in general a point where the FSU response is close to zero, so it is just noise amplified by the division by a small number.'

  if !D.name eq 'PS' then begin
      device,/close
      spawn,'ps2pdf '+outfile+'_gronk.ps'
  endif
end
