;
; vltiresp.pro
; Created:     Wed Jun  1 11:55:27 2011 by Rkoehler@lx40
; Last change: Wed Jun  1 16:21:36 2011
;
; PURPOSE:
;	none
;
; WARNING:
;	This program may contain strong violence, adult content, and
;	language.  Parental guidance is advised.
;
PRO vltiresp, file

  print,"Reading ",file[0]
  VLTIraw = fbt_open(file[0])

  prihead= VLTIraw.fileobj->prihead()
  Nslews = prihead->getpar('HIERARCH ESO INS OPDSCAN NSLEW')

  img_FSUA= VLTIraw.IMAGING_DATA_FSUA->readrows()

  fbt_close,VLTIraw


  ppslew = N_elements(img_FSUA)/Nslews	;; points per slew
  img_FSUA= reform(img_FSUA,ppslew,Nslews,/OVERWRITE)

  data = dblarr(4,6,ppslew,Nslews)	;; ABCD, spec-chan, point_in_scan, scan-no

  data[0,*,*,*] = img_FSUA.data1
  data[1,*,*,*] = img_FSUA.data2
  data[2,*,*,*] = img_FSUA.data3
  data[3,*,*,*] = img_FSUA.data4

  spectra = fft(data,DIM=3)

  spectra[*,*,0,*] = 0	;; nuke DC

  ;; compute magnitude and average over scans
  mags = total(abs(spectra),4) / Nslews

  plot, mags[0,0,100:180]
  for i=1,5 do oplot, mags[0,i,100:180],color=i+1

  ;junk='' & read,junk

  ;; cross spectra, average over scans, get rid of first dim

  crossAB = reform(total(spectra[0,*,*,*] * conj(spectra[3,*,*,*]),4) / Nslews)

  help,crossAB

  plot, imaginary(crossAB[0,100:180]),linest=1
  oplot,real_part(crossAB[0,100:180])

  ;plot, atan(crossAB[0,100:180],/PHASE)

  for i=1,5 do begin
     oplot,imaginary(crossAB[i,100:180]),color=i+1,linest=1
     oplot,real_part(crossAB[i,100:180]),color=i+1
     ;oplot,atan(crossAB[i,100:180],/PHASE),color=i+1
  endfor

  cross_ave = total(crossAB[*,100:180],2)

  print,"Re:",real_part(cross_ave)
  print,"Im:",imaginary(cross_ave)

  print,transpose(cross_ave)
  print,atan(cross_ave,/PHASE)*180./!dpi
end
