;+
; Name: print_wait
; 
; Purpose: print a message, but not too fast in succession
; 
; Explanation: Print a message if it's been at least 'wait' seconds since the last time we printed that message.  
;   Message and time are stored in common print_wait_common.
; 
; Input arguments: 
;   msg - message to print
; 
; Input keywords:
;   wait - seconds to wait before printing message again. Default = 3.
;   
; Written: Kim Tolbert, 26-Feb-2020
; Modifications:
;   
;-
pro print_wait, msg, wait=wait

checkvar, wait, 3.

common print_wait_common, save_time, save_msg

; Just return if data in common indicates we printed this msg less than wait seconds ago.
if exist(save_time) && same_data(msg, save_msg) && (systime(1) - save_time) lt wait then return

print, msg

; store in common
save_time = systime(1)
save_msg = msg

end