function make_grid,npix
  im=fltarr(npix,npix)
  center=floor(npix/2)

  dummy=dindgen(npix)
  im1=im
  im2=im
  for i=0,npix-1 do begin
    im1[*,i]=dummy
    im2[i,*]=dummy
  endfor

  im1=im1-center
  im2=im2-center
  im=sqrt(im1^2.+im2^2.) ;; contains distance to center in pixels
  return,im
end

pro test_gauss
  box=20. ;; box size
  npix=1024
  grid=make_grid(npix)
  grid=box/2.*grid/grid[0,npix/2]

  fwhm=3.
  sig=fwhm/2.355
  y=(box/npix)^2*(1./(2.*!dpi*sig^2))*exp(-grid^2./(2.*sig^2))
  tvscl,y

  total=total(y)
  indx=where(grid le fwhm/2.)
  total2=total(y[indx])
  print,'fraction of flux within fwhm: ',total2/total
  print,'total flux in 2D gaussian: ',total

end
