pro ellips
  npix=512
 
  aob_min=1.4
  aob_max=1.7
  n_aob=8
  a_over_b=aob_min+(aob_max-aob_min)*dindgen(n_aob)/(n_aob-1.)

  aob_meas=1.25 ;; measured a/b (not de-projected)

  print,'intrinsic a/b      observed a/b at i=41 degrees'
  aob_obs=0.*a_over_b
  for k=0,n_aob-1 do begin
    a=0.03
    a=a*npix
    b=a/a_over_b[k]
    c=a

    x=(dindgen(npix)-npix/2.)
    y=(dindgen(npix)-npix/2.)

    im=fltarr(npix,npix)

    for i=0,npix-1 do begin
      for j=0,npix-1 do begin
        if ((x[i]^2/a^2+y[j]^2/b^2) le c^2) then im[i,j]=1. else im[i,j]=0. 
      endfor
    endfor

    p=total(im,1)
    indx=where(p ne 0.)
    b_obs=1d0*n_elements(indx)
  ;  print,n_elements(indx)
  
    im=rot(im,41.)

    p=total(im,1)
    indx=where(p ne 0.)
    a_hat=1d0*n_elements(indx)
  ;  print,n_elements(indx)
  
    aob_obs[k]=a_hat/b_obs
    print,a_over_b[k],a_hat/b_obs
    tvscl,im
  endfor
  
  print,'intrinsic a/b for an observed aspect ratio of ',aob_meas,': ',$
        interpol(a_over_b,aob_obs,aob_meas)

end
