@~/idl/read_parameters
@~/idl/rgb
@read_vinci_data

function diff_func,p
common common1,az,s,ds,x

  y=p[0]+p[1]*cos(!dpi*(x-p[2])/90.) ;; periodicity must be 180 deg!
  model=interpol(y,x,az)

;  plot,az,s,/nodata,xrange=[-180,180],yrange=[0.01,0.025]
;  plots,az,s,psym=5
;  errplot,az,s-ds,s+ds
;  oplot,x,y

;  w=1./ds  ;; weighted by error
  w=1./ds^2 ;; weighted by error^2

  diff=total(w*(s-model)^2)
  return,diff
end  

function get_chisq,az,s,ds,a,silent=silent
  order=sort(az)
  model=a[0]+a[1]*cos(!dpi*(az-a[2])/90.)
;  plot,az[order],model[order],xstyle=2,ystyle=2
;  plots,az,s,psym=6

  chisquare=total((model-s)^2/ds^2)/n_elements(az)
  reduced_chisq=chisquare*n_elements(az)/(n_elements(az)-n_elements(a))
  if (not keyword_set(silent)) then $
    print,'reduced chi-square ',reduced_chisq
  return,reduced_chisq
end

function get_sigma,az,s,ds,a,index
  a_orig=a
  
  n=256
  range=2. ;; eplored x from (1/range to range)
  xmin=1./range
  xmax=range
  logx=alog(xmin)+dindgen(n)*alog(xmax/xmin)/(n-1.)
  x=exp(logx)

  chisq=fltarr(n)
  parn=chisq

  for i=0,n-1 do begin
    a[index]=x[i]*a_orig[index]
    parn[i]=a[index]-a_orig[index]
    chisq[i]=get_chisq(az,s,ds,a,/silent)
  endfor
  
;  value=2*min(chisq) ;; value for which chisquare doubles
  value=min(chisq)+1. ;; value for which chi-square increases by 1.

  sigma1=interpol(parn[n/2:n-1],chisq[n/2:n-1],value)
  sigma2=interpol(parn[0:n/2-1],chisq[0:n/2-1],value)

  sigma=min([abs(sigma1),abs(sigma2)])

;  plot,parn,chisq,yrange=[0,10],psym=-6
;  oplot,[-1d10,1d10],[value,value],line=2
;  plots,sigma1,value,color=rgb(255,0,0),psym=6
;  plots,sigma2,value,color=rgb(255,0,0),psym=6

  a=a_orig
  return,sigma
end

pro fit_behaviour,azimuth,sigmas_image,err_sigmas_image,ps=ps,$
                  illustration=illustration
common common1

  s=sigmas_image
  ds=err_sigmas_image
  az=azimuth

  nx=256
  xmin=min(az) & xmax=max(az)
  x=xmin+(xmax-xmin)*dindgen(nx)/(nx-1.)

  y0=mean(s)
  ampl=stddev(s)
  phi0=0.
  init=[y0,ampl,phi0]
  scale=[0.2*ampl,0.2*ampl,30.]

  a=amoeba(1d-6,function_name='diff_func',$
           p0=init,scale=scale,simplex=simplex)

  if (a[1] lt 0.) then begin ;; force positive amplitude
    a[1]=-a[1]
    a[2]=a[2]-90.
  endif

  if (a[2] lt 0) then begin ;; take positive position angle (180 degree degeneracy)
    a[2]=a[2]+180
  end

;  get_chisq,az,s,ds,a
;  a[2]=a[2]-11.
;  get_chisq,az,s,ds,a

  sig_a0=get_sigma(az,s,ds,a,0)
  sig_a1=get_sigma(az,s,ds,a,1)
  sig_a2=get_sigma(az,s,ds,a,2)

  fac=2.355*1d3
  print,'chi-square of fit: ',get_chisq(az,s,ds,a,/silent)

  print,'mean size: ',fac*a[0],' +/- ',fac*sig_a0,' mas'
  print,'amplitude: ',fac*a[1],' +/- ',fac*sig_a1,' mas'
  print,'position angle: ',a[2],' +/- ',sig_a2, ' degrees'
  print,'WARNING: the error values are rather arbitrary!'

  s=1d3*2.355*s ;; sigma (arcsec) -> fwhm (mas)
  ds=1d3*2.355*ds ;; sigma (arcsec) -> fwhm (mas)

  x=-360.+720.*dindgen(nx)/(nx-1.)
  y=1d3*2.355*(a[0]+a[1]*cos(!dpi*(x-a[2])/90.))

  xrange=mean(az)+[-90.,90.]
;  yrange=[0.9*min(s)<0.9*min(y),1.1*max(s)>1.1*max(y)]
  yrange=[0.8*min(y),1.2*max(y)]
  plot,az,s,/nodata,xrange=xrange,yrange=yrange,$
    xtitle='position angle (degrees East of North)',$
    ytitle='fwhm gaussian fit (mas)'
  plots,az,s,psym=5
  errplot,az,s-ds,s+ds
  oplot,x,y

;  print,'mean fwhm: ',1d3*2.355*a[0],' mas'
;  print,'fwhm amplitude: ',1d3*2.355*a[1],' mas'
;  print,'position angle semi-major axis: ',a[2],' degrees'
  print,'major/minor axis ratio: ',(a[0]+abs(a[1]))/(a[0]-abs(a[1]))
  print,'a: ',1d3*2.355*(a[0]+abs(a[1])),' mas    b: ',1d3*2.355*(a[0]-abs(a[1])),' mas'

  if not keyword_set(illustration) then begin
    labelx=0.47
    labely=0.86
    labelystep=0.06
    xyouts,labelx,labely,'mean fwhm: '+$
      strtrim(string(1d3*2.355*a[0],format='(f10.2)'),2)+' mas',/norm
    labely=labely-labelystep
    xyouts,labelx,labely,'fwhm amplitude: '+$
      strtrim(string(1d3*2.355*a[1],format='(f10.2)'),2)+' mas',/norm
    labely=labely-labelystep
    xyouts,labelx,labely,'P.A. semi-major axis: '+$
      strtrim(string(a[2],format='(f10.1)'),2)+' deg',/norm
  endif

end

function weighted_average,y,dy
  wa=total(y/dy)/total(1./dy)
  return,wa
end

pro fit_gaussians,baseline=baseline,plot=plot,ps=ps,fit=fit,$
                  illustration=illustration
common common1
  pars=read_parameters('parameters.txt')
;  inputfile='eta_car_vinci.txt'
;  inputfile='Eta_Car_2003_03_15.txt_short'
  inputfile='eta_car_070403.txt_short'

  if (inputfile eq 'eta_car_070403.txt_short') then $
    vinci=read_vinci_data(pars,inputfile,/tenplus) else $
    vinci=read_vinci_data(pars,inputfile)

  index=where(vinci.b_index eq baseline)

  B=vinci[index].B
  az=vinci[index].az
  v2=vinci[index].v2
  Ev2=vinci[index].Ev2
;print,v2,ev2
;print,weighted_average(Ev2,Ev2)

  ;; current definition az: East=0, positive clockwise (on sky!)
  if (inputfile eq 'eta_car_vinci.txt') then az=90-az
  ;; current definition az: North=0, positive counter-clockwise (on sky!),
  ;; so north=0, positive through east to south=180

  ;; current definition az: North=0, positive clockwise (on sky!)
  if (inputfile eq 'Eta_Car_2003_03_15.txt_short') then az=-az
  ;; current definition az: North=0, positive counter-clockwise (on sky!),
  ;; so north=0, positive through east to south=180



  dummy_index=where(az lt -180)
  if (dummy_index[0] ne -1) then az[dummy_index]=az[dummy_index]+360.

  print,'average V^2: ',weighted_average(v2,Ev2),$
        ' +/- ',stddev(v2),', at B=',weighted_average(B,Ev2),' m,',$
        ' average azimuth: ',weighted_average(az,Ev2),' degrees'
;print,'azimuth: ',az

;  az=az-90.
  ;; have all angles between -180 and 180 degrees

;  ha=vinci[index].ha
;  order=sort(ha)
;  print,ha[order]
;  print,''
;  print,az[order]


  low=V2-eV2
  high=V2+eV2
  k=B/(1d-6*2.196)/(180.*3600./!dpi)

;  plot,k,v2,/nodata,xrange=[42,54],yrange=[0.11,0.2]
;  plots,k,v2,psym=5
;  errplot,k,low,high
;  stop

  sigmas=0.*B
  err_sigmas=sigmas

  resolved=pars.resolved
;  if (baseline eq 103) then resolved=0.

  for i=0,n_elements(B)-1 do begin
    kdat=reform([0.,k[i]])
    V2dat=reform([1.,V2[i]])

    sigmas[i]=sqrt(-kdat[1]^2/(2.*alog(sqrt(V2dat[1])/(1.-resolved))))
    sigma_high=sqrt(-kdat[1]^2/(2.*alog(sqrt(V2dat[1]-eV2[i])/(1.-resolved))))
    err_sigmas[i]=abs(sigmas[i]-sigma_high)

    if keyword_set(plot) then begin
      plotk=2.*k[i]*dindgen(256)/255.
      plotV=(1.-resolved)*exp(-plotk^2/(2.*sigmas[i]^2))
      plotV2=plotV^2
      plot,plotk,plotV2
      plots,k[i],V2[i]
      errplot,k[i],low[i],high[i]
      aa=''
      read,aa
    endif
  endfor

  ;; sigmas contains sigmas in visibility-curve gaussian.
  ;; sigmas of intensity distribution scale with sigma_vis^-1
  sigmas_image=1./(2.*!dpi*sigmas)
  sigmas_image_low=1./(2.*!dpi*(sigmas+err_sigmas))
  err_sigmas_image=abs(sigmas_image-sigmas_image_low)

;  low=sigmas-err_sigmas
;  high=sigmas+err_sigmas
  low=sigmas_image-err_sigmas_image
  high=sigmas_image+err_sigmas_image

  dx=abs(max(az)-min(az))
  xrange=[min(az)-0.1*dx,max(az)+0.1*dx]
  dy=max(sigmas_image)-min(sigmas_image)
  yrange=[min(sigmas_image)-0.1*dy,max(sigmas_image)+0.1*dy]

  charsize=2.3
  if keyword_set(ps) then begin
    postscriptname='sigma_gaussian_'+$
     strtrim(string(baseline,format='(i10)'),2)+'m.ps'
    xsize=18.
    set_plot,'ps',/interpolate
    x_over_y=1.25 ;; ratio x_size/y_size
    device,file=postscriptname,/portrait,/color,bits_per_pixel=24,$
      font_size=16.,xsize=xsize,ysize=(xsize/x_over_y),yoffset=1
    charsize=1.4
  endif

  erase
;  plot,az,sigmas,/nodata,xrange=xrange,yrange=yrange,$
  plot,az,sigmas_image,/nodata,xrange=xrange,yrange=yrange,$
    xtitle='azimuth',$
    ytitle='fwhm gaussian fit (arbitrary units)',$
    title='Baseline '+strtrim(string(baseline,format='(i10)'),2)+' m, '+$
    strtrim(string(n_elements(B)),2)+' points'

;  plots,az,sigmas,psym=5
  plots,az,sigmas_image,psym=5
  errplot,az,low,high

  if keyword_set(fit) then fit_behaviour,az,sigmas_image,err_sigmas_image

  if keyword_set(ps) then begin
    device,/close
    set_plot,'x'
    if (not keyword_set(silent)) then $
    print,'wrote ',postscriptname
  endif

  if keyword_Set(illustration) then begin
    grey=165
    postscriptname='../FIGURES/figure3.ps'
    xsize=14.
    ysize=10
    set_plot,'ps',/interpolate
    device,file=postscriptname,/portrait,/color,$
      font_size=16.,xsize=xsize,ysize=ysize,yoffset=2,xoffset=2
    charsize=1.0
    TVLCT, [0,255,grey],[0,255,grey], [0,255,grey]
    ;; 0 = black
    ;; 1 = white
    ;; 2 = grey
    thick=3.  
    symsize=0.6

    !p.thick=thick
    !x.thick=thick
    !y.thick=thick
    !p.charthick=thick
 
    fit_behaviour,az,sigmas_image,err_sigmas_image,illustration=illustration

    device,/close
    set_plot,'x'
    print,'wrote ',postscriptname
  endif

end
