@~/idl/read_parameters
@read_vinci_data

pro ffunc,az,a,F,pder
  F=a[0]+a[1]*cos(!dpi*(az-a[2])/90.) ;; periodicity must be 180 deg!

;plot,az,F,/nodata
;plots,az,F,psym=4
;aa=''
;read,aa

  IF N_PARAMS() GE 4 THEN begin
     pder = fltarr(n_elements(az),n_elements(a))
     pder[*,0]=0.
     pder[*,1]=cos(!dpi*(az-a[2])/90.)
     pder[*,2]=(!dpi/90.)*sin(!dpi*(az-a[2])/90.)
  endif

end  

pro fit_behaviour,azimuth,sigmas_image,err_sigmas_image,ps=ps,$
                  illustration=illustration

  order=sort(azimuth)
  s=sigmas_image[order]*2.355*1d3
  ds=err_sigmas_image[order]*2.355*1d3
  az=azimuth[order]


  weights=1/ds^2

  y0=mean(s)
  ampl=stddev(s)
  phi0=130.
  init=[y0,ampl,phi0]
  scale=[0.2*ampl,0.2*ampl,30.]

  a=init
  print,a
  result=curvefit(az,s,weights,a,sigma,/double,function_name='ffunc',$
                  tol=1d-12,iter=iter,chisq=chisq)

print,iter,chisq
  plot,az,s,/nodata,xrange=xrange,yrange=yrange,$
    xtitle='position angle (degrees East of North)',$
    ytitle='fwhm gaussian fit (mas)'
  plots,az,s,psym=5
  errplot,az,s-ds,s+ds
  oplot,az,result

  
  
print,a
  return
stop
  if (a[1] lt 0.) then begin ;; force positive amplitude
    a[1]=-a[1]
    a[2]=a[2]-90.
  endif

  if (a[2] lt 0) then begin ;; take positive position angle (180 degree degeneracy)
    a[2]=a[2]+180
  end

  s=1d3*2.355*s ;; sigma (arcsec) -> fwhm (mas)
  ds=1d3*2.355*ds ;; sigma (arcsec) -> fwhm (mas)

  x=-360.+720.*dindgen(nx)/(nx-1.)
  y=1d3*2.355*(a[0]+a[1]*cos(!dpi*(x-a[2])/90.))

  xrange=mean(az)+[-90.,90.]
;  yrange=[0.9*min(s)<0.9*min(y),1.1*max(s)>1.1*max(y)]
  yrange=[0.8*min(y),1.2*max(y)]
  plot,az,s,/nodata,xrange=xrange,yrange=yrange,$
    xtitle='position angle (degrees East of North)',$
    ytitle='fwhm gaussian fit (mas)'
  plots,az,s,psym=5
  errplot,az,s-ds,s+ds
  oplot,x,y

  print,'mean fwhm: ',1d3*2.355*a[0],' mas'
  print,'fwhm amplitude: ',1d3*2.355*a[1],' mas'
  print,'position angle semi-major axis: ',a[2],' degrees'
  print,'major/minor axis ratio: ',(a[0]+abs(a[1]))/(a[0]-abs(a[1]))
  print,'a: ',1d3*2.355*(a[0]+abs(a[1])),' mas    b: ',1d3*2.355*(a[0]-abs(a[1])),' mas'

  if not keyword_set(illustration) then begin
    labelx=0.47
    labely=0.86
    labelystep=0.06
    xyouts,labelx,labely,'mean fwhm: '+$
      strtrim(string(1d3*2.355*a[0],format='(f10.2)'),2)+' mas',/norm
    labely=labely-labelystep
    xyouts,labelx,labely,'fwhm amplitude: '+$
      strtrim(string(1d3*2.355*a[1],format='(f10.2)'),2)+' mas',/norm
    labely=labely-labelystep
    xyouts,labelx,labely,'P.A. semi-major axis: '+$
      strtrim(string(a[2],format='(f10.1)'),2)+' deg',/norm
  endif

end

function weighted_average,y,dy
  wa=total(y/dy)/total(1./dy)
  return,wa
end

pro fit_gaussians_curvefit,baseline=baseline,plot=plot,ps=ps,fit=fit,$
                  illustration=illustration

  pars=read_parameters('parameters.txt')
;  inputfile='eta_car_vinci.txt'
  inputfile='Eta_Car_2003_03_15.txt_short'
  inputfile='eta_car_070403.txt_short'

  if (inputfile eq 'eta_car_070403.txt_short') then $
    vinci=read_vinci_data(pars,inputfile,/tenplus) else $
    vinci=read_vinci_data(pars,inputfile)

  index=where(vinci.b_index eq baseline)

  B=vinci[index].B
  az=vinci[index].az
  v2=vinci[index].v2
  Ev2=vinci[index].Ev2

  ;; current definition az: East=0, positive clockwise (on sky!)
  if (inputfile eq 'eta_car_vinci.txt') then az=90-az
  ;; current definition az: North=0, positive counter-clockwise (on sky!),
  ;; so north=0, positive through east to south=180

  ;; current definition az: North=0, positive clockwise (on sky!)
  if (inputfile eq 'Eta_Car_2003_03_15.txt_short') then az=-az
  ;; current definition az: North=0, positive counter-clockwise (on sky!),
  ;; so north=0, positive through east to south=180



  dummy_index=where(az lt -180)
  if (dummy_index[0] ne -1) then az[dummy_index]=az[dummy_index]+360.

;  print,'average V^2: ',weighted_average(v2,Ev2),$
;        ' +/- ',stddev(v2),', at B=',weighted_average(B,Ev2),' m,',$
;        ' average azimuth: ',weighted_average(az,Ev2),' degrees'
;print,'azimuth: ',az

;  az=az-90.
  ;; have all angles between -180 and 180 degrees

;  ha=vinci[index].ha
;  order=sort(ha)
;  print,ha[order]
;  print,''
;  print,az[order]


  low=V2-eV2
  high=V2+eV2
  k=B/(1d-6*2.196)/(180.*3600./!dpi)

;  plot,k,v2,/nodata,xrange=[42,54],yrange=[0.11,0.2]
;  plots,k,v2,psym=5
;  errplot,k,low,high
;  stop

  sigmas=0.*B
  err_sigmas=sigmas

  resolved=pars.resolved
;  if (baseline eq 103) then resolved=0.

  for i=0,n_elements(B)-1 do begin
    kdat=reform([0.,k[i]])
    V2dat=reform([1.,V2[i]])

    sigmas[i]=sqrt(-kdat[1]^2/(2.*alog(sqrt(V2dat[1])/(1.-resolved))))
    sigma_high=sqrt(-kdat[1]^2/(2.*alog(sqrt(V2dat[1]-eV2[i])/(1.-resolved))))
    err_sigmas[i]=abs(sigmas[i]-sigma_high)

    if keyword_set(plot) then begin
      plotk=2.*k[i]*dindgen(256)/255.
      plotV=(1.-resolved)*exp(-plotk^2/(2.*sigmas[i]^2))
      plotV2=plotV^2
      plot,plotk,plotV2
      plots,k[i],V2[i]
      errplot,k[i],low[i],high[i]
      aa=''
      read,aa
    endif
  endfor

  ;; sigmas contains sigmas in visibility-curve gaussian.
  ;; sigmas of intensity distribution scale with sigma_vis^-1
  sigmas_image=1./(2.*!dpi*sigmas)
  sigmas_image_low=1./(2.*!dpi*(sigmas+err_sigmas))
  err_sigmas_image=abs(sigmas_image-sigmas_image_low)

;  low=sigmas-err_sigmas
;  high=sigmas+err_sigmas
  low=sigmas_image-err_sigmas_image
  high=sigmas_image+err_sigmas_image

  dx=abs(max(az)-min(az))
  xrange=[min(az)-0.1*dx,max(az)+0.1*dx]
  dy=max(sigmas_image)-min(sigmas_image)
  yrange=[min(sigmas_image)-0.1*dy,max(sigmas_image)+0.1*dy]

  charsize=2.3
  if keyword_set(ps) then begin
    postscriptname='sigma_gaussian_'+$
     strtrim(string(baseline,format='(i10)'),2)+'m.ps'
    xsize=18.
    set_plot,'ps',/interpolate
    x_over_y=1.25 ;; ratio x_size/y_size
    device,file=postscriptname,/portrait,/color,bits_per_pixel=24,$
      font_size=16.,xsize=xsize,ysize=(xsize/x_over_y),yoffset=1
    charsize=1.4
  endif

  erase
;  plot,az,sigmas,/nodata,xrange=xrange,yrange=yrange,$
  plot,az,sigmas_image,/nodata,xrange=xrange,yrange=yrange,$
    xtitle='azimuth',$
    ytitle='fwhm gaussian fit (arbitrary units)',$
    title='Baseline '+strtrim(string(baseline,format='(i10)'),2)+' m, '+$
    strtrim(string(n_elements(B)),2)+' points'

;  plots,az,sigmas,psym=5
  plots,az,sigmas_image,psym=5
  errplot,az,low,high

  if keyword_set(fit) then fit_behaviour,az,sigmas_image,err_sigmas_image

  if keyword_set(ps) then begin
    device,/close
    set_plot,'x'
    if (not keyword_set(silent)) then $
    print,'wrote ',postscriptname
  endif

  if keyword_Set(illustration) then begin
    grey=165
    postscriptname='../FIGURES/figure3.ps'
    xsize=14.
    ysize=10
    set_plot,'ps',/interpolate
    device,file=postscriptname,/portrait,/color,$
      font_size=16.,xsize=xsize,ysize=ysize,yoffset=2,xoffset=2
    charsize=1.0
    TVLCT, [0,255,grey],[0,255,grey], [0,255,grey]
    ;; 0 = black
    ;; 1 = white
    ;; 2 = grey
    thick=3.  
    symsize=0.6

    !p.thick=thick
    !x.thick=thick
    !y.thick=thick
    !p.charthick=thick
 
    fit_behaviour,az,sigmas_image,err_sigmas_image,illustration=illustration

    device,/close
    set_plot,'x'
    print,'wrote ',postscriptname
  endif

end
