function read_vinci_data,pars,inputfile,tenplus=tenplus
  a=read_ascii(inputfile,com='#')
  if keyword_set(tenplus) then x=double(a.field01) else $
  x=double(a.field1)

  n=n_elements(x[0,*])
  one_meas={jd:0d0,nscans:0,B:0d0,az:0d0,v2:0d0,Ev2:0d0,ha:0d0,$
            b_index:0,B_E:0d0,B_N:0d0,B_L:0d0}

  vinci=replicate(one_meas,n)
  vinci.jd=reform(x[0,*])+reform(x[1,*])
  vinci.nscans=reform(x[2,*])
  vinci.B=reform(x[3,*])
  vinci.az=reform(x[4,*])
  vinci.v2=reform(x[5,*])
  vinci.eV2=reform(x[6,*])

  index=where(vinci.B lt 8.) ;; 8m baseline
  vinci[index].B_E=7.5463
  vinci[index].B_N=2.6127
  vinci[index].b_index=8

  index=where((vinci.B gt 8.) and (vinci.B lt 16.));; 16m baseline
  vinci[index].B_E=15.078
  vinci[index].B_N=5.354
  vinci[index].b_index=16

  index=where((vinci.B gt 16.) and (vinci.B lt 24.));; 24m baseline
  vinci[index].B_E=22.6874
  vinci[index].B_N=7.8124
  vinci[index].b_index=24

  index=where((vinci.B gt 24.) and (vinci.B lt 66.));; 66m baseline
  vinci[index].B_E=-36.498
  vinci[index].B_N=54.954
  vinci[index].b_index=66

  index=where((vinci.B gt 66.) and (vinci.B lt 103.));; UT1-UT3
  vinci[index].B_E=53.835
  vinci[index].B_N=87.166
  vinci[index].b_index=103

  ct2lst,lst,pars.obs_long,dummy,vinci.jd ;; lst=local siderial time
  vinci.ha=lst-pars.RA ;; hour angle of the observation [hours]

  return,vinci
end
