@~/idl/rgb


pro the_function,x,a,f,pder
  F=a[1]+a[2]*(x-a[0])+a[3]*(x-a[0])^2

  nx=n_elements(x)

  IF N_PARAMS() GE 4 THEN $
    pder = [[-a[2]-2.*a[3]*(x-a[0])],[replicate(1.,nx)],[replicate(-a[2],nx)],$
            [(x-a[0])^2]]

;  oplot,x,f,color=rgb(255,0,0)
;print,a

end

pro test_curvefit

  x=dindgen(400)/20.
  a0=10.
  a1=-30
  a2=0.
  a3=1.

  noise=4.1

  a=[a0,a1,a2,a3]
  y=a[1]+a[2]*(x-a[0])+a[3]*(x-a[0])^2
  plot,x,y

  y=y+noise*randomn(10.,n_elements(x))
  plots,x,y,psym=6

  weights=0.*x+1.
  init=[16.,-30.,0.1,1.1]
  a=init

  yfit=CURVEFIT(x,y,weights,a,sigma,FUNCTION_NAME='the_function',tol=1d-3)
  print,a,sigma

  oplot,x,yfit,color=rgb(255,0,0)

  F=a[1]+a[2]*(x-a[0])+a[3]*(x-a[0])^2
  oplot,x,f,color=rgb(0,255,0)




end
